/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.servicemodel.loader;

import com.mulesoft.connectivity.flow.api.metadata.FlowMetadataUtils;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.BindingSupport;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.ComponentRegistry;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.TypeFactory;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.r256.Patch;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.BindingsModel;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.Component;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.InParameterComponent;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.OperationComponent;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.OperationKind;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.OutParameterComponent;
import com.mulesoft.connectivity.linkweave.api.loader.TypeUtils;
import com.mulesoft.connectivity.linkweave.api.loader.WeaveTypeSimplifier;
import com.mulesoft.connectivity.linkweave.api.metadata.MetadataUtils;
import com.mulesoft.connectivity.linkweave.api.model.ExecutableComponentModel;
import com.mulesoft.connectivity.linkweave.api.model.TypeModel;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationModel;
import com.mulesoft.connectivity.linkweave.api.model.trigger.TriggerModel;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.mule.weave.v2.api.tooling.ts.ReferenceType;
import org.mule.weave.v2.ts.WeaveType;

public class ExecutableComponentLoader {
    private final ComponentRegistry componentRegistry;
    private final TypeFactory typeFactory;
    private final BindingSupport bindingSupport;
    private final Patch patch;

    public ExecutableComponentLoader(ComponentRegistry componentRegistry, TypeFactory typeFactory, Patch patch) {
        this.componentRegistry = componentRegistry;
        this.typeFactory = typeFactory;
        this.bindingSupport = new BindingSupport();
        this.patch = patch;
    }

    public void load(OperationModel operationModel, String version, Component outer) {
        BindingsModel bindings = BindingsModel.builder().paginated(operationModel.isPaginated()).queryBuilder(FlowMetadataUtils.isQueryBuilder(operationModel.getInputType().getDataType())).build();
        this.load(OperationKind.SYNCHRONOUS, (ExecutableComponentModel<?>)operationModel, outer, version, bindings.toString());
    }

    public void load(TriggerModel triggerModel, String version, Component outer) {
        BindingsModel bindings = BindingsModel.builder().paginated(triggerModel.isPaginated()).queryBuilder(FlowMetadataUtils.isQueryBuilder(triggerModel.getInputType().getDataType())).build();
        this.load(OperationKind.EVENT_SOURCE, (ExecutableComponentModel<?>)triggerModel, outer, version, bindings.toString());
    }

    private void load(OperationKind kind, ExecutableComponentModel<?> operationModel, Component outer, String version, String binding) {
        Component operationComponent = ((OperationComponent.OperationComponentBuilder)((OperationComponent.OperationComponentBuilder)((OperationComponent.OperationComponentBuilder)((OperationComponent.OperationComponentBuilder)((Component.ComponentBuilder)((OperationComponent.OperationComponentBuilder)OperationComponent.builder().name(operationModel.getName())).kind(kind.getValue())).description(operationModel.getDisplayName())).outer(outer.getId())).binding(binding)).version(version)).build();
        operationComponent = (OperationComponent)this.componentRegistry.registerComponent(operationComponent);
        this.loadInputType(operationModel.getInputType(), (OperationComponent)operationComponent, operationModel);
        this.loadOutputType(operationModel.getOutputType(), (OperationComponent)operationComponent, operationModel);
    }

    private void loadInputType(TypeModel inputType, OperationComponent outer, ExecutableComponentModel<?> operationModel) {
        DWType dataType = inputType.getDataType();
        for (KeyValuePairType fieldType : com.mulesoft.connectivity.flow.internal.util.TypeUtils.properties(dataType)) {
            this.typeFactory.getPathTracker().addToPath(fieldType.getKeyName());
            InParameterComponent inParameterComponent = (InParameterComponent)this.componentRegistry.registerComponent(((InParameterComponent.InParameterComponentBuilder)((InParameterComponent.InParameterComponentBuilder)((InParameterComponent.InParameterComponentBuilder)((Component.ComponentBuilder)((InParameterComponent.InParameterComponentBuilder)((InParameterComponent.InParameterComponentBuilder)((InParameterComponent.InParameterComponentBuilder)InParameterComponent.builder().name(fieldType.getKeyName())).outer(outer.getId())).required(!fieldType.isOptionalKey())).nullable(com.mulesoft.connectivity.flow.internal.util.TypeUtils.isFieldTypeNullable(fieldType))).description(MetadataUtils.getDescription((DWType)fieldType.getValue()).orElse(""))).label(MetadataUtils.getLabel((DWType)fieldType).orElse(null))).binding(this.bindingSupport.getInParameterBinding(operationModel, fieldType, fieldType.getKeyName()).orElse(null))).build());
            if (this.isObjectType(fieldType)) {
                parameterType = this.typeFactory.makeWithProvider(operationModel, fieldType.getValue(), inParameterComponent);
                parameterType = this.componentRegistry.registerComponent(parameterType);
                inParameterComponent.setParameterType(parameterType.getId());
                this.componentRegistry.updateComponent(inParameterComponent);
            } else {
                parameterType = this.typeFactory.make(fieldType.getValue(), inParameterComponent);
                parameterType = this.componentRegistry.registerComponent(parameterType);
                inParameterComponent.setParameterType(parameterType.getId());
                this.componentRegistry.updateComponent(inParameterComponent);
            }
            this.typeFactory.getPathTracker().popFromPath();
        }
    }

    private boolean isObjectType(KeyValuePairType fieldType) {
        return fieldType.getValue() instanceof ObjectType || fieldType.getValue() instanceof ReferenceType && TypeUtils.resolveReferenceType((DWType)fieldType.getValue()) instanceof ObjectType;
    }

    private void loadOutputType(TypeModel outputType, OperationComponent outer, ExecutableComponentModel<?> operationModel) {
        DWType dataType = outputType.getDataType();
        if (dataType instanceof ReferenceType) {
            dataType = TypeUtils.resolveReferenceType((DWType)dataType);
        }
        if (this.patch.shouldApplyOutParameterSoftIntersectionResolution(outer, this.typeFactory)) {
            dataType = WeaveTypeSimplifier.resolveIntersectionWithoutSimplification((WeaveType)((WeaveType)dataType));
        }
        OutParameterComponent outParameterComponent = (OutParameterComponent)this.componentRegistry.registerComponent(((OutParameterComponent.OutParameterComponentBuilder)((OutParameterComponent.OutParameterComponentBuilder)((OutParameterComponent.OutParameterComponentBuilder)OutParameterComponent.builder().name(dataType.getClass().getSimpleName())).outer(outer.getId())).binding(this.bindingSupport.getOutParameterBinding(operationModel).orElse(null))).build());
        Component parameterType = this.typeFactory.make(dataType, outParameterComponent);
        parameterType = this.componentRegistry.registerComponent(parameterType);
        outParameterComponent.setParameterType(parameterType.getId());
        this.componentRegistry.updateComponent(outParameterComponent);
    }
}

