/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler;

import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.ComponentRegistry;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.DateTimeTypeHandler;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.LocalDateTypeHandler;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.TypeFactory;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.TypeHandler;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.Component;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.PrimitiveTypeComponent;
import com.mulesoft.connectivity.linkweave.api.metadata.MetadataUtils;
import java.util.Optional;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.StringType;

class StringTypeHandler
extends TypeHandler {
    StringTypeHandler(ComponentRegistry componentRegistry) {
        super(componentRegistry);
    }

    @Override
    public boolean handles(DWType type) {
        return type instanceof StringType;
    }

    @Override
    public String getTypeName() {
        return "String";
    }

    @Override
    public Component make(DWType dwType, String typeName, Component outer, TypeFactory typeFactory) {
        assert (dwType instanceof StringType);
        Optional formatAnnotation = MetadataUtils.getFormat((DWType)dwType);
        if (formatAnnotation.isPresent()) {
            String format = (String)formatAnnotation.get();
            if ("date".equalsIgnoreCase(format)) {
                return new LocalDateTypeHandler(this.componentRegistry).make(dwType, typeName, outer, typeFactory);
            }
            if ("date-time".equalsIgnoreCase(format)) {
                return new DateTimeTypeHandler(this.componentRegistry).make(dwType, typeName, outer, typeFactory);
            }
        }
        return ((PrimitiveTypeComponent.PrimitiveTypeComponentBuilder)((PrimitiveTypeComponent.PrimitiveTypeComponentBuilder)PrimitiveTypeComponent.builder().name(this.getTypeName())).outer(this.componentRegistry.getServiceComponent().getId())).build();
    }
}

