/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.validator;

import com.mulesoft.connectivity.flow.api.validator.AbstractValidatorTest;
import com.mulesoft.connectivity.flow.api.validator.CollectedMessages;
import com.mulesoft.connectivity.flow.api.validator.rules.FlowConnectionsRule;
import com.mulesoft.connectivity.flow.api.validator.rules.FlowMessageRule;
import com.mulesoft.connectivity.flow.api.validator.rules.FlowMetadataProvidersRule;
import com.mulesoft.connectivity.flow.api.validator.rules.FlowOperationsRule;
import com.mulesoft.connectivity.flow.api.validator.rules.FlowTriggerRule;
import com.mulesoft.connectivity.flow.api.validator.rules.FlowTriggersRule;
import com.mulesoft.connectivity.flow.api.validator.rules.FlowValueProvidersRule;
import com.mulesoft.connectivity.flow.api.validator.rules.NoDynamicNamesRule;
import com.mulesoft.connectivity.flow.api.validator.rules.QueryBuilderUnionRule;
import com.mulesoft.connectivity.flow.api.validator.rules.RequiresValueProviderAnnotationRule;
import com.mulesoft.connectivity.flow.api.validator.rules.ResultSetsInTriggersRule;
import com.mulesoft.connectivity.flow.api.validator.rules.UnionRule;
import com.mulesoft.connectivity.validation.ValidationConfiguration;
import com.mulesoft.connectivity.validation.rules.ArrayRule;
import com.mulesoft.connectivity.validation.rules.ExecutorRule;
import com.mulesoft.connectivity.validation.rules.MessageRule;
import com.mulesoft.connectivity.validation.rules.ObjectRule;
import com.mulesoft.connectivity.validation.rules.OperationRule;
import com.mulesoft.connectivity.validation.rules.ProviderReferenceRule;
import com.mulesoft.connectivity.validation.rules.ReferenceRule;
import com.mulesoft.connectivity.validation.rules.TriggerRule;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
class TriggerValidatorTest
extends AbstractValidatorTest {
    TriggerValidatorTest() {
    }

    @Override
    protected ValidationConfiguration getValidationConfiguration() {
        return ValidationConfiguration.withRuleClasses((Class[])new Class[]{FlowValueProvidersRule.class, FlowMetadataProvidersRule.class, FlowOperationsRule.class, FlowTriggersRule.class, FlowConnectionsRule.class, OperationRule.class, ExecutorRule.class, MessageRule.class, FlowMessageRule.class, TriggerRule.class, FlowTriggerRule.class, ReferenceRule.class, ObjectRule.class, UnionRule.class, QueryBuilderUnionRule.class, ResultSetsInTriggersRule.class, NoDynamicNamesRule.class, ArrayRule.class, ProviderReferenceRule.class, RequiresValueProviderAnnotationRule.class});
    }

    private static String buildConnectorModule(String trigger) {
        return String.format("%%dw 2.7\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::Metadata\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::flow::Annotations\nimport * from com::mulesoft::connectivity::flow::QueryBuilder\nimport * from com::mulesoft::connectivity::decorator::Annotations\nimport * from com::mulesoft::connectivity::decorator::Trigger\nimport * from com::mulesoft::connectivity::decorator::ValueProvider\nimport * from com::mulesoft::connectivity::transport::Http\n%s\n\nvar queryBuilderObjectsValueProvider = defineValueProvider(???, ???)\n\n@FlowConnectorElement\nvar connector = {\n   triggers: {\n      testTrigger: testTrigger\n   },\n   valueProviders: {\n      queryBuilderObjectsValueProvider: queryBuilderObjectsValueProvider\n   }\n}", trigger);
    }

    @Test
    void acceptsConnectorWithNoTriggers() {
        this.assertCompileSuccessful("%dw 2.7\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::Metadata\nimport * from com::mulesoft::connectivity::flow::Metadata\ntype OperationInputType = {myProperty: String}\n\n@FlowConnectorElement\nvar connector = {\n}");
    }

    @Test
    void rejectsConnectorWithInvalidTriggersPropertyType() {
        CollectedMessages collectedMessages = this.assertCompileFailure("%dw 2.7\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::Metadata\nimport * from com::mulesoft::connectivity::flow::Metadata\n\n@FlowConnectorElement\nvar connector = {\n   triggers: []\n}");
        MatcherAssert.assertThat(collectedMessages.getErrors(), (Matcher)Matchers.hasSize((int)1));
        TriggerValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Invalid type for property 'triggers'. Expected: Object; Actual: Array<Nothing>", "connector", "\n8|    triggers: []\n      ^^^^^^^^^^^^");
    }

    @Test
    void rejectsTriggerWithNoInputMapper() {
        String trigger = "type OperationInputType = {myProperty: String}\ntype ItemType = {id: String, name: String}\n\nvar testOperation : Operation<OperationInputType, Array<ItemType>, ResultFailure<{}, Error>, Connection> = {\n    name: \"testOperation\",\n    displayName: \"Test\",\n    executor: (parameter, connection) -> success([])\n}\n\nvar testTriggerStrategy : TriggerStrategy<HttpResponse<Array<ItemType>>, ItemType, ItemType, String> =\n{\n    items: (result) -> result.body!,\n    item: (item) -> item,\n    watermark: (result,item) -> item.id,\n    identity: (item) -> item.id as String,\n    watermarkCompareTo: DefaultWatermarkComparison\n}\n\n@TriggerElement()\nvar testTrigger = {\n    name: \"testTrigger\",\n    displayName: \"Test Trigger\",\n    metadata: { order: \"ASC\", paginated: false },\n    strategy: testTriggerStrategy,\n    operation: testOperation,\n    initialWatermark: (triggerInput, connection) -> \"20200101\"\n}";
        CollectedMessages collectedMessages = this.assertCompileFailure(TriggerValidatorTest.buildConnectorModule(trigger));
        MatcherAssert.assertThat(collectedMessages.getErrors(), (Matcher)Matchers.hasSize((int)1));
        TriggerValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Missing 'inputMapper' property in trigger definition", "MissingRequiredProperty", "\n44|       testTrigger: testTrigger\n                       ^^^^^^^^^^^");
    }

    @Test
    void rejectsTriggerWithNoStrategy() {
        String trigger = "type OperationInputType = {myProperty: String}\ntype ItemType = {id: String, name: String}\n\nvar testOperation : Operation<OperationInputType, Array<ItemType>, ResultFailure<{}, Error>, Connection> = {\n    name: \"testOperation\",\n    displayName: \"Test\",\n    executor: (parameter, connection) -> success([])\n}\n\nvar testTriggerStrategy : TriggerStrategy<HttpResponse<Array<ItemType>>, ItemType, ItemType, String> =\n{\n    items: (result) -> result.body!,\n    item: (item) -> item,\n    watermark: (result,item) -> item.id,\n    identity: (item) -> item.id as String,\n    watermarkCompareTo: DefaultWatermarkComparison\n}\n\n@TriggerElement()\nvar testTrigger = {\n    name: \"testTrigger\",\n    displayName: \"Test Trigger\",\n    metadata: { order: \"ASC\", paginated: false },\n    inputMapper: (ti, w) -> ti,\n    operation: testOperation,\n    initialWatermark: (triggerInput, connection) -> \"20200101\"\n}";
        CollectedMessages collectedMessages = this.assertCompileFailure(TriggerValidatorTest.buildConnectorModule(trigger));
        MatcherAssert.assertThat(collectedMessages.getErrors(), (Matcher)Matchers.hasSize((int)1));
        TriggerValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Missing 'strategy' property in trigger definition", "MissingRequiredProperty", "\n44|       testTrigger: testTrigger\n                       ^^^^^^^^^^^");
    }

    @Test
    void acceptsTriggerWithoutInputMapperType() {
        String trigger = "type OperationInputType = {myProperty: String}\ntype ItemType = {id: String, name: String}\n\nvar testOperation : Operation<OperationInputType, Array<ItemType>, ResultFailure<{}, Error>, Connection> = {\n    name: \"testOperation\",\n    displayName: \"Test\",\n    executor: (parameter, connection) -> success([])\n}\n\nvar testTriggerStrategy : TriggerStrategy<HttpResponse<Array<ItemType>>, ItemType, ItemType, String> =\n{\n    items: (result) -> result.body!,\n    item: (item) -> item,\n    watermark: (result,item) -> item.id,\n    identity: (item) -> item.id as String,\n    watermarkCompareTo: DefaultWatermarkComparison\n}\n\n@TriggerElement()\nvar testTrigger = {\n    name: \"testTrigger\",\n    displayName: \"Test Trigger\",\n    metadata: { order: \"ASC\", paginated: false },\n    strategy: testTriggerStrategy,\n    operation: testOperation,\n    inputMapper: (ti : OperationInputType, w) -> ti,\n    initialWatermark: (triggerInput, connection) -> \"20200101\"\n}\n";
        this.assertCompileSuccessful(TriggerValidatorTest.buildConnectorModule(trigger));
    }

    @Test
    void acceptsTriggerWithInputMapperType() {
        String trigger = "type OperationInputType = {myProperty: String}\ntype ItemType = {id: String, name: String}\n\nvar testOperation : Operation<OperationInputType, Array<ItemType>, ResultFailure<{}, Error>, Connection> = {\n    name: \"testOperation\",\n    displayName: \"Test\",\n    executor: (parameter, connection) -> success([])\n}\n\nvar testTriggerStrategy : TriggerStrategy<HttpResponse<Array<ItemType>>, ItemType, ItemType, String> =\n{\n    items: (result) -> result.body!,\n    item: (item) -> item,\n    watermark: (result,item) -> item.id,\n    identity: (item) -> item.id as String,\n    watermarkCompareTo: DefaultWatermarkComparison\n}\n\n@TriggerElement()\nvar testTrigger = {\n    name: \"testTrigger\",\n    displayName: \"Test Trigger\",\n    metadata: { order: \"ASC\", paginated: false },\n    strategy: testTriggerStrategy,\n    operation: testOperation,\n    inputMapper: (ti, w) -> ti,\n    initialWatermark: (triggerInput, connection) -> \"20200101\"\n}\n";
        this.assertCompileSuccessful(TriggerValidatorTest.buildConnectorModule(trigger));
    }

    @Test
    void rejectsInputObjectPropertyWithRecursiveObjectType() {
        String trigger = "      type OperationInputType = {myProperty: OperationInputType}\n      type ItemType = {id: String, name: String}\n\n      var testOperation : Operation<OperationInputType, Array<ItemType>, ResultFailure<{}, Error>, Connection> = {\n          name: \"testOperation\",\n          displayName: \"Test\",\n          executor: (parameter, connection) -> success([])\n      }\n\n      var testTriggerStrategy : TriggerStrategy<HttpResponse<Array<ItemType>>, ItemType, ItemType, String> =\n      {\n          items: (result) -> result.body!,\n          item: (item) -> item,\n          watermark: (result,item) -> item.id,\n          identity: (item) -> item.id as String,\n          watermarkCompareTo: DefaultWatermarkComparison\n      }\n\n      @TriggerElement()\n      var testTrigger = {\n          name: \"testTrigger\",\n          displayName: \"Test Trigger\",\n          metadata: { order: \"ASC\", paginated: false },\n          strategy: testTriggerStrategy,\n          operation: testOperation,\n          inputMapper: (ti, w) -> ti,\n          initialWatermark: (triggerInput, connection) -> \"20200101\"\n      }\n";
        CollectedMessages collectedMessages = this.assertCompileFailure(TriggerValidatorTest.buildConnectorModule(trigger));
        MatcherAssert.assertThat(collectedMessages.getErrors(), (Matcher)Matchers.hasSize((int)1));
        TriggerValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Recursive reference to type OperationInputType at input.myProperty", "InvalidFlowType", "\n11|       type OperationInputType = {myProperty: OperationInputType}\n                                                 ^^^^^^^^^^^^^^^^^^");
    }

    @MethodSource(value={"getUnsupportedInputTypes"})
    @ParameterizedTest
    void rejectsUnsupportedInputTypes(AbstractValidatorTest.UnsupportedTypeTestParam param) {
        String trigger = String.format("  type ItemType = {id: String, name: String}\n\n  var testOperation : Operation<{}, Array<ItemType>, ResultFailure<{}, Error>, Connection> = {\n      name: \"testOperation\",\n      displayName: \"Test\",\n      executor: (parameter, connection) -> success([])\n  }\n\n  var testTriggerStrategy : TriggerStrategy<HttpResponse<Array<ItemType>>, ItemType, ItemType, String> =\n  {\n      items: (result) -> result.body!,\n      item: (item) -> item,\n      watermark: (result,item) -> item.id,\n      identity: (item) -> item.id as String,\n      watermarkCompareTo: DefaultWatermarkComparison\n  }\n\n  @TriggerElement()\n  var testTrigger = {\n      name: \"testTrigger\",\n      displayName: \"Test Trigger\",\n      metadata: { order: \"ASC\", paginated: false },\n      strategy: testTriggerStrategy,\n      operation: testOperation,\n      inputMapper: (ti : %s, w) -> ti,\n      initialWatermark: (triggerInput, connection) -> \"20200101\"\n  }\n", param.type);
        CollectedMessages collectedMessages = this.assertCompileFailure(TriggerValidatorTest.buildConnectorModule(trigger));
        MatcherAssert.assertThat(collectedMessages.getErrors(), (Matcher)Matchers.hasSize((int)1));
        TriggerValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), param.getExpectedMessage(param.reasons.get(0)), "InvalidFlowType", String.format("\n35|       inputMapper: (ti : %s, w) -> ti,\n                        ^^", param.type));
    }

    @ParameterizedTest
    @MethodSource(value={"getValidObjectTypes"})
    void acceptsInputObjectPropertyWithValidType(String type) {
        String trigger = String.format("  type ItemType = {id: String, name: String}\n\n  var testOperation : Operation<{}, Array<ItemType>, ResultFailure<{}, Error>, Connection> = {\n      name: \"testOperation\",\n      displayName: \"Test\",\n      executor: (parameter, connection) -> success([])\n  }\n\n  var testTriggerStrategy : TriggerStrategy<HttpResponse<Array<ItemType>>, ItemType, ItemType, String> =\n  {\n      items: (result) -> result.body!,\n      item: (item) -> item,\n      watermark: (result,item) -> item.id,\n      identity: (item) -> item.id as String,\n      watermarkCompareTo: DefaultWatermarkComparison\n  }\n\n  @TriggerElement()\n  var testTrigger = {\n      name: \"testTrigger\",\n      displayName: \"Test Trigger\",\n      metadata: { order: \"ASC\", paginated: false },\n      strategy: testTriggerStrategy,\n      operation: testOperation,\n      inputMapper: (ti : %s, w) -> ti,\n      initialWatermark: (triggerInput, connection) -> \"20200101\"\n  }\n", type);
        this.assertCompileSuccessful(TriggerValidatorTest.buildConnectorModule(trigger));
    }

    @Test
    void acceptsQueryBuilder() {
        String trigger = "var testOperation : Operation<{}, Array<{}>, ResultFailure<{}, Error>, Connection> = {\n    name: \"testOperation\",\n    displayName: \"Test\",\n    executor: (parameter, connection) -> success([])\n}\ntype QueryBuilderInputTypeTrigger = {\n    objectType: @ValuesFrom(value = { name: \"queryBuilderObjectsValueProvider\" }) String,\n    projectedFields: @FieldSelector()\n                     @Discriminator(value = {key: \"kind\", defaultSelection: \"ALL\"})\n                        (AllFieldsSelection | CustomFieldsSelection<@ValuesFrom(value = { name: \"queryBuilderFieldsValueProvider\", arguments: {objectType: \"/objectType\"}}) String>),\n    filter: @ResultSetFilter()\n            @Discriminator(value = {key: \"kind\", defaultSelection: \"NONE\"})\n                QueryFilter<\n                    @ValuesFrom(value = { name: \"queryBuilderFieldsValueProviderForTrigger\",\n                        arguments: {objectType: \"/objectType\" }}) String,\n                    @ValuesFrom(value = { name: \"queryBuilderOperatorsValueProvider\"}) String>,\n    orderBy?: @Discriminator(value = {key: \"kind\", defaultSelection: \"NOT_SORTED\"}) @FieldOrder() @MinSize(value= 1) @MaxSize(value= 2)\n      QueryFieldNoOrder | QueryManyFieldsManySortingOrder<@ValuesFrom(value = { name: \"queryBuilderFieldsValueProvider\", arguments: {objectType: \"/objectType\"}}) String>\n}\n\nvar queryBuilderTriggerStrategy : TriggerStrategy<Array<{}>, Object, Object, String> = {\n    items: (result) -> result,\n    item: (item) -> item,\n    watermark: (result, item) -> item.createdAt as String,\n    identity: (item) -> item.id as String,\n    watermarkCompareTo: DefaultWatermarkComparison\n}\n\n@TriggerElement()\nvar testTrigger = {\n      name: \"testTrigger\",\n      displayName: \"Test Trigger\",\n      metadata: {\n          order: \"ASC\",\n          paginated: false\n      },\n      strategy: queryBuilderTriggerStrategy,\n      operation: testOperation,\n      inputMapper: (param: QueryBuilderInputTypeTrigger, watermark: String) ->\n                        {query: { query: \"q\" }, headers: {}, cookie: {}},\n      initialWatermark: (triggerInput, connection) -> |2025-01-01T12:00:00.000-00:00|\n}";
        this.assertCompileSuccessful(TriggerValidatorTest.buildConnectorModule(trigger));
    }

    @Test
    void rejectsQueryBuilderAnnotation() {
        String trigger = "var testOperation : Operation<{}, Array<{}>, ResultFailure<{}, Error>, Connection> = {\n    name: \"testOperation\",\n    displayName: \"Test\",\n    executor: (parameter, connection) -> success([])\n}\ntype QueryBuilderInputTypeTrigger = @QueryBuilder() {\n    objectType: @ValuesFrom(value = { name: \"queryBuilderObjectsValueProvider\" }) String,\n    projectedFields: @FieldSelector()\n                     @Discriminator(value = {key: \"kind\", defaultSelection: \"ALL\"})\n                        (AllFieldsSelection | CustomFieldsSelection<@ValuesFrom(value = { name: \"queryBuilderFieldsValueProvider\", arguments: {objectType: \"/objectType\"}}) String>),\n    filter: @ResultSetFilter()\n            @Discriminator(value = {key: \"kind\", defaultSelection: \"NONE\"})\n                QueryFilter<\n                    @ValuesFrom(value = { name: \"queryBuilderFieldsValueProviderForTrigger\",\n                        arguments: {objectType: \"/objectType\" }}) String,\n                    @ValuesFrom(value = { name: \"queryBuilderOperatorsValueProvider\"}) String>\n}\n\nvar queryBuilderTriggerStrategy : TriggerStrategy<Array<{}>, Object, Object, String> = {\n    items: (result) -> result,\n    item: (item) -> item,\n    watermark: (result, item) -> item.createdAt as String,\n    identity: (item) -> item.id as String,\n    watermarkCompareTo: DefaultWatermarkComparison\n}\n\n@TriggerElement()\nvar testTrigger = {\n      name: \"testTrigger\",\n      displayName: \"Test Trigger\",\n      metadata: {\n          order: \"ASC\",\n          paginated: false\n      },\n      strategy: queryBuilderTriggerStrategy,\n      operation: testOperation,\n      inputMapper: (param: QueryBuilderInputTypeTrigger, watermark: String) ->\n                        {query: { query: \"q\" }, headers: {}, cookie: {}},\n      initialWatermark: (triggerInput, connection) -> |2025-01-01T12:00:00.000-00:00|\n}";
        CollectedMessages collectedMessages = this.assertCompileFailure(TriggerValidatorTest.buildConnectorModule(trigger));
        MatcherAssert.assertThat(collectedMessages.getErrors(), (Matcher)Matchers.hasSize((int)1));
        TriggerValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Trigger must not have a QueryBuilder annotation, at input: {\n  objectType: String, \n  projectedFields: AllFieldsSelection | CustomFieldsSelection<String>, \n  filter: QueryFilter<String, String>\n}", "InvalidFlowType", "\n47|       inputMapper: (param: QueryBuilderInputTypeTrigger, watermark: String) ->\n                               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
    }

    @Test
    void rejectsQueryBuilderWithoutAnd() {
        String trigger = "var testOperation : Operation<{}, Array<{}>, ResultFailure<{}, Error>, Connection> = {\n    name: \"testOperation\",\n    displayName: \"Test\",\n    executor: (parameter, connection) -> success([])\n}\ntype QueryBuilderInputTypeTrigger = {\n    objectType: @ValuesFrom(value = { name: \"queryBuilderObjectsValueProvider\" }) String,\n    projectedFields: @FieldSelector()\n                     @Discriminator(value = {key: \"kind\", defaultSelection: \"ALL\"})\n                        (AllFieldsSelection | CustomFieldsSelection<@ValuesFrom(value = { name: \"queryBuilderFieldsValueProvider\", arguments: {objectType: \"/objectType\"}}) String>),\n    filter: @ResultSetFilter()\n            @Discriminator(value = {key: \"kind\", defaultSelection: \"NONE\"})\n                (NoQueryFilter | OrQueryFilter<\n                    @ValuesFrom(value = { name: \"queryBuilderFieldsValueProviderForTrigger\",\n                        arguments: {objectType: \"/objectType\" }}) String,\n                    @ValuesFrom(value = { name: \"queryBuilderOperatorsValueProvider\"}) String>)\n}\n\nvar queryBuilderTriggerStrategy : TriggerStrategy<Array<{}>, Object, Object, String> = {\n    items: (result) -> result,\n    item: (item) -> item,\n    watermark: (result, item) -> item.createdAt as String,\n    identity: (item) -> item.id as String,\n    watermarkCompareTo: DefaultWatermarkComparison\n}\n\n@TriggerElement()\nvar testTrigger = {\n      name: \"testTrigger\",\n      displayName: \"Test Trigger\",\n      metadata: {\n          order: \"ASC\",\n          paginated: false\n      },\n      strategy: queryBuilderTriggerStrategy,\n      operation: testOperation,\n      inputMapper: (param: QueryBuilderInputTypeTrigger, watermark: String) ->\n                        {query: { query: \"q\" }, headers: {}, cookie: {}},\n      initialWatermark: (triggerInput, connection) -> |2025-01-01T12:00:00.000-00:00|\n}";
        CollectedMessages collectedMessages = this.assertCompileFailure(TriggerValidatorTest.buildConnectorModule(trigger));
        MatcherAssert.assertThat(collectedMessages.getErrors(), (Matcher)Matchers.hasSize((int)1));
        TriggerValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Trigger must support having 'AND' conditions, at input: NoQueryFilter | OrQueryFilter<String, String>", "InvalidFlowType", "\n21|     filter: @ResultSetFilter()\n  |  ...\n26|                     @ValuesFrom(value = { name: \"queryBuilderOperatorsValueProvider\"}) String>)\n");
    }
}

