/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.connection;

import com.mulesoft.connectivity.flow.internal.connection.ConnectionInputTypeInformation;
import com.mulesoft.connectivity.flow.internal.connection.ConnectionInputTypeInformationFactory;
import com.mulesoft.connectivity.flow.internal.connection.ConnectionInputTypeInformationFactoryTest;
import com.mulesoft.connectivity.flow.internal.connection.Connections;
import com.mulesoft.connectivity.flow.internal.connection.ConnectionsFactory;
import com.mulesoft.connectivity.linkweave.api.model.connection.AuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.AuthenticationTypeVisitor;
import com.mulesoft.connectivity.linkweave.api.model.connection.ConnectionProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.HttpAuthenticationType;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ConnectionsFactoryTest {
    @Test
    @DisplayName(value="GIVEN a connector model with 2 connector providers\nWHEN the connections factory is called\nTHEN creates two input types and authentication list items\n")
    public void connectionsFactoryReturnsConnectionsOnInputTypes() {
        ConnectionInputTypeInformationFactory mockConnectionInputTypeInformationFactory = (ConnectionInputTypeInformationFactory)Mockito.mock(ConnectionInputTypeInformationFactory.class);
        ConnectionsFactory connectionsFactory = new ConnectionsFactory(mockConnectionInputTypeInformationFactory);
        Mockito.when((Object)mockConnectionInputTypeInformationFactory.createConnectionInputTypeInformation((ConnectionProviderModel)ArgumentMatchers.any())).thenReturn((Object)new ConnectionInputTypeInformation("", List.of(), false, "com::bla"));
        Connections connections = connectionsFactory.fromConnectorModel("connectorName", List.of((ConnectionProviderModel)((ConnectionProviderModel.Builder)ConnectionInputTypeInformationFactoryTest.connectionProviderModelBuilder().name("name1")).build(), (ConnectionProviderModel)((ConnectionProviderModel.Builder)ConnectionInputTypeInformationFactoryTest.connectionProviderModelBuilder().name("name2")).build()));
        Assertions.assertEquals((int)2, (int)connections.getInputTypeInformation().size());
        Assertions.assertEquals((int)2, (int)connections.getAuthenticationList().size());
    }

    @Test
    @DisplayName(value="GIVEN a connection with HttpAuthenticationType\nWHEN the connections factory is called\nTHEN creates a connection with those values in authenticationList\n")
    public void connectionsFactoryReturnsConnectionsOnHttpAuthenticationType() {
        ConnectionInputTypeInformationFactory mockConnectionInputTypeInformationFactory = (ConnectionInputTypeInformationFactory)Mockito.mock(ConnectionInputTypeInformationFactory.class);
        ConnectionsFactory connectionsFactory = new ConnectionsFactory(mockConnectionInputTypeInformationFactory);
        Mockito.when((Object)mockConnectionInputTypeInformationFactory.createConnectionInputTypeInformation((ConnectionProviderModel)ArgumentMatchers.any())).thenReturn((Object)new ConnectionInputTypeInformation("", List.of(), false, "com::bla"));
        Connections connections = connectionsFactory.fromConnectorModel("connectorName", List.of((ConnectionProviderModel)((ConnectionProviderModel.Builder)((ConnectionProviderModel.Builder)ConnectionInputTypeInformationFactoryTest.connectionProviderModelBuilder().authenticationType((AuthenticationType)new HttpAuthenticationType(HttpAuthenticationType.Type.bearer, null))).name("name1")).build()));
        Assertions.assertEquals((int)1, (int)connections.getAuthenticationList().size());
        Map authenticationMap = (Map)connections.getAuthenticationList().get(0);
        Assertions.assertEquals((Object)"bearer", authenticationMap.get("type"));
        Assertions.assertNull(authenticationMap.get("subType"));
    }

    @Test
    @DisplayName(value="GIVEN a connection with AuthenticationType not descending from HttpAuthenticationType\nWHEN the connections factory is called\nTHEN creates a connection without such authentication type\n")
    public void connectionsFactoryReturnsConnectionsOnApiKeyHttpAuthenticationType() {
        ConnectionInputTypeInformationFactory mockConnectionInputTypeInformationFactory = (ConnectionInputTypeInformationFactory)Mockito.mock(ConnectionInputTypeInformationFactory.class);
        ConnectionsFactory connectionsFactory = new ConnectionsFactory(mockConnectionInputTypeInformationFactory);
        Mockito.when((Object)mockConnectionInputTypeInformationFactory.createConnectionInputTypeInformation((ConnectionProviderModel)ArgumentMatchers.any())).thenReturn((Object)new ConnectionInputTypeInformation("", List.of(), false, "com::bla"));
        Connections connections = connectionsFactory.fromConnectorModel("connectorName", List.of((ConnectionProviderModel)((ConnectionProviderModel.Builder)((ConnectionProviderModel.Builder)ConnectionInputTypeInformationFactoryTest.connectionProviderModelBuilder().authenticationType(new AuthenticationType(){

            public void accept(AuthenticationTypeVisitor authenticationTypeVisitor) {
            }
        })).name("name1")).build()));
        Assertions.assertTrue((boolean)connections.getAuthenticationList().isEmpty());
    }
}

