/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler;

import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.ComponentRegistry;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.R256TypeFactory;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.TypeFactory;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.TypeHandlerTestUtils;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.UnionTypeHandler;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.r256.Patch;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.Component;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.ObjectTypeComponent;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.PrimitiveTypeComponent;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.PropertyComponent;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.ServiceComponent;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.ts.StringType;
import scala.Option;

public class UnionTypeHandlerTest {
    private final DataWeaveScriptingEngine engine = new DataWeaveScriptingEngine();

    @Nested
    @DisplayName(value="Edge Cases and Error Conditions")
    public class ObjectOrNullReference {
        private ComponentRegistry componentRegistry;
        private TypeFactory typeFactory;
        private UnionTypeHandler unionTypeHandler;
        private Component serviceComponent;
        private Component outerComponent;

        @BeforeEach
        void setUp() {
            this.componentRegistry = new ComponentRegistry();
            this.typeFactory = new R256TypeFactory(this.componentRegistry, Patch.fromResource((String)"patch.json"));
            this.unionTypeHandler = new UnionTypeHandler(this.componentRegistry);
            this.serviceComponent = ((ServiceComponent.ServiceComponentBuilder)ServiceComponent.builder().name("serviceName")).build();
            this.componentRegistry.registerComponent(this.serviceComponent);
            this.outerComponent = ((ObjectTypeComponent.ObjectTypeComponentBuilder)((ObjectTypeComponent.ObjectTypeComponentBuilder)ObjectTypeComponent.builder().outer("1")).name("OuterComponent")).build();
            this.componentRegistry.registerComponent(this.outerComponent);
        }

        @Test
        public void referenceToObjectOrNullRegisteredAsTopLevelElement() {
            String script = "%dw 2.8\ntype Root = {\n   a: String,\n} | Null\n---\nRoot\n";
            Component actualComponent = TypeHandlerTestUtils.processDataWeaveScript(script, this.unionTypeHandler, this.serviceComponent, this.typeFactory);
            Assertions.assertEquals((Object)"Root", (Object)actualComponent.getName());
            Assertions.assertEquals((Object)"1", (Object)actualComponent.getOuter(), (String)"Service Id is the Outer");
        }
    }

    @Nested
    @DisplayName(value="Edge Cases and Error Conditions")
    public class EdgeCasesAndErrorConditions {
        private ComponentRegistry componentRegistry;
        private TypeFactory typeFactory;
        private UnionTypeHandler unionTypeHandler;
        private Component serviceComponent;

        @BeforeEach
        void setUp() {
            this.componentRegistry = new ComponentRegistry();
            this.typeFactory = new R256TypeFactory(this.componentRegistry, Patch.fromResource((String)"patch.json"));
            this.unionTypeHandler = new UnionTypeHandler(this.componentRegistry);
            this.serviceComponent = ((ServiceComponent.ServiceComponentBuilder)ServiceComponent.builder().name("serviceName")).build();
            this.componentRegistry.registerComponent(this.serviceComponent);
        }

        @Test
        @DisplayName(value="GIVEN union with only Null and Any types WHEN processed THEN returns Any primitive")
        public void testEmptyUnionAfterFiltering() {
            String script = "%dw 2.8\ntype Root = Null | Any\n---\nRoot\n";
            Component actualComponent = TypeHandlerTestUtils.processDataWeaveScript(script, this.unionTypeHandler, this.serviceComponent, this.typeFactory);
            Assertions.assertNotNull((Object)actualComponent, (String)"Empty union after filtering should create a component");
            Assertions.assertTrue((boolean)(actualComponent instanceof PrimitiveTypeComponent), (String)"Should return primitive type");
            PrimitiveTypeComponent primitiveComponent = (PrimitiveTypeComponent)actualComponent;
            Assertions.assertEquals((Object)"Any", (Object)primitiveComponent.getName(), (String)"Empty union should fallback to Any type");
        }

        @Test
        @DisplayName(value="GIVEN heterogeneous union with different type classes WHEN processed THEN throws RuntimeException")
        @Disabled
        public void testHeterogeneousUnionError() {
            String script = "%dw 2.8\ntype Root = String | Number | Boolean\n---\nRoot\n";
            RuntimeException exception = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> TypeHandlerTestUtils.processDataWeaveScript(script, this.unionTypeHandler, this.serviceComponent, this.typeFactory));
            Assertions.assertTrue((boolean)exception.getMessage().contains("Error: Not Heterogeneous Union"), (String)"Should throw RuntimeException for heterogeneous union");
            Assertions.assertTrue((boolean)exception.getMessage().contains("Root"), (String)"Error message should contain the type name");
            Assertions.assertTrue((boolean)exception.getMessage().contains("serviceName"), (String)"Error message should contain the service name");
        }

        @Test
        @DisplayName(value="GIVEN homogeneous union of strings WHEN processed THEN returns String primitive")
        public void testHomogeneousStringUnion() {
            String script = "%dw 2.8\ntype Root = \"value1\" | \"value2\" | \"value3\"\n---\nRoot\n";
            Component actualComponent = TypeHandlerTestUtils.processDataWeaveScript(script, this.unionTypeHandler, this.serviceComponent, this.typeFactory);
            Assertions.assertNotNull((Object)actualComponent, (String)"Homogeneous string union should create a component");
            Assertions.assertTrue((boolean)(actualComponent instanceof PrimitiveTypeComponent), (String)"Should return primitive type");
            PrimitiveTypeComponent primitiveComponent = (PrimitiveTypeComponent)actualComponent;
            Assertions.assertEquals((Object)"String", (Object)primitiveComponent.getName(), (String)"Homogeneous string union should resolve to String");
        }

        @Test
        @DisplayName(value="GIVEN homogeneous union of booleans WHEN processed THEN returns Boolean primitive")
        public void testHomogeneousBooleanUnion() {
            String script = "%dw 2.8\ntype Root = true | false\n---\nRoot\n";
            Component actualComponent = TypeHandlerTestUtils.processDataWeaveScript(script, this.unionTypeHandler, this.serviceComponent, this.typeFactory);
            Assertions.assertNotNull((Object)actualComponent, (String)"Homogeneous boolean union should create a component");
            Assertions.assertTrue((boolean)(actualComponent instanceof PrimitiveTypeComponent), (String)"Should return primitive type");
            PrimitiveTypeComponent primitiveComponent = (PrimitiveTypeComponent)actualComponent;
            Assertions.assertEquals((Object)"Boolean", (Object)primitiveComponent.getName(), (String)"Homogeneous boolean union should resolve to Boolean");
        }

        @Test
        @DisplayName(value="GIVEN homogeneous union of numbers WHEN processed THEN returns Number primitive")
        public void testHomogeneousNumberUnion() {
            String script = "%dw 2.8\ntype Root = 1 | 2 | 3\n---\nRoot\n";
            Component actualComponent = TypeHandlerTestUtils.processDataWeaveScript(script, this.unionTypeHandler, this.serviceComponent, this.typeFactory);
            Assertions.assertNotNull((Object)actualComponent, (String)"Homogeneous number union should create a component");
            Assertions.assertTrue((boolean)(actualComponent instanceof PrimitiveTypeComponent), (String)"Should return primitive type");
            PrimitiveTypeComponent primitiveComponent = (PrimitiveTypeComponent)actualComponent;
            Assertions.assertEquals((Object)"Double", (Object)primitiveComponent.getName(), (String)"Homogeneous number union should resolve to Double");
        }

        @Test
        @DisplayName(value="GIVEN non-UnionType passed to UnionTypeHandler WHEN processed THEN throws AssertionError")
        public void testNonUnionTypeAssertionError() {
            StringType nonUnionType = new StringType(Option.empty());
            AssertionError error = (AssertionError)((Object)Assertions.assertThrows(AssertionError.class, () -> this.lambda$testNonUnionTypeAssertionError$1((DWType)nonUnionType)));
            Assertions.assertNotNull((Object)error, (String)"Should throw AssertionError when non-UnionType is passed");
        }

        private /* synthetic */ void lambda$testNonUnionTypeAssertionError$1(DWType nonUnionType) throws Throwable {
            this.unionTypeHandler.make(nonUnionType, "TestType", this.serviceComponent, this.typeFactory);
        }
    }

    @Nested
    @DisplayName(value="Nested Unions")
    public class NestedUnions {
        private ComponentRegistry componentRegistry;
        private TypeFactory typeFactory;
        private UnionTypeHandler unionTypeHandler;
        private Component serviceComponent;

        @BeforeEach
        void setUp() {
            this.componentRegistry = new ComponentRegistry();
            this.typeFactory = new R256TypeFactory(this.componentRegistry, Patch.fromResource((String)"patch.json"));
            this.unionTypeHandler = new UnionTypeHandler(this.componentRegistry);
            this.serviceComponent = ((ServiceComponent.ServiceComponentBuilder)ServiceComponent.builder().name("serviceName")).build();
            this.componentRegistry.registerComponent(this.serviceComponent);
        }

        @Test
        @DisplayName(value="GIVEN union of union of enums WHEN processed THEN flattens to String primitive")
        public void testUnionOfUnionOfEnums() {
            String script = "%dw 2.8\ntype Root = SubRoot | \"three\"\ntype SubRoot = \"one\" | \"two\"\n---\nRoot\n";
            Component actualComponent = TypeHandlerTestUtils.processDataWeaveScript(script, this.unionTypeHandler, this.serviceComponent, this.typeFactory);
            Assertions.assertNotNull((Object)actualComponent, (String)"Nested union should create a component");
            Assertions.assertTrue((boolean)(actualComponent instanceof PrimitiveTypeComponent), (String)"Union of string literals should resolve to primitive");
            PrimitiveTypeComponent primitiveComponent = (PrimitiveTypeComponent)actualComponent;
            Assertions.assertEquals((Object)"String", (Object)primitiveComponent.getName(), (String)"Nested union of string literals should resolve to String type");
        }

        @Test
        @DisplayName(value="GIVEN union of union with null types WHEN processed THEN throws RuntimeException for heterogeneous union")
        @Disabled
        public void testUnionWithNullTypes() {
            String script = "%dw 2.8\ntype Root = SubRoot | Null\ntype SubRoot = Number | String\n---\nRoot\n";
            RuntimeException exception = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> TypeHandlerTestUtils.processDataWeaveScript(script, this.unionTypeHandler, this.serviceComponent, this.typeFactory));
            Assertions.assertTrue((boolean)exception.getMessage().contains("Error: Not Heterogeneous Union"), (String)"Should throw RuntimeException for heterogeneous union after null filtering");
            Assertions.assertTrue((boolean)exception.getMessage().contains("Root"), (String)"Error message should contain the type name");
            Assertions.assertTrue((boolean)exception.getMessage().contains("serviceName"), (String)"Error message should contain the service name");
        }

        @Test
        @DisplayName(value="GIVEN union of string with null WHEN processed THEN returns String primitive without nullable property")
        public void testUnionStringWithNullFiltersOutNull() {
            String script = "%dw 2.8\ntype Root = String | Null\n---\nRoot\n";
            Component actualComponent = TypeHandlerTestUtils.processDataWeaveScript(script, this.unionTypeHandler, this.serviceComponent, this.typeFactory);
            Assertions.assertNotNull((Object)actualComponent, (String)"String union with null should create a component");
            Assertions.assertTrue((boolean)(actualComponent instanceof PrimitiveTypeComponent), (String)"Should resolve to primitive type");
            PrimitiveTypeComponent primitiveComponent = (PrimitiveTypeComponent)actualComponent;
            Assertions.assertEquals((Object)"String", (Object)primitiveComponent.getName(), (String)"Union of String | Null should resolve to String type");
        }
    }

    @Nested
    @DisplayName(value="Object Unions")
    public class ObjectUnions {
        private ComponentRegistry componentRegistry;
        private TypeFactory typeFactory;
        private UnionTypeHandler unionTypeHandler;
        private Component serviceComponent;

        @BeforeEach
        void setUp() {
            this.componentRegistry = new ComponentRegistry();
            this.typeFactory = new R256TypeFactory(this.componentRegistry, Patch.fromResource((String)"patch.json"));
            this.unionTypeHandler = new UnionTypeHandler(this.componentRegistry);
            this.serviceComponent = ((ServiceComponent.ServiceComponentBuilder)ServiceComponent.builder().name("serviceName")).build();
            this.componentRegistry.registerComponent(this.serviceComponent);
        }

        @Test
        @DisplayName(value="GIVEN union of object types WHEN processed THEN creates combined object with all properties optional")
        public void testUnionOfObjectTypes() {
            String script = "%dw 2.8\ntype Root = {name: String} | {age: String} | {id: String}\n---\nRoot\n";
            Component actualComponent = TypeHandlerTestUtils.processDataWeaveScript(script, this.unionTypeHandler, this.serviceComponent, this.typeFactory);
            Assertions.assertNotNull((Object)actualComponent, (String)"Union of objects should create a component");
            Assertions.assertTrue((boolean)(actualComponent instanceof ObjectTypeComponent), (String)"Union of objects should create an ObjectTypeComponent");
            ObjectTypeComponent objectComponent = (ObjectTypeComponent)actualComponent;
            Assertions.assertEquals((Object)"Root", (Object)objectComponent.getName(), (String)"Combined object maintain ref name");
            List<PropertyComponent> allProperties = this.componentRegistry.getComponents().values().stream().filter(c -> c instanceof PropertyComponent).map(PropertyComponent.class::cast).filter(p -> p.getOuter().equals(objectComponent.getId())).collect(Collectors.toList());
            Assertions.assertEquals((int)3, (int)allProperties.size(), (String)"Should have all 3 properties from the union");
            Set propertyNames = allProperties.stream().map(Component::getName).collect(Collectors.toSet());
            Assertions.assertTrue((boolean)propertyNames.contains("name"), (String)"Should contain 'name' property");
            Assertions.assertTrue((boolean)propertyNames.contains("age"), (String)"Should contain 'age' property");
            Assertions.assertTrue((boolean)propertyNames.contains("id"), (String)"Should contain 'id' property");
            allProperties.forEach(property -> Assertions.assertFalse((boolean)property.isRequired(), (String)("Property '" + property.getName() + "' should be optional in union object")));
        }

        @Test
        @DisplayName(value="GIVEN union of object types with property collision WHEN processed THEN throws RuntimeException for unsupported case")
        @Disabled
        public void testUnionOfObjectTypesWithWrongAttribute() {
            String script = "%dw 2.8\ntype Root = {name: String} | {name: Boolean}\n---\nRoot\n";
            RuntimeException exception = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> TypeHandlerTestUtils.processDataWeaveScript(script, this.unionTypeHandler, this.serviceComponent, this.typeFactory));
            Assertions.assertTrue((boolean)exception.getMessage().contains("Error: Not Heterogeneous Union"), (String)"Should throw RuntimeException for property collision case");
            Assertions.assertTrue((boolean)exception.getMessage().contains("serviceName"), (String)"Error message should contain the service name");
        }
    }

    @Nested
    @DisplayName(value="Array Unions")
    public class ArrayUnions {
        private ComponentRegistry componentRegistry;
        private TypeFactory typeFactory;
        private UnionTypeHandler unionTypeHandler;
        private Component serviceComponent;

        @BeforeEach
        void setUp() {
            this.componentRegistry = new ComponentRegistry();
            this.typeFactory = new R256TypeFactory(this.componentRegistry, Patch.fromResource((String)"patch.json"));
            this.unionTypeHandler = new UnionTypeHandler(this.componentRegistry);
            this.serviceComponent = ((ServiceComponent.ServiceComponentBuilder)ServiceComponent.builder().name("serviceName")).build();
            this.componentRegistry.registerComponent(this.serviceComponent);
        }

        @Test
        @DisplayName(value="GIVEN union of different array types WHEN processed THEN throws RuntimeException for unsupported union")
        public void testUnionOfArrayTypes() {
            String script = "%dw 2.8\ntype Root = Array<{name: String}> | Array<{age: String}> | Array<{id: String}>\n---\nRoot\n";
            RuntimeException exception = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> TypeHandlerTestUtils.processDataWeaveScript(script, this.unionTypeHandler, this.serviceComponent, this.typeFactory));
            Assertions.assertTrue((boolean)exception.getMessage().contains("Not Able to simplify Union"), (String)"Should throw RuntimeException for unsupported array union simplification");
            Assertions.assertTrue((boolean)exception.getMessage().contains("Array<{ name: String }> | Array<{ age: String }> | Array<{ id: String }>"), (String)"Error message should contain the problematic union type");
        }
    }

    @Nested
    @DisplayName(value="String Unions")
    public class StringUnions {
        private ComponentRegistry componentRegistry;
        private TypeFactory typeFactory;
        private UnionTypeHandler unionTypeHandler;
        private Component serviceComponent;

        @BeforeEach
        void setUp() {
            this.componentRegistry = new ComponentRegistry();
            this.typeFactory = new R256TypeFactory(this.componentRegistry, Patch.fromResource((String)"patch.json"));
            this.unionTypeHandler = new UnionTypeHandler(this.componentRegistry);
            this.serviceComponent = ((ServiceComponent.ServiceComponentBuilder)ServiceComponent.builder().name("serviceName")).build();
            this.componentRegistry.registerComponent(this.serviceComponent);
        }

        @Test
        @DisplayName(value="GIVEN union of string literals with null WHEN processed THEN resolves to String primitive marked as nullable")
        public void testUnionOfStringLiterals() {
            String script = "%dw 2.8\ntype Root = \"Mariano\" | \"Leandro\" | \"Pablo\" | \"Patricio\" | Null\n---\nRoot\n";
            Component actualComponent = TypeHandlerTestUtils.processDataWeaveScript(script, this.unionTypeHandler, this.serviceComponent, this.typeFactory);
            Assertions.assertNotNull((Object)actualComponent, (String)"Union should create a component");
            Assertions.assertTrue((boolean)(actualComponent instanceof PrimitiveTypeComponent), (String)"Union of string literals should resolve to primitive");
            PrimitiveTypeComponent primitiveComponent = (PrimitiveTypeComponent)actualComponent;
            Assertions.assertEquals((Object)"String", (Object)primitiveComponent.getName(), (String)"Union of string literals should resolve to String type");
        }
    }
}

