/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.validator.rules;

import com.mulesoft.connectivity.flow.api.metadata.FlowMetadataKey;
import com.mulesoft.connectivity.linkweave.api.loader.TypeUtils;
import com.mulesoft.connectivity.validation.Validatable;
import com.mulesoft.connectivity.validation.ValidatableType;
import com.mulesoft.connectivity.validation.ValidationContext;
import com.mulesoft.connectivity.validation.rules.Rule;
import com.mulesoft.connectivity.validation.rules.TriggerRule;
import java.util.Arrays;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;

public class FlowTriggerRule
extends Rule<DWType> {
    public FlowTriggerRule() {
        super(DWType.class, ValidatableType.TRIGGER);
    }

    protected void validate(Validatable<DWType> validatable, ValidationContext ctx) {
        Object object = validatable.getElement();
        if (!(object instanceof ObjectType)) {
            return;
        }
        ObjectType trigger = (ObjectType)object;
        DWType triggerInputType = TriggerRule.getTriggerInputType((ObjectType)trigger);
        if (triggerInputType == null) {
            return;
        }
        DWType type = TypeUtils.resolveReferenceType((DWType)triggerInputType);
        if (type instanceof ObjectType) {
            ObjectType objectType = (ObjectType)type;
            if (this.isQueryBuilder(objectType)) {
                ctx.addError(objectType.getLocation(), "Trigger must not have a QueryBuilder annotation, at input: " + String.valueOf(type), "InvalidFlowType");
            }
        } else {
            ctx.addError(type.getLocation(), "Unsupported type at input: " + String.valueOf(type), "InvalidFlowType");
        }
    }

    private boolean isQueryBuilder(ObjectType type) {
        return Arrays.stream(type.getTypeMetadata()).anyMatch(m -> FlowMetadataKey.QUERY_BUILDER.getKey().equals(m.getName()));
    }
}

