%dw 2.7

import TestConnector from Metadata
import * from com::mulesoft::connectivity::Model
import * from com::mulesoft::connectivity::decorator::Annotations
import * from com::mulesoft::connectivity::decorator::Operation
import * from com::mulesoft::connectivity::decorator::Trigger
import * from com::mulesoft::connectivity::Metadata
import * from com::mulesoft::connectivity::transport::Http


var newerAdd : Operation<{left: Number, right: Number}, {result: Number}, ResultFailure<Any, Error<"", "">>, HttpConnection> = {
    name: "add",
    displayName: "add",
    executor: (parameter, connection) -> success({result: parameter.left + parameter.right})
}

var obsoleteAdd : Operation<{left: String, right: String}, {result: Number}, ResultFailure<Any, Error<"", "">>, HttpConnection> = {
    name: "add",
    displayName: "add",
    executor: (parameter, connection) -> success({result: (parameter.left as Number) + (parameter.right as Number)})
}

// Base operations can't have a type assigned by hand, as that would disable the type inference
// we rely on to get the types of the variable number of executors included under "versions".
var baseAdd = {
    name: "add",
    displayName: "Add",
    executor: obsoleteAdd.executor,
    executorNextPage: obsoleteAdd.executorNextPage,
    versions: {
        "2": newerAdd
    }
}

// Triggers

type GetUsersRequest = {since: Number}
type GetUsersResponse = {items: Array<User>}
type User = {id: String, name: String, email: String, created_at: Number}

var getUsers : Operation<GetUsersRequest, HttpResponse<GetUsersResponse>, ResultFailure<HttpResponse, Error>, HttpConnection> = {
    name: "getUsers",
    displayName: "Get Users",
    executor: (parameter, connection) -> do {
        success({
                          contentType: "application/json",
                          status: 200,
                          headers: {},
                          cookies: {},
                          body: {
                    items: [
                      {
                          id: 1,
                          name: "pepe",
                          email: "p@sales.com",
                          created_at: 20200102
                      },
                      {
                          id: 2,
                          name: "pepito",
                          email: "pe@sales.com",
                          created_at: 20200105
                      },
                      {
                          id: 3,
                          name: "pepillo",
                          email: "pep@sales.com",
                          created_at: 20210517
                      }
                    ]
                }
                 } as HttpResponse<GetUsersResponse>)
    }
}

type NewGetUsersRequest = GetUsersRequest & {newRequiredParam: Number}
var newGetUsers =
    getUsers mapInputOperation (i:NewGetUsersRequest) -> i ++ {newRequiredParam: 0}

var getInitialDatetime : Operation<{}, Number, HttpResponse, HttpConnection> = {
    name: "getInitialDatetime",
    displayName: "Get datetime",
    executor: (parameter, connection) -> do {
        success(20200101)
    }
}

var myTriggerStrategy:TriggerStrategy<HttpResponse<GetUsersResponse>,User,User,Number> =
{
    items: (result) -> result.body.items,
    item: (item) -> item,
    watermark: (result,item) -> item.created_at,
    identity: (item) -> item.id as String,
    watermarkCompareTo: DefaultWatermarkComparison
}

@TriggerElement()
var getUsersTrigger = {
    name: "getUsersTrigger",
    displayName: "Get Users Trigger",
    metadata: {
        order: "ASC",
        paginated: false
    },
    strategy: myTriggerStrategy,
    operation: getUsers,
    inputMapper: (ti, w) -> ti,
    initialWatermark: (GetUsersRequest, HttpConnection) -> 20200101, //(now() as String { format: "uuuuMMdd" }) as Number
    versions: {
        "2": {
            metadata: {
                order: "ASC",
                paginated: false
            },
            strategy: myTriggerStrategy,
            operation: newGetUsers,
            inputMapper: (ti, w) -> ti,
            initialWatermark: (GetUsersRequest, HttpConnection) -> 20200101, //(now() as String { format: "uuuuMMdd" }) as Number
        }
    }
}

// Connection

@OperationElement
var isAlive: Operation<{}, HttpResponse, ResultFailure<HttpResponse, Error>, HttpConnection> = {
    name: "isAlive",
    displayName: "Is alive",
    executor: (parameter, connection) -> success(
        	{
                contentType: "application/json",
                status: 200,
                headers: {},
                cookies: {}
    		})
}

@TestConnectionElement()
var testConnection = {
	validate: defineTestConnection(
        isAlive,
        (response) -> { isValid: response.value.status == 200 }
    )
}

@ConnectionElement()
var connection = defineBasicHttpConnectionProvider<@Label(value = "basic connection") {
    baseUri: @Label(value = "The base uri that will be used for all HTTP requests") String,
    user: @Label(value = "The username used to authenticate the requests") String,
    pass: @Label(value = "The password used to authenticate the requests") @SemanticTerms(value = ["password"]) String
}>(
    (parameter) -> {username: parameter.user, password: parameter.pass},
    (parameter) -> {baseUri: parameter.baseUri}
)



@TestConnector()
var connector = {
    name: "VersioningTest",
    displayName: "Versioning Test",
    version: "1.0.0",
    releaseStatus: "PILOT",
    since: "R256",
    description: "Test",
    vendor: "Salesforce",
    icons: [
    {
        name: "Reference Connector ",
        alternateText: "Reference Connector",
        resource: "icon/icon.svg",
        size: 65440,
        dimensions: "32x32"
    }
    ],
    connections: {basicAuth: connection},
    operations: {
       add: baseAdd
    },
    triggers: {
        getUsersTrigger: getUsersTrigger
    },
    testConnection: testConnection,
    metadataProviders: {}
}
