/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.model.servicemodel.r256;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mulesoft.connectivity.flow.api.loader.FlowConnectorLoader;
import com.mulesoft.connectivity.flow.api.loader.FlowModelLoaderFactory;
import com.mulesoft.connectivity.flow.api.model.FlowConnectorModel;
import com.mulesoft.connectivity.flow.api.model.ReleaseStatus;
import com.mulesoft.connectivity.flow.api.servicemodel.ReleaseServiceModelSerializer;
import com.mulesoft.connectivity.flow.api.servicemodel.ReleaseServiceModelSerializerFactory;
import com.mulesoft.connectivity.flow.api.servicemodel.SalesforceRelease;
import com.mulesoft.connectivity.linkweave.api.loader.LanguageModelLoader;
import com.mulesoft.connectivity.linkweave.api.loader.ModelLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;

public class Versioning256Test {
    private final DataWeaveScriptingEngine dataWeaveScriptingEngine = new DataWeaveScriptingEngine();
    private final LanguageModelLoader<FlowConnectorModel, FlowConnectorModel.Builder> linkWeaveLoader = new LanguageModelLoader(this.dataWeaveScriptingEngine, (ModelLoader)new FlowModelLoaderFactory().create(), NameIdentifier.fromFQN((String)"Metadata::TestConnector"));
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    @Test
    void onlyOperationsAndTriggersAreVersioned256() throws IOException {
        FlowConnectorModel connectorModel = (FlowConnectorModel)this.linkWeaveLoader.loadConnector("versioning::Connector::connector", (Object)new FlowConnectorLoader.ExtraData("1.0.0", ReleaseStatus.GA));
        StringWriter writer = new StringWriter();
        ReleaseServiceModelSerializer r256 = new ReleaseServiceModelSerializerFactory().getGreatestSerializerFor(SalesforceRelease.R256);
        r256.serialize(connectorModel, (Writer)writer);
        InputStream expectedIs = this.getClass().getClassLoader().getResourceAsStream("versioning/connector256.json");
        assert (expectedIs != null);
        String expectedRaw = new String(expectedIs.readAllBytes(), Charset.defaultCharset());
        String expectedJson = this.gson.toJson(this.gson.fromJson(expectedRaw, Object.class));
        Assertions.assertEquals((Object)expectedJson, (Object)writer.toString(), (String)"Serialized JSON does not match");
    }
}

