/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.validator;

import com.mulesoft.connectivity.flow.api.validator.AbstractValidatorTest;
import com.mulesoft.connectivity.flow.api.validator.CollectedMessages;
import com.mulesoft.connectivity.flow.api.validator.rules.FlowConnectionsRule;
import com.mulesoft.connectivity.flow.api.validator.rules.NoDynamicNamesRule;
import com.mulesoft.connectivity.flow.api.validator.rules.TemplateRule;
import com.mulesoft.connectivity.flow.api.validator.rules.UnionRule;
import com.mulesoft.connectivity.validation.ValidationConfiguration;
import com.mulesoft.connectivity.validation.rules.ArrayRule;
import com.mulesoft.connectivity.validation.rules.ConnectionRule;
import com.mulesoft.connectivity.validation.rules.ExecutorRule;
import com.mulesoft.connectivity.validation.rules.MessageRule;
import com.mulesoft.connectivity.validation.rules.ObjectRule;
import com.mulesoft.connectivity.validation.rules.ProviderReferenceRule;
import com.mulesoft.connectivity.validation.rules.ReferenceRule;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class ConnectionValidatorTest
extends AbstractValidatorTest {
    @Override
    protected ValidationConfiguration getValidationConfiguration() {
        return ValidationConfiguration.withRuleClasses((Class[])new Class[]{FlowConnectionsRule.class, ExecutorRule.class, MessageRule.class, ReferenceRule.class, ObjectRule.class, UnionRule.class, NoDynamicNamesRule.class, ArrayRule.class, ProviderReferenceRule.class, ConnectionRule.class, TemplateRule.class});
    }

    @Test
    void acceptsNoConnectionsConnector() {
        this.assertCompileSuccessful("%dw 2.7\n\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::flow::Metadata\n\n@FlowConnectorElement\nvar connector = {\n    operations: {testOperation: {}},\n    triggers: {testTrigger: {}},\n    valueProviders: {testValueProvider: {}},\n}");
    }

    @Test
    void acceptsEmptyConnections() {
        this.assertCompileSuccessful("%dw 2.7\n\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::flow::Metadata\n\n@FlowConnectorElement\nvar connector = {\n    connections: {},\n}");
    }

    @Test
    void acceptsOneConnection() {
        this.assertCompileSuccessful("%dw 2.7\n\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::flow::Metadata\n\n@FlowConnectorElement\nvar connector = {\n    connections: {connectionDef: {authenticationType: {\"type\": \"basic\"}, connect: (inputType) -> {}}},\n}");
    }

    @Test
    void acceptsMultipleConnectionsWithDifferentAuthenticationTypes() {
        this.assertCompileSuccessful("%dw 2.7\n\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::transport::Http\nimport * from com::mulesoft::connectivity::flow::Metadata\n\n@FlowConnectorElement\nvar connector = {\n    connections: { c1: { authenticationType: {\"type\": \"basic\"}, connect: (inputType) -> {} }, c2: { authenticationType: {\"type\": \"bearer\"}, connect: (inputType) -> {} } }\n}");
    }

    @Test
    void failsDuplicateAuthenticationType() {
        CollectedMessages messages = this.assertCompileFailure("%dw 2.7\n\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::flow::Metadata\n\n@FlowConnectorElement\nvar connector = {\n    connections: { c1: { authenticationType: {\"type\": \"basic\"}, connect: (inputType) -> {} }, c2: { authenticationType: {\"type\": \"basic\"}, connect: (inputType) -> {} } }\n}");
        MatcherAssert.assertThat(messages.getErrors(), (Matcher)Matchers.hasSize((int)1));
        ConnectionValidatorTest.assertValidationMessage(messages.getErrors().get(0), "Property 'connections' contains multiple connections with the same authenticationType: basic", "connector", "\n8|     connections: { c1: { authenticationType: {\"type\": \"basic\"}, connect: (inputType) -> {} }, c2: { authenticationType: {\"type\": \"basic\"}, connect: (inputType) -> {} } }\n       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
    }

    @Test
    void failsIfPropertyConnectionIsNotObject() {
        CollectedMessages messages = this.assertCompileFailure("%dw 2.7\n\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::flow::Metadata\n\n@FlowConnectorElement\nvar connector = {\n    connections: []\n}");
        MatcherAssert.assertThat(messages.getErrors(), (Matcher)Matchers.hasSize((int)1));
        ConnectionValidatorTest.assertValidationMessage(messages.getErrors().get(0), "Invalid type for property 'connections'. Expected: Object; Actual: Array<Nothing>", "connector", "\n8|     connections: []\n       ^^^^^^^^^^^^^^^");
    }

    @Test
    void rejectsConnectionInvalidType() {
        CollectedMessages messages = this.assertCompileFailure("%dw 2.7\n\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::flow::Metadata\n\n@FlowConnectorElement\nvar connector = {\n    connections: {connectionDef: {}},\n}");
        MatcherAssert.assertThat(messages.getErrors(), (Matcher)Matchers.hasSize((int)1));
        ConnectionValidatorTest.assertValidationMessage(messages.getErrors().get(0), "Missing connect property in connection definition", "connector", "\n8|     connections: {connectionDef: {}},\n                                    ^^");
    }

    @Test
    void rejectsConnectionInvalidInputType() {
        CollectedMessages messages = this.assertCompileFailure("%dw 2.7\n\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::flow::Metadata\n\n@FlowConnectorElement\nvar connector = {\n    connections: {connectionDef: {connect: (inputType1, inputType2) -> {}}},\n}");
        MatcherAssert.assertThat(messages.getErrors(), (Matcher)Matchers.hasSize((int)1));
        ConnectionValidatorTest.assertValidationMessage(messages.getErrors().get(0), "Invalid type for property 'connect'. Expected an connect function but got (inputType1, inputType2) -> ?", "connector", "\n8|     connections: {connectionDef: {connect: (inputType1, inputType2) -> {}}},\n                                     ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
    }

    @Test
    void acceptsBaseUriTemplateValidPlaceholders() {
        this.assertCompileSuccessful("%dw 2.7\n\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::Metadata\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::transport::Http\nimport * from com::mulesoft::connectivity::decorator::Annotations\n\nvar bearerAuth = defineBearerHttpConnectionProvider<BearerAuthSchema & {\n  baseUri: @Template(value = \"https://{{account}}.suitetalk.api.netsuite.com/{{customerId}}\") String,\n  account: @Label(value = \"Account ID\") String,\n  customerId: @Label(value = \"Customer ID\") String\n  }>((schema) -> {\n      token: schema.token\n    }, (schema) -> {\n      baseUri: schema.baseUri\n})\n\n@FlowConnectorElement\nvar connector = {\n    connections: {bearerAuth: bearerAuth}\n}");
    }

    @Test
    void rejectBaseUriFormulaInvalidPlaceholders() {
        CollectedMessages messages = this.assertCompileFailure("%dw 2.7\n\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::Metadata\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::transport::Http\nimport * from com::mulesoft::connectivity::decorator::Annotations\n\nvar bearerAuth = defineBearerHttpConnectionProvider<BearerAuthSchema & {\n  baseUri: @Template(value = \"https://{{accountId}}.suitetalk.api.netsuite.com\") String,\n  account: @Label(value = \"Account ID\") String\n  }>((schema) -> {\n      token: schema.token\n    }, (schema) -> {\n      baseUri: schema.baseUri\n})\n\n@FlowConnectorElement\nvar connector = {\n    connections: {bearerAuth: bearerAuth}\n}");
        MatcherAssert.assertThat(messages.getErrors(), (Matcher)Matchers.hasSize((int)1));
        ConnectionValidatorTest.assertValidationMessage(messages.getErrors().get(0), "Field for placeholder: 'accountId' not found in Object", "InvalidFlowType", "\n10|   baseUri: @Template(value = \"https://{{accountId}}.suitetalk.api.netsuite.com\") String,\n               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
    }
}

