/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.validator;

import com.mulesoft.connectivity.flow.api.validator.AbstractValidatorTest;
import com.mulesoft.connectivity.flow.api.validator.CollectedMessages;
import com.mulesoft.connectivity.flow.api.validator.rules.FlowIconRule;
import com.mulesoft.connectivity.validation.ValidationConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IconValidatorTest
extends AbstractValidatorTest {
    @Override
    protected ValidationConfiguration getValidationConfiguration() {
        return ValidationConfiguration.withRuleClasses((Class[])new Class[]{FlowIconRule.class});
    }

    @Test
    void acceptsConnectorWithValidIconValue() {
        CollectedMessages collectedMessages = this.assertCompileSuccessful("%dw 2.7\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::transport::Http\nimport * from com::mulesoft::connectivity::Types\n\n@FlowConnectorElement()\nvar connector = {\n                    name: \"DataWeaveExtension\",\n                    displayName: \"Data Weave Extension\",\nicons: [\n{\n name: \"Cloud\",\n alternateText: \"CloudShape\",\nresource: \"icons/cloud.svg\",\nsize: 1,\ndimensions: \"0x0\"                }\n]\n}\n");
    }

    @Test
    void rejectsConnectorWithInvalidIconValueNoId() {
        CollectedMessages collectedMessages = this.assertCompileFailure("%dw 2.7\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::transport::Http\nimport * from com::mulesoft::connectivity::Types\n\n@FlowConnectorElement()\nvar connector = {\n                    name: \"DataWeaveExtension\",\n                    displayName: \"Data Weave Extension\",\nicons: [\n{\n name: \"Cloud\",\n alternateText: \"CloudShape\",\nresource: \"icons/cloud-no-id.svg\",\nsize: 1,\ndimensions: \"0x0\"                }\n]\n}\n");
        IconValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Must have an 'id' attribute with value 'icon'", "connector", "\n11| icons: [\n  |  ...\n18| ]\n");
    }

    @Test
    void rejectsConnectorWithInvalidIconValuePxInHeight() {
        CollectedMessages collectedMessages = this.assertCompileFailure("%dw 2.7\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::transport::Http\nimport * from com::mulesoft::connectivity::Types\n\n@FlowConnectorElement()\nvar connector = {\n                    name: \"DataWeaveExtension\",\n                    displayName: \"Data Weave Extension\",\nicons: [\n{\n name: \"Cloud\",\n alternateText: \"CloudShape\",\nresource: \"icons/cloud-px-height.svg\",\nsize: 1,\ndimensions: \"0x0\"                }\n]\n}\n");
        IconValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), "SVG must not have 'width' or 'height' attributes with 'px' values", "connector", "\n11| icons: [\n  |  ...\n18| ]\n");
    }

    @Test
    void rejectsConnectorWithInvalidIconValueNoFillElement() {
        CollectedMessages collectedMessages = this.assertCompileFailure("%dw 2.7\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::transport::Http\nimport * from com::mulesoft::connectivity::Types\n\n@FlowConnectorElement()\nvar connector = {\n                    name: \"DataWeaveExtension\",\n                    displayName: \"Data Weave Extension\",\nicons: [\n{\n name: \"Cloud\",\n alternateText: \"CloudShape\",\nresource: \"icons/cloud-no-fill.svg\",\nsize: 1,\ndimensions: \"0x0\"                }\n]\n}\n");
        IconValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Every path element in the SVG icon must have a 'fill' attribute", "connector", "\n11| icons: [\n  |  ...\n18| ]\n");
    }

    @Test
    void rejectsConnectorWithInvalidIconValueClipPathPresent() {
        CollectedMessages collectedMessages = this.assertCompileFailure("%dw 2.7\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::transport::Http\nimport * from com::mulesoft::connectivity::Types\n\n@FlowConnectorElement()\nvar connector = {\n                    name: \"DataWeaveExtension\",\n                    displayName: \"Data Weave Extension\",\nicons: [\n{\n name: \"Cloud\",\n alternateText: \"CloudShape\",\nresource: \"icons/cloud-clippath.svg\",\nsize: 1,\ndimensions: \"0x0\"                }\n]\n}\n");
        IconValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), "SVG icons must not have 'clipPath' elements", "connector", "\n11| icons: [\n  |  ...\n18| ]\n");
    }

    @Test
    void rejectsConnectorWithInvalidIconValueXmlsAttributePresent() {
        CollectedMessages collectedMessages = this.assertCompileFailure("%dw 2.7\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::transport::Http\nimport * from com::mulesoft::connectivity::Types\n\n@FlowConnectorElement()\nvar connector = {\n                    name: \"DataWeaveExtension\",\n                    displayName: \"Data Weave Extension\",\nicons: [\n{\n name: \"Cloud\",\n alternateText: \"CloudShape\",\nresource: \"icons/cloud-no-xmls.svg\",\nsize: 1,\ndimensions: \"0x0\"                }\n]\n}\n");
        IconValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Must have an 'xmlns' attribute with the proper namespace", "connector", "\n11| icons: [\n  |  ...\n18| ]\n");
    }

    @Test
    void rejectsConnectorWithNoIconPropertyPresent() {
        CollectedMessages collectedMessages = this.assertCompileFailure("%dw 2.7\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::transport::Http\nimport * from com::mulesoft::connectivity::Types\n\n@FlowConnectorElement()\nvar connector = {\n                    name: \"DataWeaveExtension\",\n                    displayName: \"Data Weave Extension\",\n}\n");
        IconValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Icon Property is empty. Expected: Icon Property to be present. Actual: Icon Property is Empty", "connector", "\n8| var connector = {\n       ^^^^^^^^^");
    }

    @Test
    void rejectsConnectorWithSpaceInResourceName() {
        CollectedMessages collectedMessages = this.assertCompileFailure("%dw 2.7\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::transport::Http\nimport * from com::mulesoft::connectivity::Types\n\n@FlowConnectorElement()\nvar connector = {\n                    name: \"DataWeaveExtension\",\n                    displayName: \"Data Weave Extension\",\nicons: [\n{\n name: \"Cloud\",\n alternateText: \"CloudShape\",\nresource: \"icons/cloud data.svg\",\nsize: 1,\ndimensions: \"0x0\"                }\n]\n}\n");
        IconValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Icon resource name should not have space. Expected: Resource Name of icon without space; Actual: icons/cloud data.svg", "connector", "\n11| icons: [\n  |  ...\n18| ]\n");
    }

    @Test
    void rejectsConnectorWithInvalidIconValueWithNoSVGExtension() {
        CollectedMessages collectedMessages = this.assertCompileFailure("%dw 2.7\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::transport::Http\nimport * from com::mulesoft::connectivity::Types\n\n@FlowConnectorElement()\nvar connector = {\n                    name: \"DataWeaveExtension\",\n                    displayName: \"Data Weave Extension\",\nicons: [\n{\n name: \"Cloud\",\n alternateText: \"CloudShape\",\nresource: \"icons/cloud\",\nsize: 1,\ndimensions: \"0x0\"                }\n]\n}\n");
        IconValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Invalid name for icon. Expected: Ending with .svg; Actual: icons/cloud", "connector", "\n11| icons: [\n  |  ...\n18| ]\n");
    }

    @Test
    void rejectsConnectorWithInvalidFileName() {
        CollectedMessages collectedMessages = this.parseModule(false, "%dw 2.7\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::transport::Http\nimport * from com::mulesoft::connectivity::Types\n\n@FlowConnectorElement()\nvar connector = {\n                    name: \"DataWeaveExtension\",\n                    displayName: \"Data Weave Extension\",\nicons: [\n{\n name: \"Cloud\",\n alternateText: \"CloudShape\",\nresource: \"icons/cloud-notpresent.svg\",\nsize: 1,\ndimensions: \"0x0\"                }\n]\n}\n");
        Assertions.assertTrue((boolean)collectedMessages.getWarnings().stream().anyMatch(m -> m.getMessage().getMessage().equals("Couldn't find icon file 'icons/cloud-notpresent.svg'") && m.getMessage().getKind().equals("connector") && m.getLocation().toStringRepresentation().equals("\n11| icons: [\n  |  ...\n18| ]\n")));
    }

    @Test
    void rejectsConnectorWithEmptyIconFile() {
        CollectedMessages collectedMessages = this.assertCompileFailure("%dw 2.7\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::transport::Http\nimport * from com::mulesoft::connectivity::Types\n\n@FlowConnectorElement()\nvar connector = {\n                    name: \"DataWeaveExtension\",\n                    displayName: \"Data Weave Extension\",\nicons: [\n{\n name: \"Cloud\",\n alternateText: \"CloudShape\",\nresource: \"icons/cloud-empty.svg\",\nsize: 1,\ndimensions: \"0x0\"                }\n]\n}\n");
        IconValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), "Icon file is empty. It should contain icon data in svg format.", "connector", "\n11| icons: [\n  |  ...\n18| ]\n");
    }

    @Test
    void rejectsConnectorWithNoResourceFieldInIconProperty() {
        CollectedMessages collectedMessages = this.assertCompileFailure("%dw 2.7\nimport * from com::mulesoft::connectivity::flow::Metadata\nimport * from com::mulesoft::connectivity::Model\nimport * from com::mulesoft::connectivity::transport::Http\nimport * from com::mulesoft::connectivity::Types\n\n@FlowConnectorElement()\nvar connector = {\n                    name: \"DataWeaveExtension\",\n                    displayName: \"Data Weave Extension\",\nicons: [\n{\n name: \"Cloud\",\n alternateText: \"CloudShape\",\nsize: 1,\ndimensions: \"0x0\"                }\n]\n}\n");
        IconValidatorTest.assertValidationMessage(collectedMessages.getErrors().get(0), "The 'resource' property is not present in the icon definition.", "connector", "\n11| icons: [\n  |  ...\n17| ]\n");
    }
}

