/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler;

import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.ComponentRegistry;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.ObjectTypeHandler;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.R256TypeFactory;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.ReferenceTypeHandler;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.TypeFactory;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.handler.TypeHandlerTestUtils;
import com.mulesoft.connectivity.flow.internal.servicemodel.loader.r256.Patch;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.Component;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.ObjectTypeComponent;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.OperationComponent;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.PrimitiveTypeComponent;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.PropertyComponent;
import com.mulesoft.connectivity.flow.internal.servicemodel.model.ServiceComponent;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.TypeType;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.ts.WeaveType;

public class ReferenceTypeHandlerTest {
    private final DataWeaveScriptingEngine engine = new DataWeaveScriptingEngine();

    @Nested
    @DisplayName(value="Collision Validation")
    public class CollisionValidation {
        private ComponentRegistry componentRegistry;
        private TypeFactory typeFactory;
        private ReferenceTypeHandler referenceTypeHandler;
        private Component serviceComponent;

        @BeforeEach
        void setUp() {
            this.componentRegistry = new ComponentRegistry();
            this.typeFactory = new R256TypeFactory(this.componentRegistry, Patch.fromResource((String)"patch.json"));
            this.referenceTypeHandler = new ReferenceTypeHandler(this.componentRegistry, new Patch());
            this.serviceComponent = ((ServiceComponent.ServiceComponentBuilder)ServiceComponent.builder().name("serviceName")).build();
            this.componentRegistry.registerComponent(this.serviceComponent);
        }

        @Test
        @DisplayName(value="GIVEN a referenceType with no collision WHEN called to 'make' THEN creates properly")
        public void testNoCollision() {
            WeaveType weaveType;
            String script = "%dw 2.8\ntype TestType = String\nvar v: TestType = \"test\"\n---\nv\n";
            WeaveType dwType = weaveType = (WeaveType)ReferenceTypeHandlerTest.this.engine.inferTypeOf(script).get();
            Assertions.assertTrue((boolean)this.referenceTypeHandler.handles((DWType)dwType), (String)"ReferenceTypeHandler should handle SimpleReferenceType since it implements ReferenceType");
            Component actualComponent = this.referenceTypeHandler.make((DWType)dwType, "TestType", this.serviceComponent, this.typeFactory);
            Assertions.assertNotNull((Object)actualComponent, (String)"ReferenceTypeHandler should create a valid component for SimpleReferenceType");
            Assertions.assertTrue((boolean)(actualComponent instanceof PrimitiveTypeComponent), (String)("TestType = String should create a PrimitiveTypeComponent, but got: " + actualComponent.getClass().getSimpleName()));
            Assertions.assertEquals((Object)"String", (Object)actualComponent.getName(), (String)"Component name should be 'String' after resolving the reference");
            Assertions.assertEquals((Object)this.serviceComponent.getId(), (Object)actualComponent.getOuter(), (String)"Component should be contained within the service component");
        }

        @Test
        @DisplayName(value="GIVEN a referenceType with collision with a PrimitiveType WHEN called to 'make' THEN creates properly")
        public void testCollisionWithPrimitiveType() {
            PrimitiveTypeComponent existingPrimitive = ((PrimitiveTypeComponent.PrimitiveTypeComponentBuilder)((PrimitiveTypeComponent.PrimitiveTypeComponentBuilder)PrimitiveTypeComponent.builder().name("TestType")).outer(this.serviceComponent.getId())).build();
            this.componentRegistry.registerComponent((Component)existingPrimitive);
            Assertions.assertDoesNotThrow(() -> {
                WeaveType weaveType;
                String script = "%dw 2.8\ntype TestType = String\nvar v: TestType = \"test\"\n---\nv\n";
                WeaveType dwType = weaveType = (WeaveType)ReferenceTypeHandlerTest.this.engine.inferTypeOf(script).get();
                Component result = this.referenceTypeHandler.make((DWType)dwType, "TestType", this.serviceComponent, this.typeFactory);
                Assertions.assertNotNull((Object)result);
            });
        }

        @Test
        @DisplayName(value="GIVEN a referenceType with collision with a Operation WHEN called to 'make' THEN creates properly")
        public void testCollisionWithOperation() {
            OperationComponent existingOperation = ((OperationComponent.OperationComponentBuilder)((OperationComponent.OperationComponentBuilder)OperationComponent.builder().name("TestType")).outer(this.serviceComponent.getId())).kind("Synchronous").build();
            this.componentRegistry.registerComponent((Component)existingOperation);
            Assertions.assertDoesNotThrow(() -> {
                WeaveType weaveType;
                String script = "%dw 2.8\ntype TestType = String\nvar v: TestType = \"test\"\n---\nv\n";
                WeaveType dwType = weaveType = (WeaveType)ReferenceTypeHandlerTest.this.engine.inferTypeOf(script).get();
                Component result = this.referenceTypeHandler.make((DWType)dwType, "TestType", this.serviceComponent, this.typeFactory);
                Assertions.assertNotNull((Object)result);
            });
        }

        @Test
        @DisplayName(value="GIVEN a referenceType with collision with a ObjectType WHEN called to 'make' THEN fails")
        public void testCollisionWithObjectType() {
            ObjectTypeComponent existingObject = ((ObjectTypeComponent.ObjectTypeComponentBuilder)((ObjectTypeComponent.ObjectTypeComponentBuilder)ObjectTypeComponent.builder().name("TestType")).outer(this.serviceComponent.getId())).build();
            this.componentRegistry.registerComponent((Component)existingObject);
            RuntimeException exception = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> {
                String script = "%dw 2.8\ntype TestType = String\nvar v: TestType = \"test\"\n---\nv\n";
                DWType dwType = (DWType)ReferenceTypeHandlerTest.this.engine.inferTypeOf(script).get();
                this.referenceTypeHandler.make(dwType, "TestType", this.serviceComponent, this.typeFactory);
            });
            Assertions.assertEquals((Object)"Duplicate reference type: TestType", (Object)exception.getMessage());
        }

        @Test
        @DisplayName(value="GIVEN a referenceType with same last part after underscore WHEN called to 'make' THEN succeeds")
        public void testNoNameCollision() {
            ObjectTypeComponent existingObject = ((ObjectTypeComponent.ObjectTypeComponentBuilder)((ObjectTypeComponent.ObjectTypeComponentBuilder)ObjectTypeComponent.builder().name("T_account_info")).outer(this.serviceComponent.getId())).build();
            this.componentRegistry.registerComponent((Component)existingObject);
            Assertions.assertDoesNotThrow(() -> {
                String script = "%dw 2.8\ntype T_customer_info = String\nvar v: T_customer_info = \"test\"\n---\nv\n";
                DWType dwType = (DWType)ReferenceTypeHandlerTest.this.engine.inferTypeOf(script).get();
                Component result = this.referenceTypeHandler.make(dwType, "T_customer_info", this.serviceComponent, this.typeFactory);
                Assertions.assertNotNull((Object)result);
            });
        }

        @Test
        @DisplayName(value="GIVEN a referenceType with same last part after underscore WHEN called to 'make' THEN succeeds")
        public void testCollisionWithSameNamesAcrossPackages() {
            ObjectTypeComponent existingObject = ((ObjectTypeComponent.ObjectTypeComponentBuilder)((ObjectTypeComponent.ObjectTypeComponentBuilder)ObjectTypeComponent.builder().name("T_customer_info")).outer(this.serviceComponent.getId())).build();
            this.componentRegistry.registerComponent((Component)existingObject);
            RuntimeException exception = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> {
                String script = "%dw 2.8\ntype T_customer_info = String\nvar v: T_customer_info = \"test\"\n---\nv\n";
                DWType dwType = (DWType)ReferenceTypeHandlerTest.this.engine.inferTypeOf(script).get();
                this.referenceTypeHandler.make(dwType, "T_customer_info", this.serviceComponent, this.typeFactory);
            });
            Assertions.assertEquals((Object)"Duplicate reference type: T_customer_info", (Object)exception.getMessage());
            existingObject = ((ObjectTypeComponent.ObjectTypeComponentBuilder)((ObjectTypeComponent.ObjectTypeComponentBuilder)ObjectTypeComponent.builder().name("com_mulesoft_connectivity_Types_T_customer_info")).outer(this.serviceComponent.getId())).build();
            this.componentRegistry.registerComponent((Component)existingObject);
            exception = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> {
                String script = "%dw 2.8\ntype com_mulesoft_connectivity_customization_Types_T_customer_info = String\nvar v: com_mulesoft_connectivity_customization_Types_T_customer_info = \"test\"\n---\nv\n";
                DWType dwType = (DWType)ReferenceTypeHandlerTest.this.engine.inferTypeOf(script).get();
                this.referenceTypeHandler.make(dwType, "com_mulesoft_connectivity_customization_Types_T_customer_info", this.serviceComponent, this.typeFactory);
            });
            Assertions.assertEquals((Object)"Duplicate reference type: T_customer_info", (Object)exception.getMessage());
        }
    }

    @Nested
    @DisplayName(value="Basic Reference Scenarios")
    public class BasicReferenceScenarios {
        private ComponentRegistry componentRegistry;
        private TypeFactory typeFactory;
        private ObjectTypeHandler objectTypeHandler;
        private Component serviceComponent;

        @BeforeEach
        void setUp() {
            this.componentRegistry = new ComponentRegistry();
            this.typeFactory = new R256TypeFactory(this.componentRegistry, Patch.fromResource((String)"patch.json"));
            this.objectTypeHandler = new ObjectTypeHandler(this.componentRegistry);
            this.serviceComponent = ((ServiceComponent.ServiceComponentBuilder)ServiceComponent.builder().name("serviceName")).build();
            this.componentRegistry.registerComponent(this.serviceComponent);
        }

        @Test
        @DisplayName(value="GIVEN object with multiple references to same type WHEN processed THEN creates shared type with individual property metadata")
        public void testBasicReferenceResolution() {
            String script = "%dw 2.8\ntype Root = {\n  a: Test <~ {description: \"Label for Root a\"},\n  b: Test <~ {description: \"Description for Root b\"},\n  c: Test\n}\n\ntype Test = {\n  name: String <~ {label: \"Label for Test.name\"}\n} <~ {description : \"Label for Test\"}\n---\nRoot\n";
            WeaveType weaveType = (WeaveType)ReferenceTypeHandlerTest.this.engine.inferTypeOf(script).get();
            DWType dwType = ((TypeType)weaveType).getType();
            Component actualComponent = this.objectTypeHandler.make(dwType, "Root", this.serviceComponent, this.typeFactory);
            Assertions.assertInstanceOf(ObjectTypeComponent.class, (Object)actualComponent, (String)("Reference resolution should create ObjectTypeComponent, but got: " + actualComponent.getClass().getSimpleName()));
            Assertions.assertEquals((Object)"Root", (Object)actualComponent.getName(), (String)"Component name should be 'Root'");
            PropertyComponent aProperty = TypeHandlerTestUtils.findProperty("a", this.componentRegistry);
            PropertyComponent bProperty = TypeHandlerTestUtils.findProperty("b", this.componentRegistry);
            PropertyComponent cProperty = TypeHandlerTestUtils.findProperty("c", this.componentRegistry);
            Assertions.assertEquals((Object)"Label for Root a", (Object)aProperty.getDescription(), (String)"Property 'a' should preserve its specific description");
            Assertions.assertEquals((Object)"Description for Root b", (Object)bProperty.getDescription(), (String)"Property 'b' should preserve its specific description");
            Assertions.assertEquals((Object)"Label for Test", (Object)cProperty.getDescription(), (String)"Property 'c' should inherit description from Test type definition");
            Component testTypeA = TypeHandlerTestUtils.findById(aProperty.getPropertyType(), this.componentRegistry.getComponents());
            Component testTypeB = TypeHandlerTestUtils.findById(bProperty.getPropertyType(), this.componentRegistry.getComponents());
            Component testTypeC = TypeHandlerTestUtils.findById(cProperty.getPropertyType(), this.componentRegistry.getComponents());
            Assertions.assertNotNull((Object)testTypeA, (String)"Property 'a' should reference a valid Test type component");
            Assertions.assertNotNull((Object)testTypeB, (String)"Property 'b' should reference a valid Test type component");
            Assertions.assertNotNull((Object)testTypeC, (String)"Property 'c' should reference a valid Test type component");
            Assertions.assertTrue((boolean)(testTypeA instanceof ObjectTypeComponent), (String)("Referenced Test type should be an ObjectTypeComponent, but got: " + testTypeA.getClass().getSimpleName()));
            Assertions.assertEquals((Object)"Test", (Object)testTypeA.getName(), (String)"Referenced type should be named 'Test'");
            PropertyComponent nameProperty = TypeHandlerTestUtils.findProperty("name", this.componentRegistry);
            Assertions.assertEquals((Object)"Label for Test.name", (Object)nameProperty.getLabel(), (String)"Test.name property should preserve its label from type definition");
        }

        @Test
        @DisplayName(value="GIVEN object with parameterized type references WHEN processed THEN creates distinct specialized types")
        public void testParameterizedTypeResolution() {
            String script = "%dw 2.8\ntype Root = {\n  a: User<String>,\n  b: User<Number>\n}\n\ntype User<T> = {\n  name: String,\n  value: T\n}\n---\nRoot\n";
            WeaveType weaveType = (WeaveType)ReferenceTypeHandlerTest.this.engine.inferTypeOf(script).get();
            DWType dwType = ((TypeType)weaveType).getType();
            Component actualComponent = this.objectTypeHandler.make(dwType, "Root", this.serviceComponent, this.typeFactory);
            Assertions.assertTrue((boolean)(actualComponent instanceof ObjectTypeComponent), (String)("Parameterized type resolution should create ObjectTypeComponent, but got: " + actualComponent.getClass().getSimpleName()));
            PropertyComponent aProperty = TypeHandlerTestUtils.findProperty("a", this.componentRegistry);
            PropertyComponent bProperty = TypeHandlerTestUtils.findProperty("b", this.componentRegistry);
            Component userStringType = TypeHandlerTestUtils.findById(aProperty.getPropertyType(), this.componentRegistry.getComponents());
            Component userNumberType = TypeHandlerTestUtils.findById(bProperty.getPropertyType(), this.componentRegistry.getComponents());
            Assertions.assertNotEquals((Object)userStringType.getId(), (Object)userNumberType.getId(), (String)"User<String> and User<Number> should be distinct type instances");
            Assertions.assertEquals((Object)"User_String_", (Object)userStringType.getName(), (String)"Reference type for User<String> should be named as User_String_");
            Assertions.assertEquals((Object)"User_Number_", (Object)userNumberType.getName(), (String)"Reference type for User<Number> should be named as User_Number_");
            Assertions.assertTrue((boolean)(userStringType instanceof ObjectTypeComponent), (String)("User<String> should be an ObjectTypeComponent, but got: " + userStringType.getClass().getSimpleName()));
            Assertions.assertTrue((boolean)(userNumberType instanceof ObjectTypeComponent), (String)("User<Number> should be an ObjectTypeComponent, but got: " + userNumberType.getClass().getSimpleName()));
            Assertions.assertTrue((boolean)userStringType.getName().contains("String"), (String)("User<String> type name should reflect String parameterization: " + userStringType.getName()));
            Assertions.assertTrue((boolean)userNumberType.getName().contains("Number"), (String)("User<Number> type name should reflect Number parameterization: " + userNumberType.getName()));
        }

        @Test
        @DisplayName(value="GIVEN object with parameterized type references WHEN processed THEN creates name with underscores")
        public void testParameterizedTypeResolutionNameUpdate() {
            String script = "%dw 2.8\ntype Root = {\n  a: User<String, String>\n}\n\ntype User<T,N> = {\n  name: T,\n  value: N\n}\n---\nRoot\n";
            WeaveType weaveType = (WeaveType)ReferenceTypeHandlerTest.this.engine.inferTypeOf(script).get();
            DWType dwType = ((TypeType)weaveType).getType();
            Component actualComponent = this.objectTypeHandler.make(dwType, "Root", this.serviceComponent, this.typeFactory);
            Assertions.assertTrue((boolean)(actualComponent instanceof ObjectTypeComponent), (String)("Parameterized type resolution should create ObjectTypeComponent, but got: " + actualComponent.getClass().getSimpleName()));
            PropertyComponent aProperty = TypeHandlerTestUtils.findProperty("a", this.componentRegistry);
            Component userType = TypeHandlerTestUtils.findById(aProperty.getPropertyType(), this.componentRegistry.getComponents());
            Assertions.assertEquals((Object)"User_String__String_", (Object)userType.getName(), (String)"Reference type for User<String, String> should be named as User_String__String_");
            Assertions.assertTrue((boolean)(userType instanceof ObjectTypeComponent), (String)("User<String, String> should be an ObjectTypeComponent, but got: " + userType.getClass().getSimpleName()));
            Assertions.assertTrue((boolean)userType.getName().contains("String"), (String)("User<String, String> type name should reflect String parameterization: " + userType.getName()));
        }
    }
}

