/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.servicemodel.querybuilder;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Arrays;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.mule.weave.v2.api.tooling.ts.DWMetadata;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;

public class ObjectMetadataAssertion {
    private static final Gson gson = new Gson();

    public static void assertMetadata(String expected, DWType actual) {
        Assertions.assertNotNull((Object)expected, (String)"Expected metadata specification cannot be null");
        Assertions.assertNotNull((Object)actual, (String)"Actual DWType cannot be null");
        Assertions.assertTrue((boolean)(actual instanceof ObjectType), (String)"Actual DWType must be an ObjectType to validate field metadata");
        ObjectType objectType = (ObjectType)actual;
        JsonObject expectedJson = JsonParser.parseString((String)expected).getAsJsonObject();
        for (Map.Entry entry : expectedJson.entrySet()) {
            String fieldName = (String)entry.getKey();
            JsonObject fieldExpected = ((JsonElement)entry.getValue()).getAsJsonObject();
            KeyValuePairType actualField = Arrays.stream(objectType.getProperties()).filter(prop -> fieldName.equals(prop.getKeyName())).findFirst().orElse(null);
            Assertions.assertNotNull((Object)actualField, (String)("Field '" + fieldName + "' should exist in actual type"));
            ObjectMetadataAssertion.validateField(fieldName, fieldExpected, actualField);
        }
    }

    private static void validateField(String fieldName, JsonObject expected, KeyValuePairType actualField) {
        DWType fieldType = actualField.getValue();
        if (expected.has("type")) {
            String expectedType = expected.get("type").getAsString();
            String actualTypeStr = fieldType.toString();
            Assertions.assertTrue((actualTypeStr.contains(expectedType) || actualTypeStr.contains("SimpleReferenceType") ? 1 : 0) != 0, (String)("Field '" + fieldName + "' should reference " + expectedType + ". Actual: " + actualTypeStr));
        }
        if (expected.has("metadata")) {
            ObjectMetadataAssertion.validateMetadata(fieldName, expected.getAsJsonArray("metadata"), fieldType);
        }
        if (expected.has("valueProvider")) {
            ObjectMetadataAssertion.validateValueProvider(fieldName, expected.getAsJsonObject("valueProvider"), fieldType);
        }
    }

    private static void validateMetadata(String fieldName, JsonArray expectedMetadata, DWType fieldType) {
        Object[] actualMetadata = fieldType.getTypeMetadata();
        if (actualMetadata == null || actualMetadata.length == 0) {
            Assertions.fail((String)("Field '" + fieldName + "' should have metadata but none found"));
        }
        String actualMetadataStr = Arrays.toString(actualMetadata);
        String actualMetadataJson = ObjectMetadataAssertion.convertMetadataToJson((DWMetadata[])actualMetadata);
        for (JsonElement expectedEntry : expectedMetadata) {
            String expectedMetadataKey = expectedEntry.getAsString();
            Assertions.assertTrue((boolean)actualMetadataStr.contains(expectedMetadataKey), (String)("Field '" + fieldName + "' should contain metadata '" + expectedMetadataKey + "'. Actual metadata: " + actualMetadataStr));
        }
    }

    private static void validateValueProvider(String fieldName, JsonObject expectedValueProvider, DWType fieldType) {
        String actualMetadataStr;
        Object[] actualMetadata = fieldType.getTypeMetadata();
        if (actualMetadata == null || actualMetadata.length == 0) {
            Assertions.fail((String)("Field '" + fieldName + "' should have valueProvider metadata but no metadata found"));
        }
        Assertions.assertTrue(((actualMetadataStr = Arrays.toString(actualMetadata)).contains("valueProvider") || actualMetadataStr.contains("fieldsValueProvider") ? 1 : 0) != 0, (String)("Field '" + fieldName + "' should contain valueProvider metadata. Actual: " + actualMetadataStr));
        if (expectedValueProvider.has("name")) {
            String expectedName = expectedValueProvider.get("name").getAsString();
            Assertions.assertTrue((boolean)actualMetadataStr.contains(expectedName), (String)("ValueProvider should have name '" + expectedName + "'. Actual: " + actualMetadataStr));
        }
        if (expectedValueProvider.has("arguments")) {
            JsonObject expectedArgs = expectedValueProvider.getAsJsonObject("arguments");
            for (Map.Entry argEntry : expectedArgs.entrySet()) {
                String argKey = (String)argEntry.getKey();
                String argValue = ((JsonElement)argEntry.getValue()).getAsString();
                Assertions.assertTrue((actualMetadataStr.contains(argKey) && actualMetadataStr.contains(argValue) ? 1 : 0) != 0, (String)("ValueProvider arguments should contain '" + argKey + "': '" + argValue + "'. Actual: " + actualMetadataStr));
            }
        }
    }

    private static String convertMetadataToJson(DWMetadata[] metadata) {
        try {
            StringBuilder jsonBuilder = new StringBuilder();
            jsonBuilder.append("{\n");
            for (int i = 0; i < metadata.length; ++i) {
                String metadataEntry = metadata[i].toString();
                metadataEntry = metadataEntry.replaceAll("\\\"", "\"");
                jsonBuilder.append("  ").append(metadataEntry);
                if (i < metadata.length - 1) {
                    jsonBuilder.append(",");
                }
                jsonBuilder.append("\n");
            }
            jsonBuilder.append("}");
            return jsonBuilder.toString();
        }
        catch (Exception e) {
            return Arrays.toString(metadata);
        }
    }
}

