/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.persistence;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mulesoft.connectivity.flow.api.model.FlowConnectionProviderModel;
import com.mulesoft.connectivity.flow.api.model.FlowConnectorModel;
import com.mulesoft.connectivity.flow.api.model.IconMetadata;
import com.mulesoft.connectivity.flow.api.model.ReleaseStatus;
import com.mulesoft.connectivity.flow.api.model.SalesforceRelease;
import com.mulesoft.connectivity.flow.api.persistence.AuthenticationTypeDeserializer;
import com.mulesoft.connectivity.flow.api.persistence.ProviderReferenceDeserializer;
import com.mulesoft.connectivity.flow.api.persistence.gson.FlowConnectorModelTypeAdapter;
import com.mulesoft.connectivity.flow.api.persistence.gson.FlowTypeModelAdapter;
import com.mulesoft.connectivity.linkweave.api.loader.TypeUtils;
import com.mulesoft.connectivity.linkweave.api.model.ExecutableComponentModel;
import com.mulesoft.connectivity.linkweave.api.model.TypeModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.TestConnectionModel;
import com.mulesoft.connectivity.linkweave.api.model.operation.ErrorModel;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationModel;
import com.mulesoft.connectivity.linkweave.api.model.provider.MetadataProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.provider.ObjectFieldSelector;
import com.mulesoft.connectivity.linkweave.api.model.provider.ProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.provider.ProviderReference;
import com.mulesoft.connectivity.linkweave.api.model.provider.ValueProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.trigger.TriggerModel;
import com.mulesoft.connectivity.linkweave.api.persistence.gson.WeaveTypeCatalogCollector;
import com.mulesoft.connectivity.linkweave.api.persistence.gson.WeaveTypeCatalogTypeAdapter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.api.tooling.impl.ts.catalog.DefaultDWTypeCatalog;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.catalog.DWTypeCatalog;
import org.mule.weave.v2.api.tooling.ts.catalog.DWTypeCatalogLoader;
import org.mule.weave.v2.parser.phase.ModuleParsingPhasesManager;

public class FlowModelSerializer {
    private static final String NAME_PROPERTY = "name";
    private static final String DISPLAY_NAME_PROPERTY = "displayName";
    private static final String DESCRIPTION_PROPERTY = "description";
    private static final String VENDOR_PROPERTY = "vendor";
    private static final String VERSION_PROPERTY = "version";
    private static final String RELEASE_STATUS_PROPERTY = "releaseStatus";
    private static final String MODEL_REFERENCE_PROPERTY = "modelReference";
    private static final String ICONS_PROPERTY = "icons";
    private static final String CONNECTIONS_PROPERTY = "connections";
    private static final String TEST_CONNECTION_PROPERTY = "testConnection";
    private static final String OPERATIONS_PROPERTY = "operations";
    private static final String TRIGGERS_PROPERTY = "triggers";
    private static final String VALUE_PROVIDERS_PROPERTY = "valueProviders";
    private static final String METADATA_PROVIDERS_PROPERTY = "metadataProviders";
    private static final String INPUT_TYPE_PROPERTY = "inputType";
    private static final String INPUT_RESOLVED_PROVIDERS_PROPERTY = "inputResolvedProviders";
    private static final String ERROR_OUTPUT_TYPE_PROPERTY = "errorOutputType";
    private static final String ERROR_MODELS_TYPE_PROPERTY = "errorModels";
    private static final String IS_PAGINATED_PROPERTY = "isPaginated";
    private static final String ORDER_PROPERTY = "order";
    private static final String PROVIDED_VALUE_TYPE_PROPERTY = "providedValueType";
    private static final String DISPLAY_PROPERTIES_TYPE_PROPERTY = "displayPropertiesType";
    private static final String OUTPUT_TYPE_PROPERTY = "outputType";
    private static final String OUTPUT_RESOLVED_PROVIDERS_PROPERTY = "outputResolvedProviders";
    private static final String AUTHENTICATION_TYPE_PROPERTY = "authenticationType";
    private static final String TYPE_PROPERTY = "type";
    private static final String SUB_TYPE_PROPERTY = "subType";
    private static final String ALTERNATE_TEXT_PROPERTY = "alternateText";
    private static final String RESOURCE_PROPERTY = "resource";
    private static final String SIZE_PROPERTY = "size";
    private static final String DIMENSIONS_PROPERTY = "dimensions";
    private static final String REFRESH_URL = "refreshUrl";
    private static final String SCOPES = "scopes";
    private static final String AUTHORIZATION_URL = "authorizationUrl";
    private static final String TOKEN_URL = "tokenUrl";
    private static final String IN = "in";
    private static final String NAME = "name";
    public static final String CATALOG_PROPERTY = "catalog";
    public static final String HAS_EXTENSIONS = "hasExtensions";
    private static final String SINCE_PROPERTY = "since";
    private DWTypeCatalog catalog;

    public String serialize(FlowConnectorModel model) {
        StringWriter writer = new StringWriter();
        this.serialize(model, writer);
        return writer.toString();
    }

    public void serialize(FlowConnectorModel model, Writer writer) {
        WeaveTypeCatalogCollector catalogCollector = new WeaveTypeCatalogCollector();
        Gson gson = new GsonBuilder().registerTypeAdapter(FlowConnectorModel.class, (Object)new FlowConnectorModelTypeAdapter(catalogCollector)).registerTypeAdapter(TypeModel.class, (Object)new FlowTypeModelAdapter()).registerTypeHierarchyAdapter(DWType.class, (Object)new WeaveTypeCatalogTypeAdapter(catalogCollector)).create();
        gson.toJson((Object)model, (Appendable)writer);
    }

    public synchronized FlowConnectorModel deserialize(Map<?, ?> serialized) {
        return this.deserialize(serialized, null);
    }

    public synchronized FlowConnectorModel deserialize(Map<?, ?> serialized, @Nullable ModuleParsingPhasesManager mpfm) {
        DWTypeCatalogLoader loader = mpfm != null ? DefaultDWTypeCatalog.loader((ModuleParsingPhasesManager)mpfm) : DefaultDWTypeCatalog.loader();
        this.catalog = loader.withErrorHandler(errorMessages -> {
            throw new RuntimeException(String.join((CharSequence)"\n", errorMessages));
        }).fromCatalog(this.requireProperty(serialized, CATALOG_PROPERTY, String.class));
        return ((FlowConnectorModel.Builder)((Object)((FlowConnectorModel.Builder)((Object)((FlowConnectorModel.Builder)((Object)((FlowConnectorModel.Builder)((FlowConnectorModel.Builder)((FlowConnectorModel.Builder)new FlowConnectorModel.Builder().withName(this.requireProperty(serialized, "name", String.class))).withDisplayName(this.requireProperty(serialized, DISPLAY_NAME_PROPERTY, String.class))).withDescription(this.requireProperty(serialized, DESCRIPTION_PROPERTY, String.class)).withVendor(this.requireProperty(serialized, VENDOR_PROPERTY, String.class)).withSince((String)this.getProperty(serialized, SINCE_PROPERTY, SalesforceRelease.R256.name())).withVersion(this.requireProperty(serialized, VERSION_PROPERTY, String.class)).withReleaseStatus(ReleaseStatus.fromString(this.requireProperty(serialized, RELEASE_STATUS_PROPERTY, String.class))).withModelReference((String)this.getProperty(serialized, MODEL_REFERENCE_PROPERTY))).withIcons(this.deserializeIconsMetadata((List)this.getProperty(serialized, ICONS_PROPERTY))).withConnections(this.deserializeConnections((List)this.getProperty(serialized, CONNECTIONS_PROPERTY))))).withTestConnection(this.deserializeTestConnection((Map)this.getProperty(serialized, TEST_CONNECTION_PROPERTY))).withOperations(this.deserializeOperations(this.requireProperty(serialized, OPERATIONS_PROPERTY, List.class))))).withTriggers(this.deserializeTriggers((List)this.getProperty(serialized, TRIGGERS_PROPERTY))))).withValueProviders(this.deserializeValueProviders(this.requireProperty(serialized, VALUE_PROVIDERS_PROPERTY, List.class))).withMetadataProviders(this.deserializeMetadataProviders(this.requireProperty(serialized, METADATA_PROVIDERS_PROPERTY, List.class))).build();
    }

    private List<MetadataProviderModel> deserializeMetadataProviders(List<?> metadataProviders) {
        return metadataProviders.stream().map(p -> this.deserializeMetadataProvider((Map)p)).toList();
    }

    private MetadataProviderModel deserializeMetadataProvider(Map<?, ?> metadataProvider) {
        MetadataProviderModel.Builder builder = new MetadataProviderModel.Builder();
        this.configureProvider(metadataProvider, (ProviderModel.ProviderBuilder<?, ?>)builder);
        return (MetadataProviderModel)builder.build();
    }

    private List<ValueProviderModel> deserializeValueProviders(List<?> valueProviders) {
        return valueProviders.stream().map(p -> this.deserializeValueProvider((Map)p)).toList();
    }

    private ValueProviderModel deserializeValueProvider(Map<?, ?> map) {
        ValueProviderModel.Builder builder = new ValueProviderModel.Builder();
        this.configureProvider(map, (ProviderModel.ProviderBuilder<?, ?>)builder);
        ((ValueProviderModel.Builder)((ValueProviderModel.Builder)builder.isPaginated(this.requireProperty(map, IS_PAGINATED_PROPERTY, Boolean.class).booleanValue())).providedValueType(this.deserializeTypeModel(this.requireProperty(map, PROVIDED_VALUE_TYPE_PROPERTY, String.class)))).displayPropertiesType(this.deserializeDisplayProperties((String)this.getProperty(map, DISPLAY_PROPERTIES_TYPE_PROPERTY)));
        return (ValueProviderModel)builder.build();
    }

    private void configureProvider(Map<?, ?> map, ProviderModel.ProviderBuilder<?, ?> builder) {
        ((ProviderModel.ProviderBuilder)builder.name(this.requireProperty(map, "name", String.class)).withModelReference((String)this.getProperty(map, MODEL_REFERENCE_PROPERTY))).inputType(this.deserializeTypeModel(this.requireProperty(map, INPUT_TYPE_PROPERTY, String.class))).errorOutputType(this.deserializeTypeModel(this.requireProperty(map, ERROR_OUTPUT_TYPE_PROPERTY, String.class)));
    }

    private @Nullable TestConnectionModel deserializeTestConnection(@Nullable Map<String, Object> serialized) {
        if (serialized != null) {
            return (TestConnectionModel)((TestConnectionModel.Builder)new TestConnectionModel.Builder().withModelReference((String)this.getProperty(serialized, MODEL_REFERENCE_PROPERTY))).build();
        }
        return null;
    }

    private List<OperationModel> deserializeOperations(List<?> serializedOperations) {
        return serializedOperations.stream().map(o -> this.deserializeOperation((Map)o)).toList();
    }

    private OperationModel deserializeOperation(Map<?, ?> serializedOperation) {
        OperationModel.Builder builder = new OperationModel.Builder();
        this.deserializeExecutableComponent(serializedOperation, (ExecutableComponentModel.ExecutableComponentBuilder)builder);
        return (OperationModel)builder.build();
    }

    private <M extends ExecutableComponentModel<?>, T extends ExecutableComponentModel.ExecutableComponentBuilder<M, T>> void deserializeExecutableComponent(Map<?, ?> serializedOperation, ExecutableComponentModel.ExecutableComponentBuilder<M, T> builder) {
        String name = this.requireProperty(serializedOperation, "name", String.class);
        String displayName = this.requireProperty(serializedOperation, DISPLAY_NAME_PROPERTY, String.class);
        ((ExecutableComponentModel.ExecutableComponentBuilder)builder.withName(name).withDisplayName(displayName).withModelReference((String)this.getProperty(serializedOperation, MODEL_REFERENCE_PROPERTY))).withIsBase(true);
        this.deserializeImplementation(serializedOperation, builder);
        T extraVersionsObject = this.getProperty(serializedOperation, "extraVersions");
        if (extraVersionsObject != null) {
            TreeMap extraVersions = new TreeMap();
            Map extraVersionsMap = (Map)extraVersionsObject;
            OperationModel.Builder implementationBuilder = builder instanceof OperationModel.Builder ? new OperationModel.Builder() : new TriggerModel.Builder();
            implementationBuilder.withIsBase(false);
            implementationBuilder.withName(name);
            implementationBuilder.withDisplayName(displayName);
            extraVersionsMap.forEach((arg_0, arg_1) -> this.lambda$deserializeExecutableComponent$4((ExecutableComponentModel.ExecutableComponentBuilder)implementationBuilder, extraVersions, arg_0, arg_1));
            builder.withVersions(extraVersions);
        }
    }

    private <M extends ExecutableComponentModel<?>, T extends ExecutableComponentModel.ExecutableComponentBuilder<M, T>> void deserializeImplementation(Map<?, ?> serializedOperation, ExecutableComponentModel.ExecutableComponentBuilder<M, T> builder) {
        ((ExecutableComponentModel.ExecutableComponentBuilder)builder.withModelReference(this.requireProperty(serializedOperation, MODEL_REFERENCE_PROPERTY, String.class))).isPaginated(this.requireProperty(serializedOperation, IS_PAGINATED_PROPERTY, Boolean.class).booleanValue()).withInputType(this.deserializeTypeModel(this.requireProperty(serializedOperation, INPUT_TYPE_PROPERTY, String.class))).resolvedInputProviders(this.deserializeProviders(this.requireProperty(serializedOperation, INPUT_RESOLVED_PROVIDERS_PROPERTY, Map.class))).resolvedOutputProviders(this.deserializeProviders(this.requireProperty(serializedOperation, OUTPUT_RESOLVED_PROVIDERS_PROPERTY, Map.class))).withOutputType(this.deserializeTypeModel(this.requireProperty(serializedOperation, OUTPUT_TYPE_PROPERTY, String.class))).withErrorModels(this.deserializeErrorModels(this.requireProperty(serializedOperation, ERROR_MODELS_TYPE_PROPERTY, List.class))).withErrorOutputType(this.deserializeTypeModel(this.requireProperty(serializedOperation, ERROR_OUTPUT_TYPE_PROPERTY, String.class)));
        if (builder instanceof TriggerModel.AbstractTriggerBuilder) {
            ((TriggerModel.AbstractTriggerBuilder)builder).withOrder(this.requireProperty(serializedOperation, ORDER_PROPERTY, String.class));
        }
    }

    private Map<ObjectFieldSelector, ExecutableComponentModel.ProviderReferences> deserializeProviders(Map<?, ?> providers) {
        return providers.entrySet().stream().collect(Collectors.toMap(ref -> ObjectFieldSelector.create((String)((String)ref.getKey())), ref -> {
            Object valueProviderRef = ((Map)ref.getValue()).get("valueProviderReference");
            ProviderReference valueProvider = valueProviderRef != null ? ProviderReferenceDeserializer.createReference((Map)valueProviderRef) : null;
            Object metadataProviderRef = ((Map)ref.getValue()).get("metadataProviderReference");
            ProviderReference metadataProvider = metadataProviderRef != null ? ProviderReferenceDeserializer.createReference((Map)metadataProviderRef) : null;
            return new ExecutableComponentModel.ProviderReferences(valueProvider, metadataProvider);
        }));
    }

    private List<TriggerModel> deserializeTriggers(@Nullable List<?> serializedTriggers) {
        return Objects.requireNonNullElse(serializedTriggers, List.of()).stream().map(m -> this.deserializeTrigger((Map)m)).toList();
    }

    private TriggerModel deserializeTrigger(Map<?, ?> serializedTrigger) {
        TriggerModel.Builder builder = new TriggerModel.Builder();
        this.deserializeExecutableComponent(serializedTrigger, (ExecutableComponentModel.ExecutableComponentBuilder)builder);
        return (TriggerModel)builder.build();
    }

    private List<FlowConnectionProviderModel> deserializeConnections(@Nullable List<Map<String, Object>> serializedConnections) {
        LinkedList<FlowConnectionProviderModel> result = new LinkedList<FlowConnectionProviderModel>();
        if (serializedConnections != null) {
            int index = 0;
            for (Map<String, Object> serializedConnection : serializedConnections) {
                Map authenticationType = this.requireProperty(serializedConnection, AUTHENTICATION_TYPE_PROPERTY, Map.class);
                FlowConnectionProviderModel.Builder builder = (FlowConnectionProviderModel.Builder)((FlowConnectionProviderModel.Builder)((FlowConnectionProviderModel.Builder)((FlowConnectionProviderModel.Builder)((FlowConnectionProviderModel.Builder)((FlowConnectionProviderModel.Builder)new FlowConnectionProviderModel.Builder().withModelReference((String)this.getProperty(serializedConnection, MODEL_REFERENCE_PROPERTY))).authenticationType(new AuthenticationTypeDeserializer().deserializeAuthenticationType(authenticationType))).inputType(this.deserializeTypeModel(this.requireProperty(serializedConnection, INPUT_TYPE_PROPERTY, String.class)))).testConnection(this.deserializeTestConnection((Map)this.getProperty(serializedConnection, TEST_CONNECTION_PROPERTY)))).hasExtensions(this.requireProperty(serializedConnection, HAS_EXTENSIONS, Boolean.class))).name(this.getConnectionNamePropertyOrDefault(serializedConnection, index++));
                result.add((FlowConnectionProviderModel)builder.build());
            }
        }
        return result;
    }

    private String getConnectionNamePropertyOrDefault(Map<String, Object> serializedConnection, int connectionIndex) {
        String name = (String)this.getProperty(serializedConnection, "name");
        if (name != null) {
            return name;
        }
        String modelRef = (String)this.getProperty(serializedConnection, MODEL_REFERENCE_PROPERTY);
        if (modelRef != null) {
            String[] nameFromModelRef = modelRef.split("\\.");
            return nameFromModelRef[nameFromModelRef.length - 1];
        }
        return "serialized-model-connection-had-no-name-" + connectionIndex;
    }

    private DWType deserializeWeaveTypeReference(String serializedWeaveTypeReference) {
        return (DWType)this.catalog.getType(serializedWeaveTypeReference).orElseThrow(() -> new IllegalStateException("Unable to find weave type in catalog for id: " + serializedWeaveTypeReference));
    }

    private List<IconMetadata> deserializeIconsMetadata(@Nullable List<Map<String, Object>> serializedIcons) {
        LinkedList<IconMetadata> result = new LinkedList<IconMetadata>();
        if (serializedIcons != null) {
            for (Map<String, Object> serializedIcon : serializedIcons) {
                IconMetadata.Builder builder = new IconMetadata.Builder().withName(this.requireProperty(serializedIcon, "name", String.class)).withAlternateText(this.requireProperty(serializedIcon, ALTERNATE_TEXT_PROPERTY, String.class)).withResource(this.requireProperty(serializedIcon, RESOURCE_PROPERTY, String.class));
                result.add(builder.build());
            }
        }
        return result;
    }

    private List<ErrorModel> deserializeErrorModels(@Nullable List<?> errors) {
        if (errors == null || errors.isEmpty()) {
            return Collections.emptyList();
        }
        return errors.stream().map(map -> this.deserializeErrorModel((Map)map)).toList();
    }

    private ErrorModel deserializeErrorModel(Map<?, ?> map) {
        String kind = (String)map.get("kind");
        List categories = (List)map.get("categories");
        TypeModel value = this.deserializeTypeModel(this.requireProperty(map, "errorType", String.class));
        return new ErrorModel(kind, categories, value);
    }

    private TypeModel deserializeDisplayProperties(@Nullable String inputType) {
        return (TypeModel)new TypeModel.Builder().withDataType((DWType)(inputType != null ? this.deserializeWeaveTypeReference(inputType) : TypeUtils.emptyObject())).build();
    }

    private TypeModel deserializeTypeModel(String inputType) {
        return (TypeModel)new TypeModel.Builder().withDataType(this.deserializeWeaveTypeReference(inputType)).build();
    }

    private <T> @Nullable T getProperty(Map<?, ?> map, String property) {
        return (T)map.get(property);
    }

    private <T> T getProperty(Map<?, ?> serialized, String property, Object defaultValue) {
        Object value = serialized.get(property);
        return (T)(value != null ? value : defaultValue);
    }

    private <T> T requireProperty(Map<?, ?> map, String property, Class<T> expectedClass) {
        Object o = map.get(property);
        if (o == null) {
            throw new NullPointerException("Missing property '" + property + "' while deserializing.");
        }
        if (!expectedClass.isInstance(o)) {
            throw new IllegalArgumentException("Expecting property '" + property + "' while deserializing to be " + expectedClass.getSimpleName() + ", but was " + o.getClass().getSimpleName());
        }
        return expectedClass.cast(o);
    }

    private /* synthetic */ void lambda$deserializeExecutableComponent$4(ExecutableComponentModel.ExecutableComponentBuilder implementationBuilder, NavigableMap extraVersions, Object version, Object versionObject) {
        this.deserializeImplementation((Map)versionObject, implementationBuilder);
        int versionNumber = version instanceof String ? Integer.parseInt((String)version) : ((Number)version).intValue();
        extraVersions.put(versionNumber, (ExecutableComponentModel)implementationBuilder.build());
    }
}

