/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.connection;

import com.mulesoft.connectivity.linkweave.api.model.connection.ApiKeyHttpAuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.AuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.AuthenticationTypeVisitor;
import com.mulesoft.connectivity.linkweave.api.model.connection.HttpAuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.oauth.OAuth2AuthenticationType;

public class AuthenticationTypeExtractor
implements AuthenticationTypeVisitor {
    private HttpAuthenticationType.Type type;
    private String subType;

    private AuthenticationTypeExtractor() {
    }

    public HttpAuthenticationType.Type getType() {
        return this.type;
    }

    public String getSubType() {
        return this.subType;
    }

    public void visitHttpAuthenticationType(HttpAuthenticationType httpAuthenticationType) {
        this.type = httpAuthenticationType.getType();
        this.subType = httpAuthenticationType.getSubType().orElse(null);
    }

    public void visitApiKeyHttpAuthenticationType(ApiKeyHttpAuthenticationType apiKeyHttpAuthenticationType) {
        this.type = apiKeyHttpAuthenticationType.getType();
        this.subType = apiKeyHttpAuthenticationType.getSubType().orElse(null);
    }

    public void visitOAuth2HttpAuthenticationType(OAuth2AuthenticationType oAuth2AuthenticationType) {
        this.type = oAuth2AuthenticationType.getType();
        this.subType = oAuth2AuthenticationType.getSubType().orElse(null);
    }

    public static AuthenticationTypeExtractor getFrom(AuthenticationType authenticationType) {
        AuthenticationTypeExtractor authenticationTypeExtractor = new AuthenticationTypeExtractor();
        authenticationType.accept((AuthenticationTypeVisitor)authenticationTypeExtractor);
        return authenticationTypeExtractor;
    }
}

