/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.connector;

import com.mulesoft.connectivity.flow.internal.connection.AuthenticationReference;
import com.mulesoft.connectivity.flow.internal.connector.FlowConnection;
import com.mulesoft.connectivity.flow.internal.executables.ConnectionDescription;
import com.mulesoft.connectivity.flow.internal.executables.Executables;
import com.mulesoft.connectivity.linkweave.api.connector.Connection;
import com.mulesoft.connectivity.linkweave.api.connector.Connector;
import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreter;
import java.util.Map;
import java.util.Optional;

class FlowConnector
implements Connector {
    private final ModelInterpreter modelInterpreter;
    private final Executables executables;

    FlowConnector(Executables executables, ModelInterpreter modelInterpreter) {
        this.executables = executables;
        this.modelInterpreter = modelInterpreter;
    }

    public Optional<Connection> getConnection(Map<String, Object> authType, Map<String, Object> connectionInfo) {
        Optional<ConnectionDescription> connectionDescriptionOptional = this.executables.getConnection(AuthenticationReference.fromMap(authType));
        if (connectionDescriptionOptional.isEmpty()) {
            return Optional.empty();
        }
        ConnectionDescription connectionDescription = connectionDescriptionOptional.get();
        Map<String, Object> baseConnectionInfo = connectionDescription.getBaseConnectionInfo();
        baseConnectionInfo.putAll(connectionInfo);
        return Optional.of(new FlowConnection(this.modelInterpreter, connectionDescription, baseConnectionInfo, this.executables));
    }
}

