/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.executables;

import com.mulesoft.connectivity.flow.internal.connection.AuthenticationReference;
import com.mulesoft.connectivity.flow.internal.executables.ConnectionDescription;
import com.mulesoft.connectivity.flow.internal.executables.Executable;
import com.mulesoft.connectivity.flow.internal.executables.Provider;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

public final class Executables {
    private final Map<String, Executable> operations;
    private final Map<String, Executable> triggers;
    private final Map<String, Provider> valueProviders;
    private final Map<String, Provider> typeProviders;
    private final List<ConnectionDescription> connections;

    public Executables(Map<String, Executable> operations, Map<String, Executable> triggers, Map<String, Provider> valueProviders, Map<String, Provider> typeProviders, List<ConnectionDescription> connections) {
        this.operations = operations;
        this.triggers = triggers;
        this.valueProviders = valueProviders;
        this.typeProviders = typeProviders;
        this.connections = connections;
    }

    public Optional<ConnectionDescription> getConnection(AuthenticationReference authenticationReference) {
        return this.connections.stream().filter(c -> AuthenticationReference.fromMap(c.getAuthenticationType()).equals(authenticationReference)).findFirst();
    }

    @Generated
    public static ExecutablesBuilder builder() {
        return new ExecutablesBuilder();
    }

    @Generated
    public Map<String, Executable> getOperations() {
        return this.operations;
    }

    @Generated
    public Map<String, Executable> getTriggers() {
        return this.triggers;
    }

    @Generated
    public Map<String, Provider> getValueProviders() {
        return this.valueProviders;
    }

    @Generated
    public Map<String, Provider> getTypeProviders() {
        return this.typeProviders;
    }

    @Generated
    public List<ConnectionDescription> getConnections() {
        return this.connections;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Executables)) {
            return false;
        }
        Executables other = (Executables)o;
        Map<String, Executable> this$operations = this.getOperations();
        Map<String, Executable> other$operations = other.getOperations();
        if (this$operations == null ? other$operations != null : !((Object)this$operations).equals(other$operations)) {
            return false;
        }
        Map<String, Executable> this$triggers = this.getTriggers();
        Map<String, Executable> other$triggers = other.getTriggers();
        if (this$triggers == null ? other$triggers != null : !((Object)this$triggers).equals(other$triggers)) {
            return false;
        }
        Map<String, Provider> this$valueProviders = this.getValueProviders();
        Map<String, Provider> other$valueProviders = other.getValueProviders();
        if (this$valueProviders == null ? other$valueProviders != null : !((Object)this$valueProviders).equals(other$valueProviders)) {
            return false;
        }
        Map<String, Provider> this$typeProviders = this.getTypeProviders();
        Map<String, Provider> other$typeProviders = other.getTypeProviders();
        if (this$typeProviders == null ? other$typeProviders != null : !((Object)this$typeProviders).equals(other$typeProviders)) {
            return false;
        }
        List<ConnectionDescription> this$connections = this.getConnections();
        List<ConnectionDescription> other$connections = other.getConnections();
        return !(this$connections == null ? other$connections != null : !((Object)this$connections).equals(other$connections));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Executable> $operations = this.getOperations();
        result = result * 59 + ($operations == null ? 43 : ((Object)$operations).hashCode());
        Map<String, Executable> $triggers = this.getTriggers();
        result = result * 59 + ($triggers == null ? 43 : ((Object)$triggers).hashCode());
        Map<String, Provider> $valueProviders = this.getValueProviders();
        result = result * 59 + ($valueProviders == null ? 43 : ((Object)$valueProviders).hashCode());
        Map<String, Provider> $typeProviders = this.getTypeProviders();
        result = result * 59 + ($typeProviders == null ? 43 : ((Object)$typeProviders).hashCode());
        List<ConnectionDescription> $connections = this.getConnections();
        result = result * 59 + ($connections == null ? 43 : ((Object)$connections).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Executables(operations=" + String.valueOf(this.getOperations()) + ", triggers=" + String.valueOf(this.getTriggers()) + ", valueProviders=" + String.valueOf(this.getValueProviders()) + ", typeProviders=" + String.valueOf(this.getTypeProviders()) + ", connections=" + String.valueOf(this.getConnections()) + ")";
    }

    @Generated
    public static class ExecutablesBuilder {
        @Generated
        private Map<String, Executable> operations;
        @Generated
        private Map<String, Executable> triggers;
        @Generated
        private Map<String, Provider> valueProviders;
        @Generated
        private Map<String, Provider> typeProviders;
        @Generated
        private List<ConnectionDescription> connections;

        @Generated
        ExecutablesBuilder() {
        }

        @Generated
        public ExecutablesBuilder operations(Map<String, Executable> operations) {
            this.operations = operations;
            return this;
        }

        @Generated
        public ExecutablesBuilder triggers(Map<String, Executable> triggers) {
            this.triggers = triggers;
            return this;
        }

        @Generated
        public ExecutablesBuilder valueProviders(Map<String, Provider> valueProviders) {
            this.valueProviders = valueProviders;
            return this;
        }

        @Generated
        public ExecutablesBuilder typeProviders(Map<String, Provider> typeProviders) {
            this.typeProviders = typeProviders;
            return this;
        }

        @Generated
        public ExecutablesBuilder connections(List<ConnectionDescription> connections) {
            this.connections = connections;
            return this;
        }

        @Generated
        public Executables build() {
            return new Executables(this.operations, this.triggers, this.valueProviders, this.typeProviders, this.connections);
        }

        @Generated
        public String toString() {
            return "Executables.ExecutablesBuilder(operations=" + String.valueOf(this.operations) + ", triggers=" + String.valueOf(this.triggers) + ", valueProviders=" + String.valueOf(this.valueProviders) + ", typeProviders=" + String.valueOf(this.typeProviders) + ", connections=" + String.valueOf(this.connections) + ")";
        }
    }
}

