/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.executables;

import com.google.gson.Gson;
import com.mulesoft.connectivity.flow.api.model.FlowConnectorModel;
import com.mulesoft.connectivity.flow.internal.executables.ConnectionDescription;
import com.mulesoft.connectivity.flow.internal.executables.Executable;
import com.mulesoft.connectivity.flow.internal.executables.ExecutableVersion;
import com.mulesoft.connectivity.flow.internal.executables.Executables;
import com.mulesoft.connectivity.flow.internal.executables.Provider;
import com.mulesoft.connectivity.linkweave.api.model.ExecutableComponentModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.BaseConnectionProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.TestConnectionModel;
import com.mulesoft.connectivity.linkweave.api.model.provider.ProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.provider.ValueProviderModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ExecutablesFactory {
    private final Gson gson = new Gson();

    public Executables fromConnectorModel(FlowConnectorModel connectorModel) {
        Map<String, Executable> operations = connectorModel.getOperations().stream().map(this::fromExecutableComponentModel).collect(Collectors.toMap(Executable::getName, Function.identity()));
        Map<String, Executable> triggers = connectorModel.getTriggers().stream().map(this::fromExecutableComponentModel).collect(Collectors.toMap(Executable::getName, Function.identity()));
        Map<String, Provider> valueProviders = connectorModel.getValueProviders().stream().map(this::fromProviderModel).collect(Collectors.toMap(Provider::getName, Function.identity()));
        Map<String, Provider> typeProviders = connectorModel.getMetadataProviders().stream().map(this::fromProviderModel).collect(Collectors.toMap(Provider::getName, Function.identity()));
        List<ConnectionDescription> connections = this.createConnectionsResolvers(connectorModel.getTestConnection(), connectorModel.getConnections().stream().map(BaseConnectionProviderModel.class::cast).toList());
        return Executables.builder().operations(operations).triggers(triggers).valueProviders(valueProviders).typeProviders(typeProviders).connections(connections).build();
    }

    private List<ConnectionDescription> createConnectionsResolvers(TestConnectionModel defaultTestConnectionModel, List<BaseConnectionProviderModel> connections) {
        ArrayList<ConnectionDescription> connectionDescriptionList = new ArrayList<ConnectionDescription>();
        for (BaseConnectionProviderModel baseConnection : connections) {
            TestConnectionModel testConnectionModel = baseConnection.getTestConnection();
            if (testConnectionModel == null) {
                testConnectionModel = defaultTestConnectionModel;
            }
            ConnectionDescription connectionDescription = this.createConnection(baseConnection, testConnectionModel);
            connectionDescriptionList.add(connectionDescription);
        }
        return connectionDescriptionList;
    }

    private ConnectionDescription createConnection(BaseConnectionProviderModel baseConnection, TestConnectionModel testConnectionModel) {
        return ConnectionDescription.builder().authenticationType((Map)this.gson.fromJson(this.gson.toJson((Object)baseConnection.getAuthenticationType()), Map.class)).testConnectionModelReference((String)testConnectionModel.getModelReference().orElseThrow(() -> new IllegalArgumentException("Model reference is required"))).connectionModelReference((String)baseConnection.getModelReference().orElseThrow(() -> new IllegalArgumentException("Model reference is required"))).build();
    }

    private Executable fromExecutableComponentModel(ExecutableComponentModel<?> executableComponentModel) {
        HashMap<Integer, ExecutableVersion> versions = new HashMap<Integer, ExecutableVersion>();
        executableComponentModel.getVersions().forEach((version, executableComponentModelVersion) -> versions.put((Integer)version, this.fromExecutableComponentModelVersion((ExecutableComponentModel<?>)executableComponentModelVersion)));
        return Executable.builder().name(executableComponentModel.getName()).versions(versions).build();
    }

    private ExecutableVersion fromExecutableComponentModelVersion(ExecutableComponentModel<?> executableComponentModel) {
        return ExecutableVersion.builder().modelReference((String)executableComponentModel.getModelReference().orElseThrow(() -> new IllegalArgumentException("Model reference is required"))).paginated(executableComponentModel.isPaginated()).build();
    }

    private Provider fromProviderModel(ProviderModel providerModel) {
        boolean isPaginated = false;
        if (providerModel instanceof ValueProviderModel) {
            isPaginated = ((ValueProviderModel)providerModel).isPaginated();
        }
        return Provider.builder().name(providerModel.getName()).modelReference((String)providerModel.getModelReference().orElseThrow(() -> new IllegalArgumentException("Model reference is required"))).paginated(isPaginated).build();
    }
}

