/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.model;

import com.mulesoft.connectivity.flow.api.model.FlowBaseConnectorModel;
import com.mulesoft.connectivity.flow.api.model.FlowConnectionProviderModel;
import com.mulesoft.connectivity.flow.api.model.IconMetadata;
import com.mulesoft.connectivity.flow.api.model.ReleaseStatus;
import com.mulesoft.connectivity.linkweave.api.model.connection.TestConnectionModel;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationModel;
import com.mulesoft.connectivity.linkweave.api.model.provider.MetadataProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.provider.ValueProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.trigger.TriggerModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;

public class FlowConnectorModel
extends FlowBaseConnectorModel<FlowConnectionProviderModel, OperationModel, TriggerModel> {
    private static final long serialVersionUID = 1L;
    private final String version;
    private final String developerName;
    private final ReleaseStatus releaseStatus;
    private final String description;
    private final String vendor;
    private final String since;
    private final List<IconMetadata> icons;
    private final List<ValueProviderModel> valueProviders;
    private final List<MetadataProviderModel> metadataProviders;
    private static final Pattern WORD = Pattern.compile("\\p{Lu}+\\p{Ll}*|\\p{N}+|\\p{Ll}+");

    protected FlowConnectorModel(String name, String displayName, String version, ReleaseStatus releaseStatus, String description, String vendor, String since, List<IconMetadata> icons, List<FlowConnectionProviderModel> connections, List<OperationModel> operations, List<TriggerModel> triggers, List<ValueProviderModel> valueProviders, List<MetadataProviderModel> metadataProviders, @Nullable TestConnectionModel testConnection, @Nullable String modelReference) {
        super(name, displayName, connections, operations, triggers, testConnection, modelReference);
        this.version = version;
        this.releaseStatus = releaseStatus;
        this.description = description;
        this.vendor = vendor;
        this.since = since;
        this.icons = icons;
        this.valueProviders = valueProviders;
        this.metadataProviders = metadataProviders;
        this.developerName = FlowConnectorModel.buildDeveloperName(this.getName());
    }

    @Deprecated
    public String getVersion() {
        return this.version;
    }

    @Deprecated
    public ReleaseStatus getReleaseStatus() {
        return this.releaseStatus;
    }

    public String getDescription() {
        return this.description;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getSince() {
        return this.since;
    }

    public String getDeveloperName() {
        return this.developerName;
    }

    static String buildDeveloperName(String name) {
        Matcher m = WORD.matcher(name);
        StringBuilder sb = new StringBuilder();
        while (m.find()) {
            String w = m.group();
            int first = w.codePointAt(0);
            sb.appendCodePoint(Character.toUpperCase(first));
            sb.append(w.substring(Character.charCount(first)).toLowerCase(Locale.ROOT));
        }
        if (sb.isEmpty()) {
            throw new IllegalArgumentException("Can't build a connector developer name from name '" + name + "'.");
        }
        return sb.toString();
    }

    @Deprecated(forRemoval=true)
    public String getMasterLabel() {
        return String.format("%s %s", this.getDisplayName(), this.getVersion());
    }

    public List<IconMetadata> getIcons() {
        return this.icons;
    }

    public List<ValueProviderModel> getValueProviders() {
        return this.valueProviders;
    }

    public List<MetadataProviderModel> getMetadataProviders() {
        return this.metadataProviders;
    }

    public MetadataProviderModel getMetadataProvider(String name) {
        return this.getMetadataProviders().stream().filter(provider -> provider.getName().equals(name)).findFirst().orElseThrow(() -> new IllegalStateException("Cannot find metadata provider '" + name + "'"));
    }

    public ValueProviderModel getValueProvider(String name) {
        return this.getValueProviders().stream().filter(valueProvider -> valueProvider.getName().equals(name)).findFirst().orElseThrow(() -> new IllegalStateException("Cannot find value provider '" + name + "'"));
    }

    public String toString() {
        return "FlowConnectorModel{name='" + this.getName() + "', displayName='" + this.getDisplayName() + "', version='" + this.version + "', releaseStatus='" + String.valueOf((Object)this.releaseStatus) + "', description='" + this.description + "', vendor='" + this.vendor + "', since='" + this.since + "', developerName='" + this.getDeveloperName() + "', masterLabel='" + this.getMasterLabel() + "', modelReference='" + this.modelReference + "', icon='" + String.valueOf(this.icons) + "', connections='" + String.valueOf(this.connections) + "', operations='" + String.valueOf(this.operations) + "', triggers='" + String.valueOf(this.triggers) + "', testConnection='" + String.valueOf(this.testConnection) + "', valueProviders='" + String.valueOf(this.valueProviders) + "', metadataProviders='" + String.valueOf(this.metadataProviders) + "'}";
    }

    public static class Builder
    extends FlowBaseConnectorModel.AbstractBuilder<FlowConnectionProviderModel, OperationModel, TriggerModel, Builder, FlowConnectorModel> {
        private @Nullable String version;
        private @Nullable ReleaseStatus releaseStatus;
        private @Nullable String description;
        private @Nullable String vendor;
        private @Nullable String since;
        private @Nullable List<IconMetadata> icons;
        private List<ValueProviderModel> valueProviders = new ArrayList<ValueProviderModel>();
        private List<MetadataProviderModel> metadataProviders = new ArrayList<MetadataProviderModel>();

        protected FlowConnectorModel createInstance() {
            return new FlowConnectorModel(Objects.requireNonNull(this.name, "name"), Objects.requireNonNull(this.displayName, "displayName"), Objects.requireNonNull(this.version, "version"), Objects.requireNonNull(this.releaseStatus, "releaseStatus"), Objects.requireNonNull(this.description, "description"), Objects.requireNonNull(this.vendor, "vendor"), Objects.requireNonNull(this.since, "since"), Objects.requireNonNullElse(this.icons, List.of()), Objects.requireNonNull(this.connections, "connections"), Objects.requireNonNullElse(this.operations, List.of()), Objects.requireNonNullElse(this.triggers, List.of()), this.valueProviders, this.metadataProviders, this.testConnection, Objects.requireNonNull(this.modelReference, "modelReference"));
        }

        protected Builder getThis() {
            return this;
        }

        public Builder withVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder withReleaseStatus(ReleaseStatus releaseStatus) {
            this.releaseStatus = releaseStatus;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withVendor(String vendor) {
            this.vendor = vendor;
            return this;
        }

        public Builder withSince(String since) {
            this.since = since;
            return this;
        }

        public Builder withIcons(List<IconMetadata> icons) {
            this.icons = icons;
            return this;
        }

        public Builder withValueProviders(List<ValueProviderModel> valueProviders) {
            this.valueProviders = valueProviders;
            return this;
        }

        public Builder withMetadataProviders(List<MetadataProviderModel> metadataProviders) {
            this.metadataProviders = metadataProviders;
            return this;
        }

        private void validate() throws IllegalStateException {
            StringBuilder messages = new StringBuilder();
            if (this.name == null || this.name.isBlank()) {
                messages.append("Name is required\n");
            }
            if (this.displayName == null || this.displayName.isBlank()) {
                messages.append("DisplayName is required\n");
            }
            if (this.version == null || this.version.isBlank()) {
                messages.append("Version is required\n");
            }
            if (this.releaseStatus == null) {
                messages.append("ReleaseStatus is required\n");
            }
            if (this.description == null || this.description.isBlank()) {
                messages.append("Description is required\n");
            }
            if (this.vendor == null || this.vendor.isBlank()) {
                messages.append("Vendor is required\n");
            }
            if (this.since == null || this.since.isBlank()) {
                messages.append("Since is required\n");
            }
            if (this.modelReference == null || this.modelReference.isBlank()) {
                messages.append("modelReference is required\n");
            }
            if (Builder.isEmptyOrNull(this.icons)) {
                messages.append("At least one IconMetadata is required\n");
            }
            if (Builder.isEmptyOrNull(this.connections)) {
                messages.append("At least one Connection Definition is required\n");
            }
            if (Builder.isEmptyOrNull(this.operations)) {
                messages.append("At least one Operation Definition is required\n");
            }
            if (this.testConnection == null) {
                messages.append("Test Connection Model is required\n");
            }
            if (!messages.isEmpty()) {
                throw new IllegalStateException(messages.toString());
            }
        }

        private static boolean isEmptyOrNull(@Nullable List<?> list) {
            return list == null || list.isEmpty();
        }

        @Override
        public FlowConnectorModel build() throws IllegalStateException {
            this.validate();
            return this.createInstance();
        }
    }
}

