/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.connection;

import com.mulesoft.connectivity.flow.internal.connection.FlowAuthenticationReference;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public class AuthenticationReferenceTest {
    @Test
    @DisplayName(value="GIVEN a map with authType and authSubType WHEN fromMap is called THEN returns an AuthenticationReference")
    void testFromMap() {
        Map<String, String> authType = Map.of("authType", "apiKey", "authSubType", "http");
        FlowAuthenticationReference authenticationReference = FlowAuthenticationReference.fromMap(authType);
        Assertions.assertEquals((Object)"apiKey", authenticationReference.getType().orElseThrow());
        Assertions.assertEquals((Object)"http", authenticationReference.getSubType().orElseThrow());
    }

    @Test
    @DisplayName(value="GIVEN an empty map THEN returns an AuthenticationReference with type and subType as Null")
    void testEmptyMap() {
        Map authType = Map.of();
        FlowAuthenticationReference authenticationReference = FlowAuthenticationReference.fromMap(authType);
        Assertions.assertTrue((boolean)authenticationReference.getType().isEmpty());
        Assertions.assertTrue((boolean)authenticationReference.getSubType().isEmpty());
    }

    @Test
    @DisplayName(value="GIVEN a map with type and subType WHEN fromMap is called THEN returns an AuthenticationReference")
    void testFromMapTypeAndSubType() {
        Map<String, String> authType = Map.of("type", "apiKey", "subType", "http");
        FlowAuthenticationReference authenticationReference = FlowAuthenticationReference.fromMap(authType);
        Assertions.assertEquals((Object)"apiKey", authenticationReference.getType().orElseThrow());
        Assertions.assertEquals((Object)"http", authenticationReference.getSubType().orElseThrow());
    }

    @Test
    @DisplayName(value="GIVEN a map with type and no subType WHEN fromMap is called THEN returns an AuthenticationReference")
    void testFromMapTypeAndNoSubType() {
        Map<String, String> authType = Map.of("type", "apiKey");
        FlowAuthenticationReference authenticationReference = FlowAuthenticationReference.fromMap(authType);
        Assertions.assertEquals((Object)"apiKey", authenticationReference.getType().orElseThrow());
        Assertions.assertFalse((boolean)authenticationReference.getSubType().isPresent());
    }

    @Test
    @DisplayName(value="GIVEN a map with authType and no authSubType WHEN fromMap is called THEN returns an AuthenticationReference")
    void testFromMapAuthTypeAndNoAuthSubType() {
        Map<String, String> authType = Map.of("authType", "apiKey");
        FlowAuthenticationReference authenticationReference = FlowAuthenticationReference.fromMap(authType);
        Assertions.assertEquals((Object)"apiKey", authenticationReference.getType().orElseThrow());
        Assertions.assertFalse((boolean)authenticationReference.getSubType().isPresent());
    }
}

