/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.connector;

import com.mulesoft.connectivity.flow.internal.connection.FlowAuthenticationReference;
import com.mulesoft.connectivity.flow.internal.connector.FlowConnection;
import com.mulesoft.connectivity.flow.internal.connector.FlowConnector;
import com.mulesoft.connectivity.flow.internal.executables.ConnectionDescription;
import com.mulesoft.connectivity.flow.internal.executables.Executables;
import com.mulesoft.connectivity.linkweave.api.connector.AuthenticationReference;
import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreter;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class FlowConnectorTest {

    @Nested
    @DisplayName(value="Connection Management")
    class ConnectionManagement {
        ConnectionManagement() {
        }

        @Test
        @DisplayName(value="GIVEN a FlowConnector\nWHEN getConnection is called with authType and connectionInfo\nTHEN returns Optional containing FlowConnection with merged connection info")
        void FlowConnectorCallingGetConnection() {
            ModelInterpreter mockModelInterpreter = (ModelInterpreter)Mockito.mock(ModelInterpreter.class);
            Executables mockExecutables = (Executables)Mockito.mock(Executables.class);
            ConnectionDescription mockConnectionDescription = (ConnectionDescription)Mockito.mock(ConnectionDescription.class);
            FlowAuthenticationReference authType = FlowAuthenticationReference.fromMap(Map.of("type", "bearer"));
            Map<String, String> connectionInfo = Map.of("host", "example.com");
            HashMap<String, String> baseConnectionInfo = new HashMap<String, String>();
            baseConnectionInfo.put("port", "8080");
            Mockito.when((Object)mockExecutables.getConnection((AuthenticationReference)ArgumentMatchers.any(FlowAuthenticationReference.class))).thenReturn(Optional.of(mockConnectionDescription));
            Mockito.when((Object)mockConnectionDescription.getBaseConnectionInfo()).thenReturn(baseConnectionInfo);
            FlowConnector flowConnector = new FlowConnector(mockExecutables, mockModelInterpreter);
            Optional result = flowConnector.getConnection((AuthenticationReference)authType, connectionInfo);
            Assertions.assertTrue((boolean)result.isPresent());
            Assertions.assertInstanceOf(FlowConnection.class, result.get());
        }
    }
}

