%dw 2.8

import * from dw::core::Arrays

import * from com::mulesoft::connectivity::Model
import * from com::mulesoft::connectivity::decorator::Annotations
import * from com::mulesoft::connectivity::decorator::Operation
import * from com::mulesoft::connectivity::metadata::Builder
import * from com::mulesoft::connectivity::Metadata
import * from com::mulesoft::connectivity::flow::Metadata
import * from com::mulesoft::connectivity::transport::Http
import * from com::mulesoft::connectivity::decorator::ValueProvider

var orderType : TypeValueDefinition =
    createObjectTypeValueDefinition("Order")
      withField
        createField("orderId",createStringTypeValueDefinition(), true)
      withField
        createField("description",createStringTypeValueDefinition(), false)


var metadataProvider: MetadataProviderExecutor<{objectType: String}, {errorMessage: String}, HttpConnection> =
    (key, conn) -> success(orderType)

type Record = {
   objectType: String,
   record: @MetadataProvider(value = { name: "metadataProvider", arguments: { objectType: "objectType" } }) Object
}

var createRecordOperation: Operation<Record, @MetadataProvider(value = { name: "metadataProvider", arguments: { objectType: "/objectType" } }) Object, ResultFailure<{}, Error>, HttpConnection> = {
    name: "createRecordOperation",
    displayName: "Create Record",
    executor: (parameter, connection) -> success({})
}

@OperationElement
var isAlive: Operation<{}, HttpResponse, ResultFailure<HttpResponse, Error>, HttpConnection> = {
    name: "isAlive",
    displayName: "Is alive",
    executor: (parameter, connection) -> success(
        	{
                contentType: "application/json",
                status: 200,
                headers: {},
                cookies: {}
    		})
}

@TestConnectionElement()
var testConnection = {
	validate: defineTestConnection(
        isAlive,
        (response) -> { isValid: response.value.status == 200 }
    )
}

@ConnectionElement()
var basicAuthConnection = defineBasicHttpConnectionProvider<BasicAuthSchema>(
                              (parameter) -> parameter,
                              (parameter) -> {baseUri: "http://localhost"
                              }
)

@FlowConnectorElement()
var connector = {
    name: "TWILIO",
    displayName: "Twilio",
    description: "Twilio Connector",
    vendor: "Salesforce",
    since: "R256",
    icons: [
        {
            name: "Twilio",
            alternateText: "Twilio Connector",
            resource: "icon/twilio.svg",
            size: 65440,
            dimensions: "32x32"
        }
    ],
    connections: {basicAuth: basicAuthConnection},
    testConnection: testConnection,
    operations: {
       createRecordOperation: createRecordOperation
    },
    valueProviders: {
    },
    metadataProviders: {
      metadataProvider : metadataProvider
    }
}
