/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.connection;

import com.mulesoft.connectivity.linkweave.api.connector.AuthenticationReference;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

public final class FlowAuthenticationReference
implements AuthenticationReference {
    public static final String AUTH_TYPE = "authType";
    public static final String AUTH_SUB_TYPE = "authSubType";
    private final @Nullable String type;
    private final @Nullable String subType;

    public FlowAuthenticationReference(@Nullable String type, @Nullable String subType) {
        this.type = type;
        this.subType = subType;
    }

    public static FlowAuthenticationReference fromMap(Map<String, Object> authType) {
        String type = Optional.ofNullable(authType.get(AUTH_TYPE)).or(() -> Optional.ofNullable(authType.get("type"))).orElse(null);
        String subType = Optional.ofNullable(authType.get(AUTH_SUB_TYPE)).or(() -> Optional.ofNullable(authType.get("subType"))).orElse(null);
        return new FlowAuthenticationReference(type, subType);
    }

    public Optional<String> getType() {
        return Optional.ofNullable(this.type);
    }

    public Optional<String> getSubType() {
        return Optional.ofNullable(this.subType);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        FlowAuthenticationReference that = (FlowAuthenticationReference)obj;
        return Objects.equals(this.type, that.type) && Objects.equals(this.subType, that.subType);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.subType);
    }

    public String toString() {
        return "AuthenticationReference[type=" + this.type + ", subType=" + this.subType + "]";
    }
}

