/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.executable;

import com.mulesoft.connectivity.flow.internal.connection.AuthenticationTypeExtractor;
import com.mulesoft.connectivity.flow.internal.executables.ConnectionDescription;
import com.mulesoft.connectivity.linkweave.api.model.connection.AuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.BaseConnectionProviderModel;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

public class ConnectionDescriptionTest {
    @Test
    @DisplayName(value="GIVEN a connection description WHEN call toConnectionProviderModel THEN returns a ConnectionProviderModel")
    void testToConnectionProviderModel() {
        ConnectionDescription connectionDescription = new ConnectionDescription(Map.of("type", "bearer"), "testConnectionModelReference", "connectionModelReference", false);
        BaseConnectionProviderModel connectionProviderModel = connectionDescription.toConnectionProviderModel();
        AuthenticationTypeExtractor typeExtractor = AuthenticationTypeExtractor.getFrom((AuthenticationType)connectionProviderModel.getAuthenticationType());
        Assertions.assertEquals((Object)"bearer", (Object)typeExtractor.getType().name());
        Assertions.assertNull((Object)typeExtractor.getSubType());
        Assertions.assertEquals((Object)"testConnectionModelReference", connectionProviderModel.getTestConnection().getModelReference().get());
        Assertions.assertEquals((Object)"connectionModelReference", connectionProviderModel.getModelReference().get());
    }

    @Nested
    public class GetBaseConnectionInfo {
        @Test
        @DisplayName(value="GIVEN a connection description with bearer WHEN call getBaseConnectionInfo THEN returns the correct map")
        void testGetBaseConnectionInfoBearer() {
            ConnectionDescription connectionDescription = new ConnectionDescription(Map.of("type", "bearer"), "testConnectionModelReference", "connectionModelReference", false);
            Map baseConnectionInfo = connectionDescription.getBaseConnectionInfo();
            Assertions.assertTrue((boolean)baseConnectionInfo.containsKey("token"));
        }

        @Test
        @DisplayName(value="GIVEN a connection description with basic WHEN call getBaseConnectionInfo THEN returns the correct map")
        void testGetBaseConnectionInfoBasic() {
            ConnectionDescription connectionDescription = new ConnectionDescription(Map.of("type", "basic"), "testConnectionModelReference", "connectionModelReference", false);
            Map baseConnectionInfo = connectionDescription.getBaseConnectionInfo();
            Assertions.assertTrue((boolean)baseConnectionInfo.containsKey("username"));
            Assertions.assertTrue((boolean)baseConnectionInfo.containsKey("password"));
        }

        @Test
        @DisplayName(value="GIVEN a connection description with apiKey WHEN call getBaseConnectionInfo THEN returns the correct map")
        void testGetBaseConnectionInfoApiKey() {
            ConnectionDescription connectionDescription = new ConnectionDescription(Map.of("type", "apiKey", "in", "header", "name", "X-API-Key"), "testConnectionModelReference", "connectionModelReference", false);
            Map baseConnectionInfo = connectionDescription.getBaseConnectionInfo();
            Assertions.assertTrue((boolean)baseConnectionInfo.containsKey("apiKey"));
        }

        @Test
        @DisplayName(value="GIVEN a connection description with oauth2 WHEN call getBaseConnectionInfo THEN returns the correct map")
        void testGetBaseConnectionInfoOAuth2() {
            ConnectionDescription connectionDescription = new ConnectionDescription(Map.of("type", "oauth2", "subType", "clientCredentials", "tokenUrl", "something"), "testConnectionModelReference", "connectionModelReference", false);
            Map baseConnectionInfo = connectionDescription.getBaseConnectionInfo();
            Assertions.assertTrue((boolean)baseConnectionInfo.containsKey("accessToken"));
            Assertions.assertTrue((boolean)baseConnectionInfo.containsKey("subType"));
        }
    }
}

