/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.connector;

import com.mulesoft.connectivity.flow.internal.connector.FlowConnection;
import com.mulesoft.connectivity.flow.internal.connector.FlowOperation;
import com.mulesoft.connectivity.flow.internal.executables.ExecutableVersion;
import com.mulesoft.connectivity.linkweave.api.interpreter.Connection;
import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreter;
import com.mulesoft.connectivity.linkweave.api.model.BaseExecutableComponentModel;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationResult;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class FlowOperationTest {
    @Test
    @DisplayName(value="GIVEN a FlowOperation\nWHEN execute is called\nTHEN modelInterpreter.executeOperation is called with ConnectionHolder, OperationModel and parameters")
    void FlowOperationCallingExecute() {
        ModelInterpreter mockModelInterpreter = (ModelInterpreter)Mockito.mock(ModelInterpreter.class);
        Connection mockConnectionHolder = (Connection)Mockito.mock(Connection.class);
        FlowConnection mockConnection = (FlowConnection)Mockito.mock(FlowConnection.class);
        OperationResult mockOperationResult = (OperationResult)Mockito.mock(OperationResult.class);
        ExecutableVersion executableVersion = this.createExecutableVersion();
        Mockito.when((Object)mockConnection.asHolder()).thenReturn((Object)mockConnectionHolder);
        Mockito.when((Object)mockModelInterpreter.executeOperation((Connection)ArgumentMatchers.any(Connection.class), (BaseExecutableComponentModel)ArgumentMatchers.any(BaseExecutableComponentModel.class), ArgumentMatchers.any())).thenReturn((Object)mockOperationResult);
        FlowOperation flowOperation = new FlowOperation("testOperation", mockModelInterpreter, executableVersion, mockConnection);
        Object parameters = new Object();
        OperationResult result = flowOperation.execute(parameters, false);
        Assertions.assertEquals((Object)mockOperationResult, (Object)result);
        ((ModelInterpreter)Mockito.verify((Object)mockModelInterpreter)).executeOperation((Connection)ArgumentMatchers.eq((Object)mockConnectionHolder), (BaseExecutableComponentModel)ArgumentMatchers.any(BaseExecutableComponentModel.class), ArgumentMatchers.eq((Object)parameters));
        ((FlowConnection)Mockito.verify((Object)mockConnection)).asHolder();
    }

    @Test
    @DisplayName(value="GIVEN a FlowOperation\nWHEN executeNextPage is called\nTHEN modelInterpreter.executeOperationNextPage is called with ConnectionHolder, OperationModel and parameters")
    void FlowOperationCallingExecuteNextPage() {
        ModelInterpreter mockModelInterpreter = (ModelInterpreter)Mockito.mock(ModelInterpreter.class);
        Connection mockConnectionHolder = (Connection)Mockito.mock(Connection.class);
        FlowConnection mockConnection = (FlowConnection)Mockito.mock(FlowConnection.class);
        OperationResult mockOperationResult = (OperationResult)Mockito.mock(OperationResult.class);
        ExecutableVersion executableVersion = this.createExecutableVersion();
        Mockito.when((Object)mockConnection.asHolder()).thenReturn((Object)mockConnectionHolder);
        Mockito.when((Object)mockModelInterpreter.executeOperationNextPage((Connection)ArgumentMatchers.any(Connection.class), (BaseExecutableComponentModel)ArgumentMatchers.any(BaseExecutableComponentModel.class), ArgumentMatchers.any())).thenReturn((Object)mockOperationResult);
        FlowOperation flowOperation = new FlowOperation("testOperation", mockModelInterpreter, executableVersion, mockConnection);
        Object parameters = new Object();
        OperationResult result = flowOperation.execute(parameters, true);
        Assertions.assertEquals((Object)mockOperationResult, (Object)result);
        ((ModelInterpreter)Mockito.verify((Object)mockModelInterpreter)).executeOperationNextPage((Connection)ArgumentMatchers.eq((Object)mockConnectionHolder), (BaseExecutableComponentModel)ArgumentMatchers.any(BaseExecutableComponentModel.class), ArgumentMatchers.eq((Object)parameters));
        ((FlowConnection)Mockito.verify((Object)mockConnection)).asHolder();
    }

    private ExecutableVersion createExecutableVersion() {
        ExecutableVersion executableVersion = (ExecutableVersion)Mockito.mock(ExecutableVersion.class);
        Mockito.when((Object)executableVersion.getModelReference()).thenReturn((Object)"testModelReference");
        Mockito.when((Object)executableVersion.isPaginated()).thenReturn((Object)true);
        return executableVersion;
    }
}

