/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.connector;

import com.mulesoft.connectivity.flow.api.interpreter.FlowPlatformManagedConnection;
import com.mulesoft.connectivity.flow.internal.connection.AuthenticationTypeDeserializer;
import com.mulesoft.connectivity.flow.internal.connector.FlowConnection;
import com.mulesoft.connectivity.flow.internal.connector.FlowMetadataProvider;
import com.mulesoft.connectivity.flow.internal.connector.FlowOperation;
import com.mulesoft.connectivity.flow.internal.connector.FlowTrigger;
import com.mulesoft.connectivity.flow.internal.connector.FlowValueProvider;
import com.mulesoft.connectivity.flow.internal.executables.ConnectionDescription;
import com.mulesoft.connectivity.flow.internal.executables.Executable;
import com.mulesoft.connectivity.flow.internal.executables.ExecutableVersion;
import com.mulesoft.connectivity.flow.internal.executables.Executables;
import com.mulesoft.connectivity.flow.internal.executables.Provider;
import com.mulesoft.connectivity.linkweave.api.interpreter.Connection;
import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreter;
import com.mulesoft.connectivity.linkweave.api.model.connection.BaseConnectionProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.TestConnectionModel;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class FlowConnectionTest {
    @Test
    @DisplayName(value="GIVEN a FlowConnection\nWHEN test is called\nTHEN connectionDescription creates a ConnectionProviderModel and modelInterpreter.testConnection is called")
    void FlowConnectionCallingTest() {
        ModelInterpreter mockModelInterpreter = (ModelInterpreter)Mockito.mock(ModelInterpreter.class);
        ConnectionDescription connectionDescription = (ConnectionDescription)Mockito.mock(ConnectionDescription.class);
        BaseConnectionProviderModel connectionProviderModel = FlowConnectionTest.createConnectionProviderModel();
        Mockito.when((Object)connectionDescription.toConnectionProviderModel()).thenReturn((Object)connectionProviderModel);
        Map connectionInfo = Map.of();
        FlowConnection flowConnection = new FlowConnection(mockModelInterpreter, connectionDescription, connectionInfo, (Executables)Mockito.mock(Executables.class), "connection", false);
        flowConnection.test();
        ((ModelInterpreter)Mockito.verify((Object)mockModelInterpreter)).testConnection((TestConnectionModel)ArgumentMatchers.any(), (Connection)ArgumentMatchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockModelInterpreter});
    }

    @Test
    @DisplayName(value="GIVEN a FlowConnection\nWHEN asHolder is called\nTHEN returns ConnectionHolder with connectionProviderModel and connectionInfo")
    void FlowConnectionCallingAsHolder() {
        ModelInterpreter mockModelInterpreter = (ModelInterpreter)Mockito.mock(ModelInterpreter.class);
        ConnectionDescription connectionDescription = (ConnectionDescription)Mockito.mock(ConnectionDescription.class);
        BaseConnectionProviderModel connectionProviderModel = FlowConnectionTest.createConnectionProviderModel();
        Mockito.when((Object)connectionDescription.toConnectionProviderModel()).thenReturn((Object)connectionProviderModel);
        Map connectionInfo = Map.of();
        FlowConnection flowConnection = new FlowConnection(mockModelInterpreter, connectionDescription, connectionInfo, (Executables)Mockito.mock(Executables.class), "connection", false);
        Connection connectionHolder = flowConnection.asHolder();
        Assertions.assertEquals((Object)connectionProviderModel, (Object)connectionHolder.getProvider());
        Assertions.assertEquals(connectionInfo, (Object)connectionHolder.getInfo());
    }

    @Test
    @DisplayName(value="GIVEN a FlowConnection with PlatformManaged true\nWHEN asHolder is called\nTHEN returns PlatformManagedConnection")
    void FlowConnectionCallingAsHolderReturnsPlatformManaged() {
        ModelInterpreter mockModelInterpreter = (ModelInterpreter)Mockito.mock(ModelInterpreter.class);
        ConnectionDescription connectionDescription = (ConnectionDescription)Mockito.mock(ConnectionDescription.class);
        BaseConnectionProviderModel connectionProviderModel = FlowConnectionTest.createConnectionProviderModel();
        Mockito.when((Object)connectionDescription.toConnectionProviderModel()).thenReturn((Object)connectionProviderModel);
        Map connectionInfo = Map.of();
        FlowConnection flowConnection = new FlowConnection(mockModelInterpreter, connectionDescription, connectionInfo, (Executables)Mockito.mock(Executables.class), "connection", true);
        Connection connectionHolder = flowConnection.asHolder();
        Assertions.assertInstanceOf(FlowPlatformManagedConnection.class, (Object)connectionHolder);
    }

    @Test
    @DisplayName(value="GIVEN a FlowConnector with available operations\nWHEN getOperation is called with name and version\nTHEN returns Optional containing FlowOperation")
    void FlowConnectionCallingGetOperation() {
        ModelInterpreter mockModelInterpreter = (ModelInterpreter)Mockito.mock(ModelInterpreter.class);
        Executables mockExecutables = (Executables)Mockito.mock(Executables.class);
        Executable mockExecutable = (Executable)Mockito.mock(Executable.class);
        ExecutableVersion mockExecutableVersion = (ExecutableVersion)Mockito.mock(ExecutableVersion.class);
        Map<String, Executable> operations = Map.of("testOperation", mockExecutable);
        Map<Integer, ExecutableVersion> versions = Map.of(1, mockExecutableVersion);
        Mockito.when((Object)mockExecutables.getOperations()).thenReturn(operations);
        Mockito.when((Object)mockExecutable.getVersions()).thenReturn(versions);
        FlowConnection connection = new FlowConnection(mockModelInterpreter, (ConnectionDescription)Mockito.mock(ConnectionDescription.class), Map.of(), mockExecutables, "connection", false);
        Optional result = connection.getOperation("testOperation", Integer.valueOf(1));
        Assertions.assertTrue((boolean)result.isPresent());
        Assertions.assertInstanceOf(FlowOperation.class, result.get());
    }

    @Test
    @DisplayName(value="GIVEN a FlowConnector with available triggers\nWHEN getTrigger is called with name and version\nTHEN returns Optional containing FlowTrigger")
    void FlowConnectionCallingGetTrigger() {
        ModelInterpreter mockModelInterpreter = (ModelInterpreter)Mockito.mock(ModelInterpreter.class);
        Executables mockExecutables = (Executables)Mockito.mock(Executables.class);
        Executable mockExecutable = (Executable)Mockito.mock(Executable.class);
        ExecutableVersion mockExecutableVersion = (ExecutableVersion)Mockito.mock(ExecutableVersion.class);
        Map<String, Executable> triggers = Map.of("testTrigger", mockExecutable);
        Map<Integer, ExecutableVersion> versions = Map.of(1, mockExecutableVersion);
        Mockito.when((Object)mockExecutables.getTriggers()).thenReturn(triggers);
        Mockito.when((Object)mockExecutable.getVersions()).thenReturn(versions);
        FlowConnection connection = new FlowConnection(mockModelInterpreter, (ConnectionDescription)Mockito.mock(ConnectionDescription.class), Map.of(), mockExecutables, "connection", false);
        Optional result = connection.getTrigger("testTrigger", Integer.valueOf(1));
        Assertions.assertTrue((boolean)result.isPresent());
        Assertions.assertInstanceOf(FlowTrigger.class, result.get());
    }

    @Test
    @DisplayName(value="GIVEN a FlowConnector with available value providers\nWHEN getValueProvider is called with name\nTHEN returns Optional containing FlowValueProvider")
    void FlowConnectionCallingGetValueProvider() {
        ModelInterpreter mockModelInterpreter = (ModelInterpreter)Mockito.mock(ModelInterpreter.class);
        Executables mockExecutables = (Executables)Mockito.mock(Executables.class);
        Provider mockProvider = (Provider)Mockito.mock(Provider.class);
        Map<String, Provider> valueProviders = Map.of("testValueProvider", mockProvider);
        Mockito.when((Object)mockExecutables.getValueProviders()).thenReturn(valueProviders);
        FlowConnection connection = new FlowConnection(mockModelInterpreter, (ConnectionDescription)Mockito.mock(ConnectionDescription.class), Map.of(), mockExecutables, "connection", false);
        Optional result = connection.getValueProvider("testValueProvider");
        Assertions.assertTrue((boolean)result.isPresent());
        Assertions.assertInstanceOf(FlowValueProvider.class, result.get());
    }

    @Test
    @DisplayName(value="GIVEN a FlowConnector with available metadata providers\nWHEN getMetadataProvider is called with name\nTHEN returns Optional containing FlowMetadataProvider")
    void FlowConnectionCallingGetMetadataProvider() {
        ModelInterpreter mockModelInterpreter = (ModelInterpreter)Mockito.mock(ModelInterpreter.class);
        Executables mockExecutables = (Executables)Mockito.mock(Executables.class);
        Provider mockProvider = (Provider)Mockito.mock(Provider.class);
        Map<String, Provider> typeProviders = Map.of("testMetadataProvider", mockProvider);
        Mockito.when((Object)mockExecutables.getTypeProviders()).thenReturn(typeProviders);
        FlowConnection connection = new FlowConnection(mockModelInterpreter, (ConnectionDescription)Mockito.mock(ConnectionDescription.class), Map.of(), mockExecutables, "connection", false);
        Optional result = connection.getMetadataProvider("testMetadataProvider");
        Assertions.assertTrue((boolean)result.isPresent());
        Assertions.assertInstanceOf(FlowMetadataProvider.class, result.get());
    }

    private static BaseConnectionProviderModel createConnectionProviderModel() {
        return (BaseConnectionProviderModel)((BaseConnectionProviderModel.Builder)((BaseConnectionProviderModel.Builder)new BaseConnectionProviderModel.Builder().withModelReference("model::Reference")).authenticationType(AuthenticationTypeDeserializer.fromMap(Map.of("type", "bearer")))).build();
    }
}

