/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.connector;

import com.mulesoft.connectivity.flow.internal.connector.FlowConnection;
import com.mulesoft.connectivity.flow.internal.connector.FlowTrigger;
import com.mulesoft.connectivity.flow.internal.executables.ExecutableVersion;
import com.mulesoft.connectivity.linkweave.api.interpreter.Connection;
import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreter;
import com.mulesoft.connectivity.linkweave.api.model.BaseExecutableComponentModel;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationResult;
import com.mulesoft.connectivity.linkweave.api.model.trigger.NextData;
import com.mulesoft.connectivity.linkweave.api.model.trigger.NextPoll;
import java.io.Serializable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class FlowTriggerTest {
    @Test
    @DisplayName(value="GIVEN a FlowTrigger\nWHEN execute is called\nTHEN modelInterpreter.executeTrigger is called with ConnectionHolder, TriggerModel, watermark and parameters")
    void FlowTriggerCallingExecute() {
        ModelInterpreter mockModelInterpreter = (ModelInterpreter)Mockito.mock(ModelInterpreter.class);
        Connection mockConnectionHolder = (Connection)Mockito.mock(Connection.class);
        FlowConnection mockConnection = (FlowConnection)Mockito.mock(FlowConnection.class);
        OperationResult mockOperationResult = (OperationResult)Mockito.mock(OperationResult.class);
        ExecutableVersion executableVersion = this.createExecutableVersion();
        Mockito.when((Object)mockConnection.asHolder()).thenReturn((Object)mockConnectionHolder);
        Mockito.when((Object)mockModelInterpreter.executeTrigger((Connection)ArgumentMatchers.any(Connection.class), (BaseExecutableComponentModel)ArgumentMatchers.any(BaseExecutableComponentModel.class), ArgumentMatchers.any(), ArgumentMatchers.any())).thenReturn((Object)mockOperationResult);
        String watermark = "watermark";
        Mockito.when((Object)mockModelInterpreter.getInitialWatermark((Connection)ArgumentMatchers.any(), (BaseExecutableComponentModel)ArgumentMatchers.any(), ArgumentMatchers.any())).thenReturn((Object)watermark);
        FlowTrigger flowTrigger = new FlowTrigger(mockModelInterpreter, "testTrigger", executableVersion, mockConnection);
        Object parameters = new Object();
        OperationResult result = flowTrigger.execute(parameters, null, null);
        Assertions.assertEquals((Object)mockOperationResult, (Object)result);
        ((ModelInterpreter)Mockito.verify((Object)mockModelInterpreter)).executeTrigger((Connection)ArgumentMatchers.eq((Object)mockConnectionHolder), (BaseExecutableComponentModel)ArgumentMatchers.any(BaseExecutableComponentModel.class), ArgumentMatchers.eq((Object)watermark), ArgumentMatchers.eq((Object)parameters));
        ((FlowConnection)Mockito.verify((Object)mockConnection, (VerificationMode)Mockito.times((int)2))).asHolder();
    }

    @Test
    @DisplayName(value="GIVEN a FlowTrigger\nWHEN executeNextPage is called\nTHEN modelInterpreter.executeTriggerNextPage is called with ConnectionHolder, TriggerModel and NextData")
    void FlowTriggerCallingExecuteNextPage() {
        ModelInterpreter mockModelInterpreter = (ModelInterpreter)Mockito.mock(ModelInterpreter.class);
        Connection mockConnectionHolder = (Connection)Mockito.mock(Connection.class);
        FlowConnection mockConnection = (FlowConnection)Mockito.mock(FlowConnection.class);
        OperationResult mockOperationResult = (OperationResult)Mockito.mock(OperationResult.class);
        ExecutableVersion executableVersion = this.createExecutableVersion();
        Mockito.when((Object)mockConnection.asHolder()).thenReturn((Object)mockConnectionHolder);
        Mockito.when((Object)mockModelInterpreter.executeTriggerNextPage((Connection)ArgumentMatchers.any(Connection.class), (BaseExecutableComponentModel)ArgumentMatchers.any(BaseExecutableComponentModel.class), (NextData)ArgumentMatchers.any(NextData.class))).thenReturn((Object)mockOperationResult);
        FlowTrigger flowTrigger = new FlowTrigger(mockModelInterpreter, "testTrigger", executableVersion, mockConnection);
        NextData nextData = (NextData)Mockito.mock(NextData.class);
        OperationResult result = flowTrigger.execute((Object)nextData, new NextPoll((Serializable)((Object)"1"), (Serializable)((Object)"0")), (Serializable)((Object)"2"));
        Assertions.assertEquals((Object)mockOperationResult, (Object)result);
        ((ModelInterpreter)Mockito.verify((Object)mockModelInterpreter)).executeTriggerNextPage((Connection)ArgumentMatchers.eq((Object)mockConnectionHolder), (BaseExecutableComponentModel)ArgumentMatchers.any(BaseExecutableComponentModel.class), (NextData)ArgumentMatchers.any(NextData.class));
        ((FlowConnection)Mockito.verify((Object)mockConnection)).asHolder();
    }

    @Test
    @DisplayName(value="GIVEN a FlowTrigger\nWHEN getInitialWatermark is called\nTHEN modelInterpreter.getInitialWatermark is called with ConnectionHolder, TriggerModel and parameters")
    void FlowTriggerCallingGetInitialWatermark() {
        ModelInterpreter mockModelInterpreter = (ModelInterpreter)Mockito.mock(ModelInterpreter.class);
        Connection mockConnectionHolder = (Connection)Mockito.mock(Connection.class);
        FlowConnection mockConnection = (FlowConnection)Mockito.mock(FlowConnection.class);
        Serializable mockWatermark = (Serializable)Mockito.mock(Serializable.class);
        ExecutableVersion executableVersion = this.createExecutableVersion();
        Mockito.when((Object)mockConnection.asHolder()).thenReturn((Object)mockConnectionHolder);
        Mockito.when((Object)mockModelInterpreter.getInitialWatermark((Connection)ArgumentMatchers.any(Connection.class), (BaseExecutableComponentModel)ArgumentMatchers.any(BaseExecutableComponentModel.class), ArgumentMatchers.any())).thenReturn((Object)mockWatermark);
        FlowTrigger flowTrigger = new FlowTrigger(mockModelInterpreter, "testTrigger", executableVersion, mockConnection);
        Object parameters = new Object();
        Serializable result = flowTrigger.getInitialWatermark(parameters);
        Assertions.assertEquals((Object)mockWatermark, (Object)result);
        ((ModelInterpreter)Mockito.verify((Object)mockModelInterpreter)).getInitialWatermark((Connection)ArgumentMatchers.eq((Object)mockConnectionHolder), (BaseExecutableComponentModel)ArgumentMatchers.any(BaseExecutableComponentModel.class), ArgumentMatchers.eq((Object)parameters));
        ((FlowConnection)Mockito.verify((Object)mockConnection)).asHolder();
    }

    private ExecutableVersion createExecutableVersion() {
        ExecutableVersion executableVersion = (ExecutableVersion)Mockito.mock(ExecutableVersion.class);
        Mockito.when((Object)executableVersion.getModelReference()).thenReturn((Object)"testModel::Reference");
        Mockito.when((Object)executableVersion.isPaginated()).thenReturn((Object)true);
        return executableVersion;
    }
}

