/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.connection;

import com.mulesoft.connectivity.flow.internal.connection.ConnectionInputTypeInformation;
import com.mulesoft.connectivity.flow.internal.connection.ConnectionInputTypeInformationFactory;
import com.mulesoft.connectivity.flow.internal.connection.Connections;
import com.mulesoft.connectivity.linkweave.api.model.connection.BaseConnectionProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.ConnectionProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.HttpAuthenticationType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConnectionsFactory {
    private final ConnectionInputTypeInformationFactory connectionInputTypeInformationFactory;

    public static ConnectionsFactory create() {
        return new ConnectionsFactory(new ConnectionInputTypeInformationFactory());
    }

    ConnectionsFactory(ConnectionInputTypeInformationFactory connectionInputTypeInformationFactory) {
        this.connectionInputTypeInformationFactory = connectionInputTypeInformationFactory;
    }

    public Connections fromConnectorModel(List<ConnectionProviderModel> connectionProviders) {
        return new Connections(this.inputTypesInformation(connectionProviders), this.getAuthListFromConnectorModel(connectionProviders));
    }

    private List<ConnectionInputTypeInformation> inputTypesInformation(List<ConnectionProviderModel> connectionProviders) {
        return connectionProviders.stream().map(this.connectionInputTypeInformationFactory::createConnectionInputTypeInformation).toList();
    }

    private List<Map<String, Object>> getAuthListFromConnectorModel(List<ConnectionProviderModel> connectionProviders) {
        return connectionProviders.stream().map(BaseConnectionProviderModel::getAuthenticationType).filter(a -> a instanceof HttpAuthenticationType).map(HttpAuthenticationType.class::cast).map(httpAuth -> {
            HashMap<String, String> authConnectorInfo = new HashMap<String, String>();
            authConnectorInfo.put("type", httpAuth.getType().name());
            authConnectorInfo.put("subType", httpAuth.getSubType().orElse(null));
            return authConnectorInfo;
        }).toList();
    }
}

