/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.model;

import java.io.Serializable;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public class IconMetadata
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String alternateText;
    private String resource;

    public IconMetadata(Builder builder) {
        this.name = Objects.requireNonNull(builder.name);
        this.alternateText = Objects.requireNonNull(builder.alternateText);
        this.resource = Objects.requireNonNull(builder.resource);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setAlternateText(String alternateText) {
        this.alternateText = alternateText;
    }

    public String getAlternateText() {
        return this.alternateText;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String getResource() {
        return this.resource;
    }

    public String toString() {
        return "IconMetadata{name='" + this.name + "', alternateText='" + this.alternateText + "', resource='" + this.resource + "'}";
    }

    public static class Builder {
        private @Nullable String name;
        private @Nullable String alternateText;
        private @Nullable String resource;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withAlternateText(String alternateText) {
            this.alternateText = alternateText;
            return this;
        }

        public Builder withResource(String resource) {
            this.resource = resource;
            return this;
        }

        private void validate() throws IllegalStateException {
            StringBuilder messages = new StringBuilder();
            if (this.name == null || this.name.isBlank()) {
                messages.append("Name is required\n");
            }
            if (this.alternateText == null || this.alternateText.isBlank()) {
                messages.append("AlternateText is required\n");
            }
            if (this.resource == null || this.resource.isBlank()) {
                messages.append("Resource is required\n");
            }
            if (!messages.isEmpty()) {
                throw new IllegalStateException(messages.toString());
            }
        }

        public IconMetadata build() throws IllegalStateException {
            this.validate();
            return new IconMetadata(this);
        }
    }
}

