/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.server;

import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.handler.LoggerHandler;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class MockServer
implements Verticle {
    private final Vertx vertx = Vertx.vertx();
    private HttpServer server;

    public void startServer() {
        CountDownLatch latch = new CountDownLatch(1);
        this.vertx.deployVerticle((Verticle)this, res -> {
            latch.countDown();
            if (res.failed()) {
                throw new RuntimeException("MockServer couldn't be started.", res.cause());
            }
        });
        try {
            if (!latch.await(10L, TimeUnit.SECONDS)) {
                throw new RuntimeException("Timeout waiting for server to start");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void stopServer() {
        this.vertx.close();
        this.server = null;
    }

    public Vertx getVertx() {
        return this.vertx;
    }

    public void init(Vertx vertx, Context context) {
    }

    public void start(Promise<Void> startPromise) {
        Router router = Router.router((Vertx)this.vertx);
        router.route().handler((Handler)LoggerHandler.create()).handler((Handler)BodyHandler.create());
        router.get("/2010-04-01/Accounts.json").handler(context -> context.response().setStatusCode(200).putHeader("Content-Type", "application/json").end("{}"));
        this.server = this.vertx.createHttpServer().requestHandler((Handler)router).listen(0, result -> startPromise.handle(result.mapEmpty()));
    }

    public void stop(Promise<Void> stopPromise) {
        this.server.close().onComplete(stopPromise);
        this.server = null;
    }

    public int getPort() {
        if (this.server == null) {
            throw new IllegalStateException("HTTP server hasn't been started");
        }
        return this.server.actualPort();
    }
}

