/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.connection;

import com.mulesoft.connectivity.flow.internal.connection.AuthenticationTypeExtractor;
import com.mulesoft.connectivity.linkweave.api.model.connection.ApiKeyHttpAuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.AuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.HttpAuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.oauth.OAuth2AuthenticationType;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public class AuthenticationTypeExtractorTest {
    @Test
    @DisplayName(value="GIVEN an HttpAuthenticationType with basic type and custom subtype\nWHEN getFrom is called\nTHEN returns extractor with correct type and subtype extracted\n")
    public void httpAuthenticationTypeWithSubtypeExtractsCorrectly() {
        HttpAuthenticationType authenticationType = new HttpAuthenticationType(HttpAuthenticationType.Type.basic, "subtype");
        AuthenticationTypeExtractor extractor = AuthenticationTypeExtractor.getFrom((AuthenticationType)authenticationType);
        Assertions.assertNotNull((Object)extractor);
        Assertions.assertEquals((Object)HttpAuthenticationType.Type.basic, (Object)extractor.getType());
        Assertions.assertEquals((Object)"subtype", (Object)extractor.getSubType());
    }

    @Test
    @DisplayName(value="GIVEN an HttpAuthenticationType with bearer type and no subtype\nWHEN getFrom is called\nTHEN returns extractor with correct type and null subtype\n")
    public void httpAuthenticationTypeWithoutSubtypeExtractsCorrectly() {
        HttpAuthenticationType authenticationType = new HttpAuthenticationType(HttpAuthenticationType.Type.bearer, null);
        AuthenticationTypeExtractor extractor = AuthenticationTypeExtractor.getFrom((AuthenticationType)authenticationType);
        Assertions.assertNotNull((Object)extractor);
        Assertions.assertEquals((Object)HttpAuthenticationType.Type.bearer, (Object)extractor.getType());
        Assertions.assertNull((Object)extractor.getSubType());
    }

    @Test
    @DisplayName(value="GIVEN an ApiKeyHttpAuthenticationType with custom type and subtype\nWHEN getFrom is called\nTHEN returns extractor with correct type and subtype extracted\n")
    public void apiKeyHttpAuthenticationTypeExtractsCorrectly() {
        ApiKeyHttpAuthenticationType authenticationType = new ApiKeyHttpAuthenticationType("apikey", ApiKeyHttpAuthenticationType.In.cookie, "apiKeyName");
        AuthenticationTypeExtractor extractor = AuthenticationTypeExtractor.getFrom((AuthenticationType)authenticationType);
        Assertions.assertNotNull((Object)extractor);
        Assertions.assertEquals((Object)HttpAuthenticationType.Type.apiKey, (Object)extractor.getType());
        Assertions.assertEquals((Object)"apikey", (Object)extractor.getSubType());
    }

    @Test
    @DisplayName(value="GIVEN an OAuth2AuthenticationType with bearer type and oauth subtype\nWHEN getFrom is called\nTHEN returns extractor with correct type and subtype extracted\n")
    public void oAuth2AuthenticationTypeExtractsCorrectly() {
        OAuth2AuthenticationType authenticationType = new OAuth2AuthenticationType(OAuth2AuthenticationType.GrantType.implicit, "", List.of());
        AuthenticationTypeExtractor extractor = AuthenticationTypeExtractor.getFrom((AuthenticationType)authenticationType);
        Assertions.assertNotNull((Object)extractor);
        Assertions.assertEquals((Object)HttpAuthenticationType.Type.oauth2, (Object)extractor.getType());
        Assertions.assertEquals((Object)OAuth2AuthenticationType.GrantType.implicit.name(), (Object)extractor.getSubType());
    }
}

