%dw 2.7
import * from com::mulesoft::connectivity::Model
import * from com::mulesoft::connectivity::Metadata
import * from com::mulesoft::connectivity::flow::Metadata
import * from com::mulesoft::connectivity::decorator::Operation
import * from com::mulesoft::connectivity::transport::Http
import * from com::mulesoft::connectivity::Types
import Label from com::mulesoft::connectivity::decorator::Annotations

type FindPetByIdCuratedInput = {
  id: Number
}

type Types = {
  Pet: Types.NewPet & { id: Number, createdAt?: LWDate },
  Error: {
    code: Number,
    message: String
  },
  NewPet: {
      name: @Label(value = "Name of the Pet") String
    },
}

type OperationTypes = {
 "/pets/{id}": {
    get: {
      response200: Types.Pet,
      responsedefault: Types.Error,
      request: HttpRequestType<{|
        uri: {|
          id: Number
        |},
        query: Object,
        headers: Object,
        cookie: Object
      |}>,
      response: Types.Pet | Types.Error,
      errorResponse: ResultFailure<OperationTypes."/pets/{id}".get.response, Error<"status-default", String>>
    }
  }
}

var operations = {
  "/pets/{id}": {
    get: {
      name: "findPetById",
      displayName: "find pet by id",
      executor: (parameter: OperationTypes."/pets/{id}".get.request, connection: HttpConnection): Result<HttpResponse<OperationTypes."/pets/{id}".get.response200>, ResultFailure<HttpResponse<OperationTypes."/pets/{id}".get.responsedefault>, Error>> -> do {
          var uri = parameter.uri
          var query = parameter.query default {}
          var headers = parameter.headers default {}
          var cookie = parameter.cookie default {}
          var response = connection({
            method: "GET",
            path: "/pets/$(uri.id)",
            queryParams: query,
            headers: headers,
            cookie: cookie,
            (body: parameter.body) if (parameter.body?)
          })
          ---
          response.status match {
            case 200 -> success(response as HttpResponse<OperationTypes."/pets/{id}".get.response200>)
            else -> failure(response as HttpResponse<OperationTypes."/pets/{id}".get.responsedefault>)
          }
        }
    }
  }
 }

// Operations
var findPetByIdCurated = mapInputAndOutputOperation(operations."/pets/{id}".get, (param: FindPetByIdCuratedInput) -> {uri: {id: param.id}, query: {}, headers: {}, cookie: {}}, (result) -> result.body!, (result) -> failure({body: result.error.value.body, status: result.error.value.status}))

var mockConnectionProvider : HttpConnectionProvider<Object, { "type": "custom" }> = {
    authenticationType: {"type": "custom"},
    connect: (parameter) -> (httpRequest: HttpRequester) -> do {
      var path = httpRequest.path
      var response = {contentType: "application/json", status: 200, headers: {}, cookies: {}}
      var pet1 = {id: 1, name: "Name1", category: 1, tag: "Tag1", createdAt: "2024-01-01"}
      var pet2 = {id: 2, name: "Name2", category: 2, tag: "Tag2", createdAt: "2024-01-01", ranking: 5}
      var categories = if(isEmpty(parameter.categories)) [ {id: 1, label: "Cat1"}, {id: 2, label: "Cat2"}] else parameter.categories
      var tags = [ {id: "1", label: "Tag1"}, {id: "2", label: "Tag2"}]
      var accountFields = [{name: "id", "type" : "Number"}, {name : "description", "type": "String"}]
      var accounts = [{id: 1, description: "order 1"}, {id: 2, description: "order 2"}]
      var user1 = {id: 1, info: {name: "john", pets: [pet1, pet2], userTypes: ["type1", "type2"]}}

      var ticketFields = [{name: "priority", "type" : "Number"}, {name : "description", "type": "String"}]
      var tickets = [{id: 1, title: "Ticket1", extraFields: {priority: 1, description: "Desc1"}}, {id: 2, title: "Ticket2", extraFields: {priority: 2, description: "Desc2"}}]

      var productTags = [ {id: "1", label: "Tag1"}, {id: "2", label: "Tag2"}]
      var productSubTypes = [ {id: "1", label: "SubType1"}, {id: "2", label: "SubType2"}]
      var productCategories = [ {id: "1", label: "Cat1"}, {id: "2", label: "Cat2"}]
      var product = {name: "ProductName", productType: "type1", productTag: "tag1", extraInfo: {productSubType: "subType1", productCategory: "cat1", productFamily: "family1"}}
      ---
      path match {
        case "/pets/1" -> response ++ {body: pet1}
        else -> response
      }
    }
}

var connections = {
  mockAuth: mockConnectionProvider,
}

@TestConnectionElement
var testConnection: HttpTestConnection = {
  validate: (connection) -> {
    isValid: connection({
      method: "GET",
      path: "/pets/offset",
      queryParams: {},
      headers: {},
      cookie: {}
    }).status == 200
  }
}

@FlowConnectorElement()
var connector = {
      name: "ITBasic Connector",
      displayName: "ITBasic Connector",
      since: "R256",
      description: "Integration Tests Basic Connector",
      vendor: "Salesforce",
      icons: [
      {
                name: "IT Basic Conector",
                alternateText: "IT Basic Connector",
                resource: "icon/icon.svg"
             }
      ],
      connections: {apiKeyAuth: connections.mockAuth},
      testConnection: testConnection,
      operations: {
        findPetById: findPetByIdCurated
      },
      valueProviders: {
      },
      metadataProviders: {
      },
      triggers: {
      }
}
