/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.persistence.gson;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mulesoft.connectivity.flow.api.model.FlowConnectorModel;
import com.mulesoft.connectivity.linkweave.api.persistence.gson.WeaveTypeCatalogCollector;
import java.lang.reflect.Type;
import java.util.NoSuchElementException;
import org.mule.weave.v2.api.tooling.impl.ts.catalog.DefaultDWTypeCatalog;

public class FlowConnectorModelTypeAdapter
implements JsonSerializer<FlowConnectorModel> {
    private final WeaveTypeCatalogCollector catalogCollector;

    public FlowConnectorModelTypeAdapter(WeaveTypeCatalogCollector catalogCollector) {
        this.catalogCollector = catalogCollector;
    }

    public JsonElement serialize(FlowConnectorModel src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject result = new JsonObject();
        result.addProperty("name", src.getName());
        result.addProperty("displayName", src.getDisplayName());
        result.addProperty("since", src.getSince());
        result.addProperty("version", src.getVersion());
        result.addProperty("releaseStatus", src.getReleaseStatus().toString());
        result.addProperty("description", src.getDescription());
        result.addProperty("vendor", src.getVendor());
        String modelReference = (String)src.getModelReference().orElseThrow(() -> new NoSuchElementException("Connector model does not have a DataWeave model reference!"));
        result.addProperty("modelReference", modelReference);
        result.add("icons", context.serialize(src.getIcons()));
        result.add("connections", context.serialize(src.getConnections()));
        result.add("operations", context.serialize(src.getOperations()));
        result.add("triggers", context.serialize(src.getTriggers()));
        result.add("testConnection", context.serialize((Object)src.getTestConnection()));
        result.add("valueProviders", context.serialize(src.getValueProviders()));
        result.add("metadataProviders", context.serialize(src.getMetadataProviders()));
        result.add("catalog", this.serializeCatalog());
        return result;
    }

    private JsonElement serializeCatalog() {
        return new JsonPrimitive(DefaultDWTypeCatalog.loader().withErrorHandler(errorMessages -> {
            throw new RuntimeException(String.join((CharSequence)"\n", errorMessages));
        }).withTypes(this.catalogCollector.getCatalog()).build().write());
    }
}

