/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.executables;

import com.mulesoft.connectivity.flow.internal.connection.AuthenticationTypeDeserializer;
import com.mulesoft.connectivity.flow.internal.connection.AuthenticationTypeExtractor;
import com.mulesoft.connectivity.linkweave.api.model.connection.AuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.BaseConnectionProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.TestConnectionModel;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public final class ConnectionDescription {
    private final Map<String, Object> authenticationType;
    private final String testConnectionModelReference;
    private final String connectionModelReference;
    private final boolean hasExtensions;

    public ConnectionDescription(Map<String, Object> authenticationType, String testConnectionModelReference, String connectionModelReference, boolean hasExtensions) {
        this.authenticationType = authenticationType;
        this.testConnectionModelReference = testConnectionModelReference;
        this.connectionModelReference = connectionModelReference;
        this.hasExtensions = hasExtensions;
    }

    public BaseConnectionProviderModel toConnectionProviderModel() {
        return (BaseConnectionProviderModel)((BaseConnectionProviderModel.Builder)((BaseConnectionProviderModel.Builder)((BaseConnectionProviderModel.Builder)((BaseConnectionProviderModel.Builder)new BaseConnectionProviderModel.Builder().authenticationType(AuthenticationTypeDeserializer.fromMap(this.authenticationType))).withModelReference(this.connectionModelReference)).testConnection((TestConnectionModel)((TestConnectionModel.Builder)new TestConnectionModel.Builder().withModelReference(this.testConnectionModelReference)).build())).hasExtensions(this.hasExtensions)).build();
    }

    public Map<String, Object> getBaseConnectionInfo() {
        AuthenticationType authType = AuthenticationTypeDeserializer.fromMap(this.authenticationType);
        AuthenticationTypeExtractor extractor = AuthenticationTypeExtractor.getFrom(authType);
        HashMap<String, Object> connectionInfo = new HashMap<String, Object>();
        switch (extractor.getType()) {
            case basic: {
                connectionInfo.put("username", "");
                connectionInfo.put("password", "");
                break;
            }
            case bearer: {
                connectionInfo.put("token", "");
                break;
            }
            case apiKey: {
                connectionInfo.put("apiKey", "");
                break;
            }
            case oauth2: {
                connectionInfo.put("accessToken", "");
                connectionInfo.put("subType", extractor.getSubType());
                break;
            }
        }
        return connectionInfo;
    }

    @Generated
    public static ConnectionDescriptionBuilder builder() {
        return new ConnectionDescriptionBuilder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConnectionDescription)) {
            return false;
        }
        ConnectionDescription other = (ConnectionDescription)o;
        if (this.isHasExtensions() != other.isHasExtensions()) {
            return false;
        }
        Map<String, Object> this$authenticationType = this.getAuthenticationType();
        Map<String, Object> other$authenticationType = other.getAuthenticationType();
        if (this$authenticationType == null ? other$authenticationType != null : !((Object)this$authenticationType).equals(other$authenticationType)) {
            return false;
        }
        String this$testConnectionModelReference = this.getTestConnectionModelReference();
        String other$testConnectionModelReference = other.getTestConnectionModelReference();
        if (this$testConnectionModelReference == null ? other$testConnectionModelReference != null : !this$testConnectionModelReference.equals(other$testConnectionModelReference)) {
            return false;
        }
        String this$connectionModelReference = this.getConnectionModelReference();
        String other$connectionModelReference = other.getConnectionModelReference();
        return !(this$connectionModelReference == null ? other$connectionModelReference != null : !this$connectionModelReference.equals(other$connectionModelReference));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isHasExtensions() ? 79 : 97);
        Map<String, Object> $authenticationType = this.getAuthenticationType();
        result = result * 59 + ($authenticationType == null ? 43 : ((Object)$authenticationType).hashCode());
        String $testConnectionModelReference = this.getTestConnectionModelReference();
        result = result * 59 + ($testConnectionModelReference == null ? 43 : $testConnectionModelReference.hashCode());
        String $connectionModelReference = this.getConnectionModelReference();
        result = result * 59 + ($connectionModelReference == null ? 43 : $connectionModelReference.hashCode());
        return result;
    }

    @Generated
    public Map<String, Object> getAuthenticationType() {
        return this.authenticationType;
    }

    @Generated
    public String getTestConnectionModelReference() {
        return this.testConnectionModelReference;
    }

    @Generated
    public String getConnectionModelReference() {
        return this.connectionModelReference;
    }

    @Generated
    public boolean isHasExtensions() {
        return this.hasExtensions;
    }

    @Generated
    public String toString() {
        return "ConnectionDescription(authenticationType=" + String.valueOf(this.getAuthenticationType()) + ", testConnectionModelReference=" + this.getTestConnectionModelReference() + ", connectionModelReference=" + this.getConnectionModelReference() + ", hasExtensions=" + this.isHasExtensions() + ")";
    }

    @Generated
    public static class ConnectionDescriptionBuilder {
        @Generated
        private Map<String, Object> authenticationType;
        @Generated
        private String testConnectionModelReference;
        @Generated
        private String connectionModelReference;
        @Generated
        private boolean hasExtensions;

        @Generated
        ConnectionDescriptionBuilder() {
        }

        @Generated
        public ConnectionDescriptionBuilder authenticationType(Map<String, Object> authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Generated
        public ConnectionDescriptionBuilder testConnectionModelReference(String testConnectionModelReference) {
            this.testConnectionModelReference = testConnectionModelReference;
            return this;
        }

        @Generated
        public ConnectionDescriptionBuilder connectionModelReference(String connectionModelReference) {
            this.connectionModelReference = connectionModelReference;
            return this;
        }

        @Generated
        public ConnectionDescriptionBuilder hasExtensions(boolean hasExtensions) {
            this.hasExtensions = hasExtensions;
            return this;
        }

        @Generated
        public ConnectionDescription build() {
            return new ConnectionDescription(this.authenticationType, this.testConnectionModelReference, this.connectionModelReference, this.hasExtensions);
        }

        @Generated
        public String toString() {
            return "ConnectionDescription.ConnectionDescriptionBuilder(authenticationType=" + String.valueOf(this.authenticationType) + ", testConnectionModelReference=" + this.testConnectionModelReference + ", connectionModelReference=" + this.connectionModelReference + ", hasExtensions=" + this.hasExtensions + ")";
        }
    }
}

