/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.interpreter;

import com.mulesoft.connectivity.flow.api.interpreter.AbstractFlowModelInterpreterTest;
import com.mulesoft.connectivity.flow.api.loader.FlowConnectorLoader;
import com.mulesoft.connectivity.flow.api.loader.FlowModelLoaderFactory;
import com.mulesoft.connectivity.flow.api.model.FlowConnectionProviderModel;
import com.mulesoft.connectivity.flow.api.model.FlowConnectorModel;
import com.mulesoft.connectivity.flow.api.model.ReleaseStatus;
import com.mulesoft.connectivity.flow.api.model.query.AndQueryFilter;
import com.mulesoft.connectivity.flow.api.model.query.BinaryQueryCondition;
import com.mulesoft.connectivity.flow.api.model.query.CustomQueryFieldSelection;
import com.mulesoft.connectivity.flow.api.model.query.NAryQueryCondition;
import com.mulesoft.connectivity.flow.api.model.query.QueryFieldNoOrder;
import com.mulesoft.connectivity.flow.api.model.query.QueryFieldOrderPair;
import com.mulesoft.connectivity.flow.api.model.query.QueryManyFieldsManySortingOrder;
import com.mulesoft.connectivity.flow.api.model.query.QueryManyFieldsSingleSortingOrder;
import com.mulesoft.connectivity.flow.api.model.query.QueryOrder;
import com.mulesoft.connectivity.flow.api.model.query.QuerySingleFieldOrder;
import com.mulesoft.connectivity.linkweave.api.loader.LanguageModelLoader;
import com.mulesoft.connectivity.linkweave.api.loader.ModelLoader;
import com.mulesoft.connectivity.linkweave.api.model.BaseExecutableComponentModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.BaseConnectionProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationModel;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationResult;
import java.lang.invoke.CallSite;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class GeneratedFlowConnectorModelInterpreterTest
extends AbstractFlowModelInterpreterTest {
    @Override
    protected FlowConnectorModel generateConnectorModel() {
        LanguageModelLoader modelLoader = new LanguageModelLoader(this.dataWeaveEngine, (ModelLoader)new FlowModelLoaderFactory().create(), NameIdentifier.fromFQN((String)"com::mulesoft::connectivity::flow::Metadata::FlowConnectorElement"));
        return (FlowConnectorModel)modelLoader.loadModule("twilio::Connector", (Object)new FlowConnectorLoader.ExtraData("1.0.0", ReleaseStatus.GA));
    }

    @Test
    public void testExecuteQueryBuilderOperation() {
        LanguageModelLoader modelLoader = new LanguageModelLoader(this.dataWeaveEngine, (ModelLoader)new FlowModelLoaderFactory().create(), NameIdentifier.fromFQN((String)"com::mulesoft::connectivity::flow::Metadata::FlowConnectorElement"));
        FlowConnectorModel flowConnectorModel = (FlowConnectorModel)modelLoader.loadModule("querybuilder::Connector", (Object)new FlowConnectorLoader.ExtraData("0.0.1", ReleaseStatus.PILOT));
        FlowConnectionProviderModel connectionProvider = (FlowConnectionProviderModel)flowConnectorModel.getConnections().get(0);
        OperationModel operation = (OperationModel)flowConnectorModel.getOperation("queryBuilder");
        AndQueryFilter filter = new AndQueryFilter(List.of(new BinaryQueryCondition("name", "isNull", (Object)true), new BinaryQueryCondition("description", "equals", (Object)"desc1"), new NAryQueryCondition("age", "between", new Object[]{18, 60})));
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("objectType", "Accounts");
        parameters.put("projectedFields", this.unpojoObject(new CustomQueryFieldSelection(List.of("name", "description"))));
        parameters.put("filter", this.unpojoObject(filter));
        parameters.put("limit", 2);
        parameters.put("offset", 0);
        HashMap<String, Object> singleOrderParams = parameters;
        singleOrderParams.put("orderBy", this.unpojoObject(new QuerySingleFieldOrder(new QueryFieldOrderPair("id", QueryOrder.DESC))));
        OperationResult operationResult = this.modelInterpreter.executeOperation((BaseConnectionProviderModel)connectionProvider, GeneratedFlowConnectorModelInterpreterTest.getConnectionInfo(), (BaseExecutableComponentModel)operation, singleOrderParams);
        MatcherAssert.assertThat((Object)operationResult, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)operationResult.getValue().toString(), (Matcher)CoreMatchers.equalTo((Object)"{records=[{name=query, description=SELECT name, description FROM Accounts WHERE name = null AND description = 'desc1' AND age between 18 and 60 ORDER BY id DESC LIMIT 2 OFFSET 0}]}"));
        HashMap<String, Object> noOrderParams = parameters;
        noOrderParams.put("orderBy", this.unpojoObject(new QueryFieldNoOrder()));
        OperationResult operationResultNoOrder = this.modelInterpreter.executeOperation((BaseConnectionProviderModel)connectionProvider, GeneratedFlowConnectorModelInterpreterTest.getConnectionInfo(), (BaseExecutableComponentModel)operation, noOrderParams);
        MatcherAssert.assertThat((Object)operationResultNoOrder, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)operationResultNoOrder.getValue().toString(), (Matcher)CoreMatchers.equalTo((Object)"{records=[{name=query, description=SELECT name, description FROM Accounts WHERE name = null AND description = 'desc1' AND age between 18 and 60 LIMIT 2 OFFSET 0}]}"));
        HashMap<String, Object> manyFieldsManyOrderParams = parameters;
        ArrayList<QueryFieldOrderPair> fields = new ArrayList<QueryFieldOrderPair>();
        fields.add(new QueryFieldOrderPair("id", QueryOrder.DESC));
        fields.add(new QueryFieldOrderPair("name", QueryOrder.ASC));
        manyFieldsManyOrderParams.put("orderBy", this.unpojoObject(new QueryManyFieldsManySortingOrder(fields)));
        OperationResult operationResultManyFieldsManyOrder = this.modelInterpreter.executeOperation((BaseConnectionProviderModel)connectionProvider, GeneratedFlowConnectorModelInterpreterTest.getConnectionInfo(), (BaseExecutableComponentModel)operation, manyFieldsManyOrderParams);
        MatcherAssert.assertThat((Object)operationResultManyFieldsManyOrder, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)operationResultManyFieldsManyOrder.getValue().toString(), (Matcher)CoreMatchers.equalTo((Object)"{records=[{name=query, description=SELECT name, description FROM Accounts WHERE name = null AND description = 'desc1' AND age between 18 and 60 ORDER BY id DESC, name ASC LIMIT 2 OFFSET 0}]}"));
        HashMap<String, Object> manyFieldsSingleOrderParams = parameters;
        manyFieldsSingleOrderParams.put("orderBy", this.unpojoObject(new QueryManyFieldsSingleSortingOrder(new ArrayList<String>(List.of("id", "name")), QueryOrder.ASC)));
        OperationResult operationResultManyFieldsSingleOrder = this.modelInterpreter.executeOperation((BaseConnectionProviderModel)connectionProvider, GeneratedFlowConnectorModelInterpreterTest.getConnectionInfo(), (BaseExecutableComponentModel)operation, manyFieldsSingleOrderParams);
        MatcherAssert.assertThat((Object)operationResultManyFieldsSingleOrder, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)operationResultManyFieldsSingleOrder.getValue().toString(), (Matcher)CoreMatchers.equalTo((Object)"{records=[{name=query, description=SELECT name, description FROM Accounts WHERE name = null AND description = 'desc1' AND age between 18 and 60 ORDER BY id, name ASC LIMIT 2 OFFSET 0}]}"));
    }

    private Map<?, ?> unpojoObject(Object object) {
        HashMap<CallSite, Object> map = new HashMap<CallSite, Object>();
        for (Method method : object.getClass().getMethods()) {
            Object value;
            String name;
            if (method.getDeclaringClass() == Object.class) continue;
            String methodName = method.getName();
            if (methodName.startsWith("get")) {
                name = Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
                try {
                    value = method.invoke(object, new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException("calling: " + String.valueOf(method), e);
                }
            } else {
                if (!methodName.startsWith("is")) continue;
                throw new UnsupportedOperationException();
            }
            map.put((CallSite)((Object)name), this.unpojo(value));
        }
        return map;
    }

    private @Nullable Object unpojo(@Nullable Object value) {
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            return collection.stream().map(this::unpojo).toList();
        }
        if (value instanceof Enum) {
            return value.toString();
        }
        if (!(value == null || value instanceof String || value instanceof Number || value instanceof Boolean)) {
            return this.unpojoObject(value);
        }
        return value;
    }
}

