/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.connector;

import com.mulesoft.connectivity.flow.internal.connector.FlowConnection;
import com.mulesoft.connectivity.flow.internal.connector.FlowValueProvider;
import com.mulesoft.connectivity.flow.internal.executables.Provider;
import com.mulesoft.connectivity.linkweave.api.interpreter.Connection;
import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreter;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationResult;
import com.mulesoft.connectivity.linkweave.api.model.provider.ValueProviderModel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class FlowValueProviderTest {
    @Test
    @DisplayName(value="GIVEN a FlowValueProvider\nWHEN execute is called\nTHEN modelInterpreter.executeValueProvider is called with ConnectionHolder, ValueProviderModel and parameters")
    void FlowValueProviderCallingExecute() {
        ModelInterpreter mockModelInterpreter = (ModelInterpreter)Mockito.mock(ModelInterpreter.class);
        Connection mockConnectionHolder = (Connection)Mockito.mock(Connection.class);
        FlowConnection mockConnection = (FlowConnection)Mockito.mock(FlowConnection.class);
        OperationResult mockOperationResult = (OperationResult)Mockito.mock(OperationResult.class);
        Provider provider = this.createProvider();
        Mockito.when((Object)mockConnection.asHolder()).thenReturn((Object)mockConnectionHolder);
        Mockito.when((Object)mockModelInterpreter.executeValueProvider((Connection)ArgumentMatchers.any(Connection.class), (ValueProviderModel)ArgumentMatchers.any(ValueProviderModel.class), ArgumentMatchers.any())).thenReturn((Object)mockOperationResult);
        FlowValueProvider flowValueProvider = new FlowValueProvider(mockModelInterpreter, provider, mockConnection);
        Object parameters = new Object();
        OperationResult result = flowValueProvider.execute(parameters, false);
        Assertions.assertEquals((Object)mockOperationResult, (Object)result);
        ((ModelInterpreter)Mockito.verify((Object)mockModelInterpreter)).executeValueProvider((Connection)ArgumentMatchers.eq((Object)mockConnectionHolder), (ValueProviderModel)ArgumentMatchers.any(ValueProviderModel.class), ArgumentMatchers.eq((Object)parameters));
        ((FlowConnection)Mockito.verify((Object)mockConnection)).asHolder();
    }

    @Test
    @DisplayName(value="GIVEN a FlowValueProvider\nWHEN executeNextPage is called\nTHEN modelInterpreter.executeValueProviderNextPage is called with ConnectionHolder, ValueProviderModel and nextPageData")
    void FlowValueProviderCallingExecuteNextPage() {
        ModelInterpreter mockModelInterpreter = (ModelInterpreter)Mockito.mock(ModelInterpreter.class);
        Connection mockConnectionHolder = (Connection)Mockito.mock(Connection.class);
        FlowConnection mockConnection = (FlowConnection)Mockito.mock(FlowConnection.class);
        OperationResult mockOperationResult = (OperationResult)Mockito.mock(OperationResult.class);
        Provider provider = this.createProvider();
        Mockito.when((Object)mockConnection.asHolder()).thenReturn((Object)mockConnectionHolder);
        Mockito.when((Object)mockModelInterpreter.executeValueProviderNextPage((Connection)ArgumentMatchers.any(Connection.class), (ValueProviderModel)ArgumentMatchers.any(ValueProviderModel.class), ArgumentMatchers.any())).thenReturn((Object)mockOperationResult);
        FlowValueProvider flowValueProvider = new FlowValueProvider(mockModelInterpreter, provider, mockConnection);
        Object nextPageData = new Object();
        OperationResult result = flowValueProvider.execute(nextPageData, true);
        Assertions.assertEquals((Object)mockOperationResult, (Object)result);
        ((ModelInterpreter)Mockito.verify((Object)mockModelInterpreter)).executeValueProviderNextPage((Connection)ArgumentMatchers.eq((Object)mockConnectionHolder), (ValueProviderModel)ArgumentMatchers.any(ValueProviderModel.class), ArgumentMatchers.eq((Object)nextPageData));
        ((FlowConnection)Mockito.verify((Object)mockConnection)).asHolder();
    }

    private Provider createProvider() {
        return Provider.builder().name("testProvider").modelReference("testModel::Reference").build();
    }
}

