%dw 2.7
import * from com::mulesoft::connectivity::transport::Http
import * from com::mulesoft::connectivity::transport::Serialization
import * from com::mulesoft::connectivity::Model
import * from com::mulesoft::connectivity::Metadata
import * from com::mulesoft::connectivity::flow::Metadata

type Types = {
  A: {
    ab: Types.B,
    ac: Types.C
  },
  B: {
    bd: Types.D,
    be: Types.E
  },
  C: {
    cd: Types.D,
    ce: Types.E
  },
  D: {
    db: Types.B,
    dc: Types.C
  },
  E: {
    ea: Types.A,
    ee: Types.E
  },
}

type OperationTypes = {
  "/echo": {
    get: {
      request: HttpRequestType<{|
        query: Object,
        headers: Object,
        cookie: Object,
        body: Types.A
      |}>,
      response: Types.A,
    },
  }
}

var operations = {
  "/echo": {
    get: {
      name: "echo",
      displayName: "echo",
      executor: (parameter: OperationTypes."/echo".get.request, connection: HttpConnection): Result<HttpResponse<OperationTypes."/echo".get.response>, ResultFailure<HttpResponse<Any>, Error>> -> do {
        var query = parameter.query default {} withSerializationConfig {}
        var headers = serializeHeaders(parameter.headers default {}, {})
        var cookie = serializeCookies(parameter.cookie default {}, {})
        ---
        success(connection({
          method: "GET",
          path: "/echo",
          queryParams: query,
          headers: headers,
          cookie: cookie,
          (body: parameter.body) if (parameter.body?)
        })) as ResultSuccess<HttpResponse<OperationTypes."/echo".get.response>>
      }
    }
  }
}

@TestConnectionElement
var testConnection: HttpTestConnection = {
  validate: (connection) -> {
    isValid: connection({
      method: "GET",
      path: "/echo",
      queryParams: {},
      headers: {},
      cookie: {}
    }).status == 200
  }
}

var connections = {
  noAuth: {
    connect: defineHttpConnection<HttpConnectionProviderSchema, HttpConnectionProviderSchema>((v) -> v, (v) -> v, (auth, req) -> req),
    authenticationType: {
      "type": "custom",
      subType: "no-auth"
    }
  }
}

@FlowConnectorElement
var connector = {
  name: "dedup-test",
  displayName: "Type deduplication test",
  description: "A simple API that tests type deduplication and recursive types",
  icons: [
    {
      name: "Ouroboros",
      alternateText: "Ouroboros",
      resource: "icon/ouroboros.svg",
      size: 1,
      dimensions: "0x0"
    }
  ],
  vendor: "auto-generated",
  connections: connections,
  testConnection: testConnection,
  operations: {
    echo: operations."/echo".get,
  },
  valueProviders: {},
  metadataProviders: {}
}
