/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.interpreter;

import com.mulesoft.connectivity.flow.api.interpreter.FlowPlatformManagedConnection;
import com.mulesoft.connectivity.flow.api.model.FlowConnectionProviderModel;
import com.mulesoft.connectivity.flow.api.model.FlowConnectorModel;
import com.mulesoft.connectivity.flow.api.server.MockServer;
import com.mulesoft.connectivity.linkweave.api.interpreter.Connection;
import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreter;
import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreterConfig;
import com.mulesoft.connectivity.linkweave.api.loader.TypeUtils;
import com.mulesoft.connectivity.linkweave.api.loader.WeaveTypeSimplifier;
import com.mulesoft.connectivity.linkweave.api.metadata.MetadataUtils;
import com.mulesoft.connectivity.linkweave.api.model.BaseExecutableComponentModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.BaseConnectionProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.ConnectionProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.ConnectionValidationResult;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationModel;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationResult;
import com.mulesoft.connectivity.linkweave.api.model.provider.ProviderReference;
import com.mulesoft.connectivity.linkweave.api.model.provider.ValueProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.trigger.TriggerPage;
import com.mulesoft.connectivity.linkweave.api.util.DWTypeUtils;
import com.mulesoft.connectivity.linkweave.test.TestUtils;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.mule.weave.v2.module.http.service.HttpClient;
import org.mule.weave.v2.module.http.service.HttpClientConfiguration;
import org.mule.weave.v2.module.http.service.HttpClientService;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;

public abstract class AbstractFlowModelInterpreterTest {
    protected static final String NOT_IMPLEMENTED_ERROR = "Capability not implemented";
    protected static int serverPort;
    protected static final MockServer server;
    protected final DataWeaveScriptingEngine dataWeaveEngine = new DataWeaveScriptingEngine();
    protected final ModelInterpreterConfig config = new ModelInterpreterConfig.Builder().build();
    protected final ModelInterpreter modelInterpreter = new ModelInterpreter(this.dataWeaveEngine, this.config);
    protected final FlowConnectorModel connectorModel = this.generateConnectorModel();

    protected abstract FlowConnectorModel generateConnectorModel();

    @BeforeAll
    public static void beforeAll() {
        server.startServer();
        serverPort = server.getPort();
    }

    @AfterAll
    public static void afterAll() {
        server.stopServer();
    }

    @Test
    void connection() {
        FlowConnectionProviderModel connectionModel = (FlowConnectionProviderModel)this.connectorModel.getConnections().get(0);
        ObjectType inputType = (ObjectType)WeaveTypeSimplifier.simplifyWeaveType((DWType)connectionModel.getInputType().getDataType());
        TestUtils.assertLabel((ObjectType)inputType, (String)"baseUri", (String)"The base uri that will be used for all HTTP requests");
        TestUtils.assertLabel((ObjectType)inputType, (String)"username", (String)"The username used to authenticate the requests");
        TestUtils.assertLabel((ObjectType)inputType, (String)"password", (String)"The password used to authenticate the requests");
        TestUtils.assertSemanticTerms((DWType)inputType, (String)"password", List.of("password"));
        TestUtils.assertLabel((DWType)inputType, (String)"Twilio basic connection");
    }

    protected static Map<String, Object> getConnectionInfo() {
        HashMap<String, Object> connectionInfo = new HashMap<String, Object>();
        connectionInfo.put("baseUri", "http://localhost:" + serverPort);
        connectionInfo.put("username", "pepito");
        connectionInfo.put("password", "mysecret");
        return connectionInfo;
    }

    protected static Map<String, Object> getPlatformManagedConnectionInfo() {
        HashMap<String, Object> connectionInfo = new HashMap<String, Object>();
        connectionInfo.put("namedUrl", "http://localhost:" + serverPort);
        return connectionInfo;
    }

    private static Map<String, Object> getOperationParameters() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("query", Collections.emptyMap());
        parameters.put("headers", Collections.emptyMap());
        parameters.put("cookie", Collections.emptyMap());
        return parameters;
    }

    @Test
    void testConnection() {
        FlowConnectionProviderModel connectionModel = (FlowConnectionProviderModel)this.connectorModel.getConnections().get(0);
        Map<String, Object> connectionInfo = AbstractFlowModelInterpreterTest.getConnectionInfo();
        ConnectionValidationResult connectionValidationResult = this.modelInterpreter.testConnection(Objects.requireNonNull(this.connectorModel.getTestConnection()), (BaseConnectionProviderModel)connectionModel, connectionInfo);
        MatcherAssert.assertThat((Object)connectionValidationResult.isValid(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    void executesOperation() {
        FlowConnectionProviderModel connectionModel = (FlowConnectionProviderModel)this.connectorModel.getConnections().get(0);
        Map<String, Object> connectionInfo = AbstractFlowModelInterpreterTest.getConnectionInfo();
        Map<String, Object> parameters = AbstractFlowModelInterpreterTest.getOperationParameters();
        OperationResult operationResult = this.modelInterpreter.executeOperation((BaseConnectionProviderModel)connectionModel, connectionInfo, (BaseExecutableComponentModel)this.connectorModel.getOperations().get(0), parameters);
        MatcherAssert.assertThat((Object)operationResult.isSuccess(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    void executesPlatformManagedOperation() {
        FlowPlatformManagedConnection flowPlatformManagedConnection = FlowPlatformManagedConnection.of(AbstractFlowModelInterpreterTest.getPlatformManagedConnectionInfo());
        Map<String, Object> parameters = AbstractFlowModelInterpreterTest.getOperationParameters();
        OperationResult operationResult = this.modelInterpreter.executeOperation((Connection)flowPlatformManagedConnection, (BaseExecutableComponentModel)this.connectorModel.getOperations().get(0), parameters);
        MatcherAssert.assertThat((Object)operationResult.isSuccess(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    void executesPlatformManagedTrigger() {
        if (this.connectorModel.getTriggers() != null && !this.connectorModel.getTriggers().isEmpty()) {
            FlowPlatformManagedConnection flowPlatformManagedConnection = FlowPlatformManagedConnection.of(AbstractFlowModelInterpreterTest.getPlatformManagedConnectionInfo());
            HashMap<String, Map<String, Integer>> parameters = new HashMap<String, Map<String, Integer>>();
            parameters.put("params", Map.of("since", 20200101));
            Serializable initialWatermark = this.modelInterpreter.getInitialWatermark((Connection)flowPlatformManagedConnection, (BaseExecutableComponentModel)this.connectorModel.getTriggers().get(1), parameters);
            OperationResult triggerResult = this.modelInterpreter.executeTrigger((Connection)flowPlatformManagedConnection, (BaseExecutableComponentModel)this.connectorModel.getTriggers().get(1), (Object)initialWatermark, parameters);
            MatcherAssert.assertThat((Object)triggerResult.isSuccess(), (Matcher)Matchers.is((Object)true));
            OperationResult triggerResultNextPage = this.modelInterpreter.executeTriggerNextPage((Connection)flowPlatformManagedConnection, (BaseExecutableComponentModel)this.connectorModel.getTriggers().get(1), ((TriggerPage)triggerResult.getValue()).getNextData());
            MatcherAssert.assertThat((Object)triggerResultNextPage.isSuccess(), (Matcher)Matchers.is((Object)true));
        }
    }

    @Test
    void testConnectionPlatformManaged() {
        FlowPlatformManagedConnection flowPlatformManagedConnection = FlowPlatformManagedConnection.of(AbstractFlowModelInterpreterTest.getPlatformManagedConnectionInfo());
        ConnectionValidationResult connectionValidationResult = this.modelInterpreter.testConnection(this.connectorModel.getTestConnection(), (Connection)flowPlatformManagedConnection);
        MatcherAssert.assertThat((Object)connectionValidationResult.isValid(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    void executesTrigger() {
        if (this.connectorModel.getTriggers() != null && !this.connectorModel.getTriggers().isEmpty()) {
            FlowConnectionProviderModel connectionModel = (FlowConnectionProviderModel)this.connectorModel.getConnections().get(0);
            Map<String, Object> connectionInfo = AbstractFlowModelInterpreterTest.getConnectionInfo();
            HashMap<String, Map<String, Integer>> parameters = new HashMap<String, Map<String, Integer>>();
            parameters.put("params", Map.of("since", 20200101));
            Serializable initialWatermark = this.modelInterpreter.getInitialWatermark((BaseConnectionProviderModel)connectionModel, connectionInfo, (BaseExecutableComponentModel)this.connectorModel.getTriggers().get(1), parameters);
            OperationResult triggerResult = this.modelInterpreter.executeTrigger((BaseConnectionProviderModel)connectionModel, connectionInfo, (BaseExecutableComponentModel)this.connectorModel.getTriggers().get(1), (Object)initialWatermark, parameters);
            MatcherAssert.assertThat((Object)triggerResult.isSuccess(), (Matcher)Matchers.is((Object)true));
            OperationResult triggerResultNextPage = this.modelInterpreter.executeTriggerNextPage((BaseConnectionProviderModel)connectionModel, connectionInfo, (BaseExecutableComponentModel)this.connectorModel.getTriggers().get(1), ((TriggerPage)triggerResult.getValue()).getNextData());
            MatcherAssert.assertThat((Object)triggerResultNextPage.isSuccess(), (Matcher)Matchers.is((Object)true));
        }
    }

    @Test
    void executesOperationUsingCustomHttpService() {
        ModelInterpreter modelInterpreter = new ModelInterpreter(this.dataWeaveEngine, new ModelInterpreterConfig.Builder().addService(HttpClientService.class, (Object)new TestCustomService()).build());
        FlowConnectionProviderModel connectionModel = (FlowConnectionProviderModel)this.connectorModel.getConnections().get(0);
        Map<String, Object> connectionInfo = AbstractFlowModelInterpreterTest.getConnectionInfo();
        Map<String, Object> parameters = AbstractFlowModelInterpreterTest.getOperationParameters();
        RuntimeException exception = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> modelInterpreter.executeOperation((BaseConnectionProviderModel)connectionModel, (Object)connectionInfo, (BaseExecutableComponentModel)this.connectorModel.getOperations().get(0), (Object)parameters));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.equalTo((Object)NOT_IMPLEMENTED_ERROR));
    }

    @Test
    void executesValueProvider() {
        ModelInterpreter modelInterpreter = new ModelInterpreter(this.dataWeaveEngine, new ModelInterpreterConfig.Builder().addService(HttpClientService.class, (Object)new TestCustomService()).build());
        FlowConnectionProviderModel connectionModel = (FlowConnectionProviderModel)this.connectorModel.getConnections().get(0);
        Map<String, Object> connectionInfo = AbstractFlowModelInterpreterTest.getConnectionInfo();
        OperationModel operation = this.connectorModel.getOperations().stream().filter(op -> op.getName().equals("getMessages")).findFirst().orElseThrow();
        ObjectType uri = (ObjectType)DWTypeUtils.requireFieldByName((ObjectType)((ObjectType)TypeUtils.resolveReferenceType((DWType)operation.getInputType().getDataType())), (String)"uri").getValue();
        DWType accountId = DWTypeUtils.requireFieldByName((ObjectType)uri, (String)"accountId").getValue();
        ProviderReference ann = MetadataUtils.requireValueProvider((DWType)accountId);
        MatcherAssert.assertThat((Object)ann.getName(), (Matcher)Matchers.is((Object)"accountsValueProvider"));
        ValueProviderModel valueProvider = this.connectorModel.getValueProviders().stream().filter(vp -> vp.getName().equals(ann.getName())).findFirst().orElseThrow();
        RuntimeException exception = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> modelInterpreter.executeValueProvider((ConnectionProviderModel)connectionModel, (Object)connectionInfo, valueProvider, Collections.emptyMap()));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.equalTo((Object)NOT_IMPLEMENTED_ERROR));
    }

    static {
        server = new MockServer();
    }

    private static class TestCustomService
    implements HttpClientService {
        private TestCustomService() {
        }

        public HttpClient getClient(HttpClientConfiguration httpClientConfiguration) {
            throw new RuntimeException(AbstractFlowModelInterpreterTest.NOT_IMPLEMENTED_ERROR);
        }
    }
}

