%dw 2.7
import * from com::mulesoft::connectivity::flow::Metadata
import * from twilio::Module

@FlowConnectorElement()
var connector = {
    name: "TWILIO",
    displayName: "Twilio",
    description: "Twilio Connector for testing",
    vendor: "Salesforce",
    since: "R256",
    icons: [
    	{
    		name: "Twilio",
    		alternateText: "Twilio Connector",
    		resource: "icon/twilio.svg",
    		size: 65440,
    		dimensions: "32x32"
    	}
    ],
    connections: {basicAuth: basicAuthConnection, apikey: apiKeyHeaderConnectionProvider, oauth: oauth2AuthCodeConnectionProvider},
    testConnection: testConnection,
    operations: {
        getAccounts: getAccounts ++ {mediaType: "application/json"},
        getMessages: getMessages ++ {mediaType: "application/json"}
    },
    valueProviders: {
        accountsValueProvider: accountsValueProvider
    },
    triggers:  {getUsersTrigger: getUsersTrigger, getUsersTriggerPaginated: getUsersTriggerPaginated}
}
