/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.persistence;

import com.mulesoft.connectivity.flow.api.model.FlowBaseConnectorModel;
import com.mulesoft.connectivity.flow.api.persistence.AuthenticationTypeDeserializer;
import com.mulesoft.connectivity.flow.api.persistence.FlowModelSerializer;
import com.mulesoft.connectivity.linkweave.api.model.BaseExecutableComponentModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.BaseConnectionProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.TestConnectionModel;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.jspecify.annotations.Nullable;

public class FlowBasicModelDeserializer {
    private static final String NAME_PROPERTY = "name";
    private static final String DISPLAY_NAME_PROPERTY = "displayName";
    private static final String MODEL_REFERENCE_PROPERTY = "modelReference";
    private static final String CONNECTIONS_PROPERTY = "connections";
    private static final String TEST_CONNECTION_PROPERTY = "testConnection";
    private static final String OPERATIONS_PROPERTY = "operations";
    private static final String TRIGGERS_PROPERTY = "triggers";
    private static final String AUTHENTICATION_TYPE_PROPERTY = "authenticationType";
    private static final String IS_PAGINATED_PROPERTY = "isPaginated";
    private static final String HAS_EXTENSIONS = "hasExtensions";

    public synchronized FlowBaseConnectorModel<?, ?, ?> deserialize(Map<?, ?> serialized) {
        return ((FlowBaseConnectorModel.Builder)((Object)((FlowBaseConnectorModel.Builder)((Object)((FlowBaseConnectorModel.Builder)((Object)((FlowBaseConnectorModel.Builder)((Object)((FlowBaseConnectorModel.Builder)((FlowBaseConnectorModel.Builder)((FlowBaseConnectorModel.Builder)new FlowBaseConnectorModel.Builder().withName(FlowModelSerializer.requireProperty(serialized, NAME_PROPERTY, String.class))).withDisplayName(FlowModelSerializer.requireProperty(serialized, DISPLAY_NAME_PROPERTY, String.class))).withModelReference((String)((Object)FlowModelSerializer.getProperty(serialized, MODEL_REFERENCE_PROPERTY, String.class)))).withConnections(this.deserializeConnections((List)((Object)FlowModelSerializer.getProperty(serialized, CONNECTIONS_PROPERTY, List.class)))))).withTestConnection(this.deserializeTestConnection((Map)((Object)FlowModelSerializer.getProperty(serialized, TEST_CONNECTION_PROPERTY, Map.class)))))).withOperations(this.deserializeOperations(FlowModelSerializer.requireProperty(serialized, OPERATIONS_PROPERTY, List.class))))).withTriggers(this.deserializeTriggers((List)((Object)FlowModelSerializer.getProperty(serialized, TRIGGERS_PROPERTY, List.class)))))).build();
    }

    private @Nullable TestConnectionModel deserializeTestConnection(@Nullable Map<String, Object> serialized) {
        if (serialized != null) {
            return (TestConnectionModel)((TestConnectionModel.Builder)new TestConnectionModel.Builder().withModelReference((String)((Object)FlowModelSerializer.getProperty(serialized, MODEL_REFERENCE_PROPERTY, String.class)))).build();
        }
        return null;
    }

    private List<BaseExecutableComponentModel<?>> deserializeOperations(List<?> serializedOperations) {
        return serializedOperations.stream().map(o -> this.deserializeOperation((Map)o)).toList();
    }

    private BaseExecutableComponentModel<?> deserializeOperation(Map<?, ?> serializedOperation) {
        BaseExecutableComponentModel.ExecutableComponentBuilder builder = new BaseExecutableComponentModel.ExecutableComponentBuilder();
        this.deserializeExecutableComponent(serializedOperation, builder);
        return (BaseExecutableComponentModel)builder.build();
    }

    private void deserializeExecutableComponent(Map<?, ?> serializedOperation, BaseExecutableComponentModel.ExecutableComponentBuilder builder) {
        String name = FlowModelSerializer.requireProperty(serializedOperation, NAME_PROPERTY, String.class);
        ((BaseExecutableComponentModel.ExecutableComponentBuilder)((BaseExecutableComponentModel.ExecutableComponentBuilder)((BaseExecutableComponentModel.ExecutableComponentBuilder)builder.withName(name)).withModelReference((String)((Object)FlowModelSerializer.getProperty(serializedOperation, MODEL_REFERENCE_PROPERTY, String.class)))).withIsPaginated(FlowModelSerializer.requireProperty(serializedOperation, IS_PAGINATED_PROPERTY, Boolean.class).booleanValue())).withIsBase(true);
        Map extraVersionsMap = (Map)((Object)FlowModelSerializer.getProperty(serializedOperation, "extraVersions", Map.class));
        if (extraVersionsMap != null) {
            TreeMap extraVersions = new TreeMap();
            BaseExecutableComponentModel.ExecutableComponentBuilder implementationBuilder = new BaseExecutableComponentModel.ExecutableComponentBuilder();
            implementationBuilder.withIsBase(false);
            implementationBuilder.withName(name);
            extraVersionsMap.forEach((version, versionObject) -> {
                int n;
                Map versionMap = (Map)versionObject;
                if (version instanceof String) {
                    String str = (String)version;
                    n = Integer.parseInt(str);
                } else {
                    n = ((Number)version).intValue();
                }
                int versionNumber = n;
                implementationBuilder.withIsPaginated(FlowModelSerializer.requireProperty(versionMap, IS_PAGINATED_PROPERTY, Boolean.class).booleanValue());
                implementationBuilder.withModelReference(FlowModelSerializer.requireProperty(versionMap, MODEL_REFERENCE_PROPERTY, String.class));
                extraVersions.put(versionNumber, (BaseExecutableComponentModel)implementationBuilder.build());
            });
            builder.withVersions(extraVersions);
        }
    }

    private List<BaseExecutableComponentModel<?>> deserializeTriggers(@Nullable List<?> serializedTriggers) {
        return Objects.requireNonNullElse(serializedTriggers, List.of()).stream().map(m -> this.deserializeTrigger((Map)m)).toList();
    }

    private BaseExecutableComponentModel<?> deserializeTrigger(Map<?, ?> serializedTrigger) {
        BaseExecutableComponentModel.ExecutableComponentBuilder builder = new BaseExecutableComponentModel.ExecutableComponentBuilder();
        this.deserializeExecutableComponent(serializedTrigger, builder);
        return (BaseExecutableComponentModel)builder.build();
    }

    private List<BaseConnectionProviderModel> deserializeConnections(@Nullable List<Map<String, Object>> serializedConnections) {
        if (serializedConnections == null) {
            return List.of();
        }
        return serializedConnections.stream().map(serializedConnection -> (BaseConnectionProviderModel)((BaseConnectionProviderModel.Builder)((BaseConnectionProviderModel.Builder)((BaseConnectionProviderModel.Builder)((BaseConnectionProviderModel.Builder)new BaseConnectionProviderModel.Builder().withModelReference((String)((Object)FlowModelSerializer.getProperty(serializedConnection, MODEL_REFERENCE_PROPERTY, String.class)))).authenticationType(new AuthenticationTypeDeserializer().deserializeAuthenticationType(FlowModelSerializer.requireProperty(serializedConnection, AUTHENTICATION_TYPE_PROPERTY, Map.class)))).testConnection(this.deserializeTestConnection((Map)((Object)FlowModelSerializer.getProperty(serializedConnection, TEST_CONNECTION_PROPERTY, Map.class))))).hasExtensions(FlowModelSerializer.requireProperty(serializedConnection, HAS_EXTENSIONS, Boolean.class).booleanValue())).build()).toList();
    }
}

