/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.model;

import com.mulesoft.connectivity.flow.api.model.FlowConnectionProviderModel;
import com.mulesoft.connectivity.flow.api.model.FlowConnectorModel;
import com.mulesoft.connectivity.flow.api.model.IconMetadata;
import com.mulesoft.connectivity.flow.api.model.ReleaseStatus;
import com.mulesoft.connectivity.linkweave.api.model.TypeModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.TestConnectionModel;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationModel;
import com.mulesoft.connectivity.linkweave.api.model.provider.MetadataProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.provider.ValueProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.trigger.TriggerModel;
import java.util.ArrayList;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.NullType;

class FlowConnectorModelTest {
    private static final DWType nullWeaveType = (DWType)Mockito.mock(NullType.class);
    private static final TypeModel nullType = (TypeModel)new TypeModel.Builder().withDataType(nullWeaveType).build();
    private final IconMetadata iconMetadata = new IconMetadata.Builder().withName("Twilio").withAlternateText("Twilio Connector").withResource("icon/twilio.svg").build();
    private final FlowConnectionProviderModel connectionModel = (FlowConnectionProviderModel)((FlowConnectionProviderModel.Builder)((FlowConnectionProviderModel.Builder)new FlowConnectionProviderModel.Builder().inputType(nullType)).name("connection")).build();
    private final OperationModel operationModel = (OperationModel)((OperationModel.Builder)((OperationModel.Builder)((OperationModel.Builder)((OperationModel.Builder)((OperationModel.Builder)new OperationModel.Builder().withName("operation")).withDisplayName("an operation")).withInputType(nullType)).withOutputType(nullType)).withErrorOutputType(nullType)).build();
    private static final String[] fields = new String[]{"name", "modelReference", "version", "displayName", "releaseStatus", "description", "vendor", "icons", "connections", "testConnection", "since"};

    FlowConnectorModelTest() {
    }

    @ParameterizedTest
    @MethodSource(value={"provideFields"})
    void validateWithout(String except) {
        FlowConnectorModel.Builder builder = new FlowConnectorModel.Builder();
        for (String field : fields) {
            if (field.equals(except)) continue;
            this.apply(builder, field);
        }
        IllegalStateException e = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> ((FlowConnectorModel.Builder)builder).build());
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"is required"));
    }

    void apply(FlowConnectorModel.Builder builder, String what) {
        switch (what) {
            case "name": {
                builder.withName("TWILIO");
                break;
            }
            case "modelReference": {
                builder.withModelReference("com::mulesoft::connectivity::twilio::Connector");
                break;
            }
            case "version": {
                builder.withVersion("1.0.0");
                break;
            }
            case "displayName": {
                builder.withDisplayName("Twilio");
                break;
            }
            case "releaseStatus": {
                builder.withReleaseStatus(ReleaseStatus.GA);
                break;
            }
            case "description": {
                builder.withDescription("Twilio Connector");
                break;
            }
            case "icons": {
                builder.withIcons(Collections.singletonList(this.iconMetadata));
                break;
            }
            case "vendor": {
                builder.withVendor("Salesforce");
                break;
            }
            case "connections": {
                builder.withConnections(Collections.singletonList(this.connectionModel));
                break;
            }
            case "operations": {
                builder.withOperations(Collections.singletonList(this.operationModel));
                break;
            }
            case "testConnection": {
                builder.withTestConnection((TestConnectionModel)new TestConnectionModel.Builder().build());
                break;
            }
            case "since": {
                builder.withSince("R256");
            }
        }
    }

    static String[] provideFields() {
        return fields;
    }

    @Test
    public void developerName() {
        MatcherAssert.assertThat((Object)FlowConnectorModel.buildDeveloperName((String)"some-connector"), (Matcher)Matchers.equalTo((Object)"SomeConnector"));
        MatcherAssert.assertThat((Object)FlowConnectorModel.buildDeveloperName((String)"some--connector"), (Matcher)Matchers.equalTo((Object)"SomeConnector"));
        MatcherAssert.assertThat((Object)FlowConnectorModel.buildDeveloperName((String)"connector-test"), (Matcher)Matchers.equalTo((Object)"ConnectorTest"));
        MatcherAssert.assertThat((Object)FlowConnectorModel.buildDeveloperName((String)"\ud835\udc1connector-test"), (Matcher)Matchers.equalTo((Object)"\ud835\udc1connectorTest"));
        MatcherAssert.assertThat((Object)FlowConnectorModel.buildDeveloperName((String)"test-23"), (Matcher)Matchers.equalTo((Object)"Test23"));
        MatcherAssert.assertThat((Object)FlowConnectorModel.buildDeveloperName((String)"4x4"), (Matcher)Matchers.equalTo((Object)"4X4"));
        MatcherAssert.assertThat((Object)FlowConnectorModel.buildDeveloperName((String)"ic2go"), (Matcher)Matchers.equalTo((Object)"Ic2Go"));
        MatcherAssert.assertThat((Object)FlowConnectorModel.buildDeveloperName((String)"RefConnector"), (Matcher)Matchers.equalTo((Object)"RefConnector"));
        MatcherAssert.assertThat((Object)FlowConnectorModel.buildDeveloperName((String)"Nice2MeetYou"), (Matcher)Matchers.equalTo((Object)"Nice2MeetYou"));
        MatcherAssert.assertThat((Object)FlowConnectorModel.buildDeveloperName((String)"TWILIO"), (Matcher)Matchers.equalTo((Object)"Twilio"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FlowConnectorModel.buildDeveloperName((String)".....!"));
    }

    @Test
    void retrievesOperationByName() {
        FlowConnectorModel.Builder builder = this.getConnectorBuilder();
        ArrayList<OperationModel> operations = new ArrayList<OperationModel>();
        OperationModel operation1 = (OperationModel)Mockito.mock(OperationModel.class);
        Mockito.when((Object)operation1.getName()).thenReturn((Object)"operation1");
        operations.add(operation1);
        OperationModel operation2 = (OperationModel)Mockito.mock(OperationModel.class);
        Mockito.when((Object)operation2.getName()).thenReturn((Object)"operation2");
        operations.add(operation2);
        builder.withOperations(operations);
        FlowConnectorModel connector = builder.build();
        OperationModel operation = (OperationModel)connector.getOperation("operation1");
        MatcherAssert.assertThat((Object)operation, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        operation = (OperationModel)connector.getOperation("operation2");
        MatcherAssert.assertThat((Object)operation, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
    }

    @Test
    void failsToRetrieveOperationByName() {
        FlowConnectorModel.Builder builder = this.getConnectorBuilder();
        ArrayList<OperationModel> operations = new ArrayList<OperationModel>();
        OperationModel operation1 = (OperationModel)Mockito.mock(OperationModel.class);
        Mockito.when((Object)operation1.getName()).thenReturn((Object)"operation1");
        operations.add(operation1);
        builder.withOperations(operations);
        FlowConnectorModel connector = builder.build();
        IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> connector.getOperation("invalid"));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.equalTo((Object)"Cannot find operation 'invalid'"));
    }

    @Test
    void retrievesTriggerByName() {
        FlowConnectorModel.Builder builder = this.getConnectorBuilder();
        ArrayList<TriggerModel> triggers = new ArrayList<TriggerModel>();
        TriggerModel trigger1 = (TriggerModel)Mockito.mock(TriggerModel.class);
        Mockito.when((Object)trigger1.getName()).thenReturn((Object)"trigger1");
        triggers.add(trigger1);
        TriggerModel trigger2 = (TriggerModel)Mockito.mock(TriggerModel.class);
        Mockito.when((Object)trigger2.getName()).thenReturn((Object)"trigger2");
        triggers.add(trigger2);
        builder.withTriggers(triggers);
        FlowConnectorModel connector = builder.build();
        TriggerModel trigger = (TriggerModel)connector.getTrigger("trigger1");
        MatcherAssert.assertThat((Object)trigger, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        trigger = (TriggerModel)connector.getTrigger("trigger2");
        MatcherAssert.assertThat((Object)trigger, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
    }

    @Test
    void failsToRetrieveTriggerByName() {
        FlowConnectorModel.Builder builder = this.getConnectorBuilder();
        ArrayList<TriggerModel> triggers = new ArrayList<TriggerModel>();
        TriggerModel trigger1 = (TriggerModel)Mockito.mock(TriggerModel.class);
        Mockito.when((Object)trigger1.getName()).thenReturn((Object)"trigger1");
        triggers.add(trigger1);
        builder.withTriggers(triggers);
        FlowConnectorModel connector = builder.build();
        IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> connector.getTrigger("invalid"));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.equalTo((Object)"Cannot find trigger 'invalid'"));
    }

    @Test
    void retrievesMetadataProviderByName() {
        FlowConnectorModel.Builder builder = this.getConnectorBuilder();
        ArrayList<MetadataProviderModel> metadataProviders = new ArrayList<MetadataProviderModel>();
        MetadataProviderModel metadataProvider1 = (MetadataProviderModel)Mockito.mock(MetadataProviderModel.class);
        Mockito.when((Object)metadataProvider1.getName()).thenReturn((Object)"metadataProvider1");
        metadataProviders.add(metadataProvider1);
        MetadataProviderModel metadataProvider2 = (MetadataProviderModel)Mockito.mock(MetadataProviderModel.class);
        Mockito.when((Object)metadataProvider2.getName()).thenReturn((Object)"metadataProvider2");
        metadataProviders.add(metadataProvider2);
        builder.withMetadataProviders(metadataProviders);
        FlowConnectorModel connector = builder.build();
        MetadataProviderModel metadataProvider = connector.getMetadataProvider("metadataProvider1");
        MatcherAssert.assertThat((Object)metadataProvider, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        metadataProvider = connector.getMetadataProvider("metadataProvider2");
        MatcherAssert.assertThat((Object)metadataProvider, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
    }

    @Test
    void failsToRetrieveMetadataProviderByName() {
        FlowConnectorModel.Builder builder = this.getConnectorBuilder();
        ArrayList<MetadataProviderModel> metadataProviders = new ArrayList<MetadataProviderModel>();
        MetadataProviderModel metadataProvider1 = (MetadataProviderModel)Mockito.mock(MetadataProviderModel.class);
        Mockito.when((Object)metadataProvider1.getName()).thenReturn((Object)"metadataProvider1");
        metadataProviders.add(metadataProvider1);
        builder.withMetadataProviders(metadataProviders);
        FlowConnectorModel connector = builder.build();
        IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> connector.getMetadataProvider("invalid"));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.equalTo((Object)"Cannot find metadata provider 'invalid'"));
    }

    @Test
    void retrievesValueProviderByName() {
        FlowConnectorModel.Builder builder = this.getConnectorBuilder();
        ArrayList<ValueProviderModel> valueProviders = new ArrayList<ValueProviderModel>();
        ValueProviderModel valueProvider1 = (ValueProviderModel)Mockito.mock(ValueProviderModel.class);
        Mockito.when((Object)valueProvider1.getName()).thenReturn((Object)"valueProvider1");
        valueProviders.add(valueProvider1);
        ValueProviderModel valueProvider2 = (ValueProviderModel)Mockito.mock(ValueProviderModel.class);
        Mockito.when((Object)valueProvider2.getName()).thenReturn((Object)"valueProvider2");
        valueProviders.add(valueProvider2);
        builder.withValueProviders(valueProviders);
        FlowConnectorModel connector = builder.build();
        ValueProviderModel valueProvider = connector.getValueProvider("valueProvider1");
        MatcherAssert.assertThat((Object)valueProvider, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        valueProvider = connector.getValueProvider("valueProvider2");
        MatcherAssert.assertThat((Object)valueProvider, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
    }

    @Test
    void failsToRetrieveValueProviderByName() {
        FlowConnectorModel.Builder builder = this.getConnectorBuilder();
        ArrayList<ValueProviderModel> valueProviders = new ArrayList<ValueProviderModel>();
        ValueProviderModel valueProvider1 = (ValueProviderModel)Mockito.mock(ValueProviderModel.class);
        Mockito.when((Object)valueProvider1.getName()).thenReturn((Object)"valueProvider1");
        valueProviders.add(valueProvider1);
        builder.withValueProviders(valueProviders);
        FlowConnectorModel connector = builder.build();
        IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> connector.getValueProvider("invalid"));
        String errorMessage = "Cannot find value provider 'invalid'";
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.equalTo((Object)errorMessage));
    }

    private FlowConnectorModel.Builder getConnectorBuilder() {
        FlowConnectorModel.Builder builder = new FlowConnectorModel.Builder();
        for (String field : fields) {
            this.apply(builder, field);
        }
        return builder;
    }

    @Nested
    @DisplayName(value="Since Field Tests")
    class SinceFieldTests {
        SinceFieldTests() {
        }

        @Test
        @DisplayName(value="Should accept valid since value R256")
        void shouldAcceptValidSinceR256() {
            FlowConnectorModel.Builder builder = FlowConnectorModelTest.this.getConnectorBuilder();
            builder.withSince("R256");
            FlowConnectorModel model = builder.build();
            Assertions.assertEquals((Object)"R256", (Object)model.getSince(), (String)"Should store and return R256 since value");
        }

        @Test
        @DisplayName(value="Should accept valid since value R258")
        void shouldAcceptValidSinceR258() {
            FlowConnectorModel.Builder builder = FlowConnectorModelTest.this.getConnectorBuilder();
            builder.withSince("R258");
            FlowConnectorModel model = builder.build();
            Assertions.assertEquals((Object)"R258", (Object)model.getSince(), (String)"Should store and return R258 since value");
        }

        @Test
        @DisplayName(value="Should fail when since is missing in builder")
        void shouldFailWithMissingSinceInBuilder() {
            FlowConnectorModel.Builder builder = new FlowConnectorModel.Builder();
            for (String field : fields) {
                if ("since".equals(field)) continue;
                FlowConnectorModelTest.this.apply(builder, field);
            }
            IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> ((FlowConnectorModel.Builder)builder).build(), (String)"Should fail when since is not provided");
            MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.equalTo((Object)"Since is required\n"));
        }

        @Test
        @DisplayName(value="Should fail when since is empty")
        void shouldFailWithEmptySince() {
            FlowConnectorModel.Builder builder = FlowConnectorModelTest.this.getConnectorBuilder();
            builder.withSince("");
            IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> ((FlowConnectorModel.Builder)builder).build(), (String)"Should fail when since is empty");
            MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.equalTo((Object)"Since is required\n"));
        }

        @Test
        @DisplayName(value="Should fail when since is whitespace only")
        void shouldFailWithWhitespaceOnlySince() {
            FlowConnectorModel.Builder builder = FlowConnectorModelTest.this.getConnectorBuilder();
            builder.withSince("   ");
            IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> ((FlowConnectorModel.Builder)builder).build(), (String)"Should fail when since is whitespace only");
            MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.equalTo((Object)"Since is required\n"));
        }
    }
}

