/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.model;

import com.mulesoft.connectivity.flow.api.model.FlowConnectorModel;
import com.mulesoft.connectivity.flow.api.model.IconMetadata;
import com.mulesoft.connectivity.flow.api.model.ReleaseStatus;
import java.io.Serializable;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public class FlowConnectorDescriptorModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String displayName;
    private String version;
    private ReleaseStatus releaseStatus;
    private String description;
    private String vendor;
    private String since;
    private String modelReference;
    private String developerName;
    private String masterLabel;
    private List<IconMetadata> icons;
    private String createdDate;
    private String lastModifiedDate;
    private Map<String, String> serviceModels;

    protected FlowConnectorDescriptorModel(Builder builder) {
        this.name = Objects.requireNonNull(builder.name, "name");
        this.displayName = Objects.requireNonNull(builder.displayName, "displayName");
        this.version = Objects.requireNonNull(builder.version, "version");
        this.releaseStatus = Objects.requireNonNull(builder.releaseStatus, "releaseStatus");
        this.description = Objects.requireNonNull(builder.description, "description");
        this.vendor = Objects.requireNonNull(builder.vendor, "vendor");
        this.since = Objects.requireNonNull(builder.since, "since");
        this.modelReference = Objects.requireNonNull(builder.modelReference, "modelReference");
        this.developerName = Objects.requireNonNull(builder.developerName, "developerName");
        this.icons = Objects.requireNonNull(builder.icons, "icons");
        this.createdDate = Objects.requireNonNull(builder.createdDate, "createdDate");
        this.lastModifiedDate = Objects.requireNonNull(builder.lastModifiedDate, "lastModifiedDate");
        this.serviceModels = builder.serviceModels == null ? Map.of() : Map.copyOf(builder.serviceModels);
        this.masterLabel = this.displayName + " " + this.version;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void setReleaseStatus(ReleaseStatus releaseStatus) {
        this.releaseStatus = releaseStatus;
    }

    public ReleaseStatus getReleaseStatus() {
        return this.releaseStatus;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setSince(String since) {
        this.since = since;
    }

    public String getSince() {
        return this.since;
    }

    public void setModelReference(String modelReference) {
        this.modelReference = modelReference;
    }

    public String getModelReference() {
        return this.modelReference;
    }

    public void setDeveloperName(String developerName) {
        this.developerName = developerName;
    }

    public String getDeveloperName() {
        return this.developerName;
    }

    public void setMasterLabel(String masterLabel) {
        this.masterLabel = masterLabel;
    }

    public String getMasterLabel() {
        return this.masterLabel;
    }

    public void setIcons(List<IconMetadata> icons) {
        this.icons = icons;
    }

    public List<IconMetadata> getIcons() {
        return this.icons;
    }

    public void setCreatedDate(String createdDate) {
        this.createdDate = createdDate;
    }

    public String getCreatedDate() {
        return this.createdDate;
    }

    public void setLastModifiedDate(String lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public String getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public Map<String, String> getServiceModels() {
        return this.serviceModels;
    }

    public void setServiceModels(Map<String, String> serviceModels) {
        this.serviceModels = serviceModels;
    }

    public String toString() {
        return "FlowConnectorDescriptorModel{name='" + this.name + "', displayName='" + this.displayName + "', version='" + this.version + "', releaseStatus='" + String.valueOf((Object)this.releaseStatus) + "', description='" + this.description + "', vendor='" + this.vendor + "', since='" + this.since + "', modelReference='" + this.modelReference + "', developerName='" + this.getDeveloperName() + "', masterLabel='" + this.getMasterLabel() + "', icons='" + String.valueOf(this.icons) + "', createdDate='" + this.createdDate + "', lastModifiedDate='" + this.lastModifiedDate + "', serviceModels=" + String.valueOf(this.serviceModels) + "}";
    }

    public static final class Builder {
        private @Nullable String name;
        private @Nullable String displayName;
        private @Nullable String version;
        private @Nullable ReleaseStatus releaseStatus;
        private @Nullable String description;
        private @Nullable String vendor;
        private @Nullable String since;
        private @Nullable String modelReference;
        private @Nullable String developerName;
        private @Nullable List<IconMetadata> icons;
        private @Nullable String createdDate;
        private @Nullable String lastModifiedDate;
        private @Nullable Map<String, String> serviceModels;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder withVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder withReleaseStatus(ReleaseStatus releaseStatus) {
            this.releaseStatus = releaseStatus;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withVendor(String vendor) {
            this.vendor = vendor;
            return this;
        }

        public Builder withSince(String since) {
            this.since = since;
            return this;
        }

        public Builder withModelReference(String modelReference) {
            this.modelReference = modelReference;
            return this;
        }

        public Builder withDeveloperName(String developerName) {
            this.developerName = developerName;
            return this;
        }

        public Builder withIcons(List<IconMetadata> icons) {
            this.icons = icons;
            return this;
        }

        public Builder withCreatedDate(String createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public Builder withCreatedDate(ZonedDateTime createdDate) {
            this.createdDate = createdDate.withZoneSameInstant(ZoneId.of("UTC")).format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'"));
            return this;
        }

        public Builder withLastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public Builder withLastModifiedDate(ZonedDateTime lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate.withZoneSameInstant(ZoneId.of("UTC")).format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'"));
            return this;
        }

        public Builder withServiceModels(Map<String, String> serviceModels) {
            this.serviceModels = serviceModels;
            return this;
        }

        public Builder fromConnectorModel(FlowConnectorModel connectorModel) {
            this.name = connectorModel.getName();
            this.displayName = connectorModel.getDisplayName();
            this.version = connectorModel.getVersion();
            this.releaseStatus = connectorModel.getReleaseStatus();
            this.description = connectorModel.getDescription();
            this.vendor = connectorModel.getVendor();
            this.since = connectorModel.getSince();
            this.developerName = connectorModel.getDeveloperName();
            this.icons = connectorModel.getIcons();
            this.modelReference = connectorModel.getDwRef();
            return this;
        }

        public FlowConnectorDescriptorModel build() {
            return new FlowConnectorDescriptorModel(this);
        }
    }
}

