/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.connection;

import com.mulesoft.connectivity.flow.internal.connection.AuthenticationTypeExtractor;
import com.mulesoft.connectivity.flow.internal.connection.ConnectionInputTypeInformation;
import com.mulesoft.connectivity.linkweave.api.metadata.MetadataUtils;
import com.mulesoft.connectivity.linkweave.api.model.connection.ApiKeyHttpAuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.AuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.ConnectionProviderModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.DWTypeVisitor;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.mule.weave.v2.api.tooling.ts.SimpleReferenceType;

public class ConnectionInputTypeInformationFactory {
    public ConnectionInputTypeInformation createConnectionInputTypeInformation(ConnectionProviderModel connection) {
        ArrayList<Map<String, Object>> inputTypeConnectorInfoList = new ArrayList<Map<String, Object>>();
        AuthenticationType authenticationType = connection.getAuthenticationType();
        if (authenticationType == null) {
            return null;
        }
        this.addApiKeyIfApplicable(authenticationType, inputTypeConnectorInfoList);
        this.addInputFields(connection.getInputType().getDataType(), inputTypeConnectorInfoList);
        AuthenticationTypeExtractor typeExtractor = AuthenticationTypeExtractor.getFrom(authenticationType);
        return ConnectionInputTypeInformation.builder().type(typeExtractor.getType().name()).subType(typeExtractor.getSubType()).authInfo(inputTypeConnectorInfoList).hasExtensions(connection.getHasExtensions()).modelReference(connection.getModelReference().filter(Predicate.not(String::isEmpty)).orElseThrow(() -> new IllegalStateException("Model must have a valid selector set as model reference"))).build();
    }

    private void addApiKeyIfApplicable(AuthenticationType authenticationType, List<Map<String, Object>> inputTypeConnectorInfoList) {
        if (authenticationType instanceof ApiKeyHttpAuthenticationType) {
            ApiKeyHttpAuthenticationType authType = (ApiKeyHttpAuthenticationType)authenticationType;
            String apiKeyName = authType.getName();
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("name", "authKeyName");
            input.put("value", apiKeyName);
            input.put("required", false);
            input.put("userInputNeeded", false);
            inputTypeConnectorInfoList.add(input);
        }
    }

    private void addInputFields(DWType inputType, List<Map<String, Object>> inputTypeConnectorInfoList) {
        inputType.accept(this.visitAndPopulateInputType(inputTypeConnectorInfoList));
    }

    private DWTypeVisitor visitAndPopulateInputType(final List<Map<String, Object>> inputTypeConnectorInfoList) {
        return new DWTypeVisitor(){

            public void visitObjectType(ObjectType objectType) {
                for (KeyValuePairType field : objectType.getProperties()) {
                    HashMap<String, Object> input = new HashMap<String, Object>();
                    input.put("name", field.getKeyName());
                    input.put("required", !field.isOptionalKey());
                    input.put("helpText", MetadataUtils.getHelpText((DWType)field).orElse(null));
                    inputTypeConnectorInfoList.add(input);
                }
            }

            public void visitSimpleReferenceType(SimpleReferenceType simpleReferenceType) {
                DWType aType = simpleReferenceType.resolveType();
                this.visitObjectType((ObjectType)aType);
            }
        };
    }
}

