/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.connector;

import com.mulesoft.connectivity.flow.internal.connector.FlowConnection;
import com.mulesoft.connectivity.flow.internal.executables.ExecutableVersion;
import com.mulesoft.connectivity.linkweave.api.connector.Trigger;
import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreter;
import com.mulesoft.connectivity.linkweave.api.model.BaseExecutableComponentModel;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationResult;
import com.mulesoft.connectivity.linkweave.api.model.trigger.NextData;
import com.mulesoft.connectivity.linkweave.api.model.trigger.NextPoll;
import com.mulesoft.connectivity.linkweave.api.model.trigger.TriggerItem;
import com.mulesoft.connectivity.linkweave.api.model.trigger.TriggerPage;
import java.io.Serializable;
import java.util.Objects;
import java.util.TreeMap;
import org.jspecify.annotations.Nullable;

class FlowTrigger
implements Trigger {
    private final ModelInterpreter modelInterpreter;
    private final String name;
    private final ExecutableVersion executableVersion;
    private final FlowConnection connection;

    FlowTrigger(ModelInterpreter modelInterpreter, String name, ExecutableVersion executableVersion, FlowConnection connection) {
        this.modelInterpreter = modelInterpreter;
        this.name = name;
        this.executableVersion = executableVersion;
        this.connection = connection;
    }

    public OperationResult<? extends TriggerPage<? extends TriggerItem>> execute(Object parameters, @Nullable NextPoll nextPoll, @Nullable Serializable nextPage) {
        OperationResult res;
        if (FlowTrigger.isTheVeryFirstCall(nextPoll, nextPage)) {
            Serializable initialWatermark = this.getInitialWatermark(parameters);
            res = this.modelInterpreter.executeTrigger(this.connection.asHolder(), this.getTriggerModel(), (Object)initialWatermark, parameters);
        } else {
            res = FlowTrigger.isSubsequentFirstCall(nextPage) ? this.modelInterpreter.executeTrigger(this.connection.asHolder(), this.getTriggerModel(), (Object)Objects.requireNonNull(nextPoll.getGreatestWatermark()), parameters) : this.executeNextPage(new NextData(Objects.requireNonNull(nextPoll), nextPage));
        }
        return res;
    }

    private static boolean isTheVeryFirstCall(@Nullable NextPoll nextPoll, @Nullable Serializable nextPage) {
        return nextPage == null && nextPoll == null;
    }

    private static boolean isSubsequentFirstCall(@Nullable Serializable nextPage) {
        return nextPage == null;
    }

    private OperationResult<? extends TriggerPage<? extends TriggerItem>> executeNextPage(NextData nextData) {
        return this.modelInterpreter.executeTriggerNextPage(this.connection.asHolder(), this.getTriggerModel(), nextData);
    }

    public Serializable getInitialWatermark(Object parameters) {
        return this.modelInterpreter.getInitialWatermark(this.connection.asHolder(), this.getTriggerModel(), parameters);
    }

    private BaseExecutableComponentModel getTriggerModel() {
        return new BaseExecutableComponentModel(this.executableVersion.getModelReference(), this.name, new TreeMap(), true, this.executableVersion.isPaginated());
    }
}

