/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.loader;

import com.google.gson.Gson;
import com.mulesoft.connectivity.flow.api.loader.FlowConnectorLoader;
import com.mulesoft.connectivity.flow.api.loader.FlowModelLoaderFactory;
import com.mulesoft.connectivity.flow.api.metadata.FlowMetadataUtils;
import com.mulesoft.connectivity.flow.api.model.FlowBaseConnectorModel;
import com.mulesoft.connectivity.flow.api.model.FlowConnectionProviderModel;
import com.mulesoft.connectivity.flow.api.model.FlowConnectorModel;
import com.mulesoft.connectivity.flow.api.model.IconMetadata;
import com.mulesoft.connectivity.flow.api.model.ReleaseStatus;
import com.mulesoft.connectivity.flow.api.persistence.FlowBasicModelDeserializer;
import com.mulesoft.connectivity.flow.api.persistence.FlowModelSerializer;
import com.mulesoft.connectivity.linkweave.api.loader.LanguageModelLoader;
import com.mulesoft.connectivity.linkweave.api.loader.ModelLoader;
import com.mulesoft.connectivity.linkweave.api.metadata.MetadataUtils;
import com.mulesoft.connectivity.linkweave.api.model.BaseExecutableComponentModel;
import com.mulesoft.connectivity.linkweave.api.model.Discriminator;
import com.mulesoft.connectivity.linkweave.api.model.LinkWeaveModelLoader001Test;
import com.mulesoft.connectivity.linkweave.api.model.connection.ApiKeyHttpAuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.BaseConnectionProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.HttpAuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.TestConnectionModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.oauth.OAuth2AuthCodeAuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.oauth.OAuth2ClientCredentialsAuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.matchers.ObjectFieldMatcher;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationModel;
import com.mulesoft.connectivity.linkweave.api.model.provider.MetadataProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.provider.ProvidedValue;
import com.mulesoft.connectivity.linkweave.api.model.provider.ValueProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.trigger.TriggerModel;
import com.mulesoft.connectivity.linkweave.api.model.value.Holder;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsInstanceOf;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.mule.weave.v2.api.tooling.ts.SimpleReferenceType;
import org.mule.weave.v2.api.tooling.ts.StringType;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class FlowConnectorLoaderTest {
    private static final DataWeaveScriptingEngine dataWeaveEngine = new DataWeaveScriptingEngine();
    private static final LanguageModelLoader<FlowConnectorModel, FlowConnectorModel.Builder> flowLoader = new LanguageModelLoader(dataWeaveEngine, (ModelLoader)new FlowModelLoaderFactory().create(), NameIdentifier.fromFQN((String)"com::mulesoft::connectivity::flow::Metadata::FlowConnectorElement"));

    @Test
    void loadsConnectorModelWithOperationsAndConnections() {
        FlowConnectorModel connectorModel = (FlowConnectorModel)flowLoader.loadModule("test001::Connector", (Object)new FlowConnectorLoader.ExtraData("1.2.3", ReleaseStatus.GA));
        FlowConnectorLoaderTest.assertFlowConnectorModel(connectorModel);
    }

    @Test
    void loadsConnectorModelWithOperationsAndConnectionsSerialized() {
        InputStream inputStream = this.getClass().getResourceAsStream("/test001/serializedModel.json");
        InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        FlowConnectorModel model = new FlowModelSerializer().deserialize((Map)new Gson().fromJson((Reader)reader, Map.class));
        FlowConnectorLoaderTest.assertFlowConnectorModel(model);
    }

    @Test
    void loadsConnectorModelWithOperationsAndConnectionsSerializedBasicDeserializer() {
        InputStream inputStream = this.getClass().getResourceAsStream("/test001/serializedModel.json");
        InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        FlowBaseConnectorModel model = new FlowBasicModelDeserializer().deserialize((Map)new Gson().fromJson((Reader)reader, Map.class));
        MatcherAssert.assertThat((Object)((String)model.getModelReference().get()), (Matcher)Matchers.equalTo((Object)"test001::Connector::connector"));
        MatcherAssert.assertThat((Object)model.getTestConnection(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        BaseExecutableComponentModel operation = (BaseExecutableComponentModel)model.getOperations().get(0);
        MatcherAssert.assertThat(operation.getClass(), (Matcher)Matchers.equalTo(BaseExecutableComponentModel.class));
        MatcherAssert.assertThat((Object)operation.getName(), (Matcher)Matchers.equalTo((Object)"updateAccountById"));
        MatcherAssert.assertThat((Object)operation.isPaginated(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)((String)operation.getModelReference().get()), (Matcher)Matchers.equalTo((Object)"test001::Connector::connector.operations.updateAccountById"));
        MatcherAssert.assertThat((Object)operation.getVersions(), (Matcher)Matchers.aMapWithSize((int)1));
        operation = (BaseExecutableComponentModel)model.getOperations().get(1);
        MatcherAssert.assertThat(operation.getClass(), (Matcher)Matchers.equalTo(BaseExecutableComponentModel.class));
        MatcherAssert.assertThat((Object)operation.getName(), (Matcher)Matchers.equalTo((Object)"getMessages"));
        MatcherAssert.assertThat((Object)operation.isPaginated(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)((String)operation.getModelReference().get()), (Matcher)Matchers.equalTo((Object)"test001::Connector::connector.operations.getMessages"));
        NavigableMap versions = operation.getVersions();
        MatcherAssert.assertThat((Object)versions, (Matcher)Matchers.aMapWithSize((int)2));
        MatcherAssert.assertThat(versions.get(1), (Matcher)Matchers.sameInstance((Object)operation));
        BaseExecutableComponentModel opV2 = (BaseExecutableComponentModel)versions.get(2);
        MatcherAssert.assertThat((Object)opV2.getModelReference(), (Matcher)Matchers.is(Optional.of("test001::Connector::connector.operations.getMessages.versions.\"2\"")));
        BaseExecutableComponentModel trigger = (BaseExecutableComponentModel)model.getTriggers().get(0);
        MatcherAssert.assertThat(trigger.getClass(), (Matcher)Matchers.equalTo(BaseExecutableComponentModel.class));
        MatcherAssert.assertThat((Object)trigger.getName(), (Matcher)Matchers.equalTo((Object)"getUsersTrigger"));
        MatcherAssert.assertThat((Object)operation.isPaginated(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)((String)trigger.getModelReference().get()), (Matcher)Matchers.equalTo((Object)"test001::Connector::connector.triggers.getUsersTrigger"));
        MatcherAssert.assertThat((Object)trigger.getVersions(), (Matcher)Matchers.aMapWithSize((int)2));
        BaseExecutableComponentModel triggerV2 = (BaseExecutableComponentModel)trigger.getVersions().get(2);
        MatcherAssert.assertThat((Object)triggerV2.getModelReference(), (Matcher)Matchers.is(Optional.of("test001::Connector::connector.triggers.getUsersTrigger.versions.\"2\"")));
        BaseConnectionProviderModel connection = (BaseConnectionProviderModel)model.getConnections().get(0);
        MatcherAssert.assertThat(connection.getClass(), (Matcher)Matchers.equalTo(BaseConnectionProviderModel.class));
        MatcherAssert.assertThat((Object)((String)connection.getModelReference().get()), (Matcher)Matchers.equalTo((Object)"test001::Connector::connector.connections.basicAuth"));
    }

    public static void assertFlowConnectorModel(FlowConnectorModel connectorModel) {
        MatcherAssert.assertThat((Object)connectorModel.getModelReference().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)connectorModel.getModelReference().get()), (Matcher)Matchers.equalTo((Object)"test001::Connector::connector"));
        MatcherAssert.assertThat((Object)connectorModel.getName(), (Matcher)Matchers.equalTo((Object)"TWILIO"));
        MatcherAssert.assertThat((Object)connectorModel.getDisplayName(), (Matcher)Matchers.equalTo((Object)"Twilio"));
        MatcherAssert.assertThat((Object)connectorModel.getDescription(), (Matcher)Matchers.equalTo((Object)"Twilio Connector"));
        MatcherAssert.assertThat((Object)connectorModel.getVendor(), (Matcher)Matchers.equalTo((Object)"Salesforce"));
        MatcherAssert.assertThat((Object)connectorModel.getVersion(), (Matcher)Matchers.equalTo((Object)"1.2.3"));
        MatcherAssert.assertThat((Object)connectorModel.getReleaseStatus(), (Matcher)Matchers.equalTo((Object)ReleaseStatus.GA));
        FlowConnectorLoaderTest.assertConnections(connectorModel);
        FlowConnectorLoaderTest.assertTestConnection(connectorModel.getTestConnection());
        FlowConnectorLoaderTest.assertIcons(connectorModel);
        MatcherAssert.assertThat((Object)connectorModel.getOperations(), (Matcher)Matchers.hasSize((int)4));
        LinkWeaveModelLoader001Test.assertUpdateAccountByIdOperation((OperationModel)((OperationModel)connectorModel.getOperations().get(0)), (String)"test001::Connector::connector.operations.updateAccountById");
        LinkWeaveModelLoader001Test.assertGetMessagesOperation((OperationModel)((OperationModel)connectorModel.getOperations().get(1)), (String)"test001::Connector::connector.operations.getMessages");
        LinkWeaveModelLoader001Test.assertGetAccountsOperation((OperationModel)((OperationModel)connectorModel.getOperations().get(2)), (String)"test001::Connector::connector.operations.getAccounts");
        MatcherAssert.assertThat((Object)connectorModel.getValueProviders(), (Matcher)Matchers.hasSize((int)2));
        LinkWeaveModelLoader001Test.assertAccountsValueProvider((ValueProviderModel)((ValueProviderModel)connectorModel.getValueProviders().get(0)), (String)"test001::Connector::connector.valueProviders.accountsValueProvider");
        LinkWeaveModelLoader001Test.assertUsersValueProvider((ValueProviderModel)((ValueProviderModel)connectorModel.getValueProviders().get(1)), (String)"test001::Connector::connector.valueProviders.usersValueProvider");
        MatcherAssert.assertThat((Object)connectorModel.getMetadataProviders(), (Matcher)Matchers.hasSize((int)1));
        LinkWeaveModelLoader001Test.assertMetadataProvider((MetadataProviderModel)((MetadataProviderModel)connectorModel.getMetadataProviders().get(0)), (String)"test001::Connector::connector.metadataProviders.metadataProvider");
        OperationModel getMessages = connectorModel.getOperations().stream().filter(op -> op.getName().equals("getMessages")).findAny().orElseThrow();
        MatcherAssert.assertThat((Object)getMessages.isBase(), (Matcher)Matchers.is((Object)true));
        NavigableMap versions = getMessages.getVersions();
        MatcherAssert.assertThat((Object)versions, (Matcher)Matchers.aMapWithSize((int)2));
        OperationModel op2 = (OperationModel)versions.get(1);
        MatcherAssert.assertThat((Object)op2, (Matcher)Matchers.sameInstance((Object)getMessages));
        MatcherAssert.assertThat((Object)op2.getName(), (Matcher)Matchers.is((Object)"getMessages"));
        op2 = (OperationModel)versions.get(2);
        MatcherAssert.assertThat((Object)op2, (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)getMessages)));
        MatcherAssert.assertThat((Object)op2.isBase(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)op2.getName(), (Matcher)Matchers.is((Object)"getMessages"));
    }

    private static void assertBasicConnection(FlowConnectorModel connectorModel) {
        FlowConnectionProviderModel connectionModel = (FlowConnectionProviderModel)connectorModel.getConnections().get(0);
        MatcherAssert.assertThat((Object)connectionModel.getModelReference().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)connectionModel.getModelReference().get()), (Matcher)Matchers.equalTo((Object)"test001::Connector::connector.connections.basicAuth"));
        Holder httpAuthenticationTypeHolder = new Holder();
        connectionModel.getAuthenticationType().accept(arg_0 -> ((Holder)httpAuthenticationTypeHolder).setValue(arg_0));
        HttpAuthenticationType httpAuthenticationType = (HttpAuthenticationType)httpAuthenticationTypeHolder.getValue();
        MatcherAssert.assertThat((Object)httpAuthenticationType.getType(), (Matcher)Matchers.equalTo((Object)HttpAuthenticationType.Type.basic));
        MatcherAssert.assertThat((Object)httpAuthenticationType.getSubType().isEmpty(), (Matcher)Matchers.is((Object)true));
        DWType inputType = connectionModel.getInputType().getDataType();
        MatcherAssert.assertThat((Object)inputType, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        MatcherAssert.assertThat(List.of(((ObjectType)inputType).getProperties()), (Matcher)Matchers.contains((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike((String)"baseUri", StringType.class, (boolean)true), ObjectFieldMatcher.fieldLike((String)"password", StringType.class, (boolean)true), ObjectFieldMatcher.fieldLike((String)"username", StringType.class, (boolean)true)}));
        Assertions.assertNull((Object)connectionModel.getTestConnection());
    }

    private static void assertApiKeyConnection(FlowConnectorModel connectorModel) {
        FlowConnectionProviderModel connectionModel = (FlowConnectionProviderModel)connectorModel.getConnections().get(1);
        MatcherAssert.assertThat((Object)connectionModel.getModelReference().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)connectionModel.getModelReference().get()), (Matcher)Matchers.equalTo((Object)"test001::Connector::connector.connections.apikey"));
        Holder httpAuthenticationTypeHolder = new Holder();
        connectionModel.getAuthenticationType().accept(httpAuthenticationType -> httpAuthenticationTypeHolder.setValue((Object)((ApiKeyHttpAuthenticationType)httpAuthenticationType)));
        ApiKeyHttpAuthenticationType httpAuthenticationType2 = (ApiKeyHttpAuthenticationType)httpAuthenticationTypeHolder.getValue();
        MatcherAssert.assertThat((Object)httpAuthenticationType2.getType(), (Matcher)Matchers.equalTo((Object)HttpAuthenticationType.Type.apiKey));
        MatcherAssert.assertThat((Object)httpAuthenticationType2.getSubType().isEmpty(), (Matcher)Matchers.is((Object)true));
        DWType inputType = connectionModel.getInputType().getDataType();
        MatcherAssert.assertThat((Object)inputType, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        MatcherAssert.assertThat(List.of(((ObjectType)inputType).getProperties()), (Matcher)Matchers.contains((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike((String)"baseUri", StringType.class, (boolean)true), ObjectFieldMatcher.fieldLike((String)"apiKey", StringType.class, (boolean)true)}));
        MatcherAssert.assertThat((Object)((ApiKeyHttpAuthenticationType)connectionModel.getAuthenticationType()).getIn().toString(), (Matcher)Matchers.is((Object)"header"));
        MatcherAssert.assertThat((Object)((ApiKeyHttpAuthenticationType)connectionModel.getAuthenticationType()).getName(), (Matcher)Matchers.is((Object)"X-API-KEY"));
        MatcherAssert.assertThat((Object)connectionModel.getTestConnection(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    private static void assertOAuthAuthorizationCodeConnection(FlowConnectionProviderModel connectorModel, boolean hasExtension, String name) {
        FlowConnectionProviderModel connectionModel = connectorModel;
        MatcherAssert.assertThat((Object)connectionModel.getModelReference().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)connectionModel.getModelReference().get()), (Matcher)Matchers.equalTo((Object)("test001::Connector::connector.connections." + name)));
        Holder httpAuthenticationTypeHolder = new Holder();
        connectionModel.getAuthenticationType().accept(httpAuthenticationType -> httpAuthenticationTypeHolder.setValue((Object)((OAuth2AuthCodeAuthenticationType)httpAuthenticationType)));
        OAuth2AuthCodeAuthenticationType httpAuthenticationType2 = (OAuth2AuthCodeAuthenticationType)httpAuthenticationTypeHolder.getValue();
        MatcherAssert.assertThat((Object)httpAuthenticationType2.getType(), (Matcher)Matchers.equalTo((Object)HttpAuthenticationType.Type.oauth2));
        MatcherAssert.assertThat((Object)((String)httpAuthenticationType2.getSubType().get()), (Matcher)Matchers.is((Object)"authorizationCode"));
        DWType inputType = connectionModel.getInputType().getDataType();
        MatcherAssert.assertThat((Object)inputType, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        MatcherAssert.assertThat(List.of(((ObjectType)inputType).getProperties()), (Matcher)Matchers.contains((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike((String)"baseUri", StringType.class, (boolean)true), ObjectFieldMatcher.fieldLike((String)"accessToken", StringType.class, (boolean)true)}));
        OAuth2AuthCodeAuthenticationType authenticationType = (OAuth2AuthCodeAuthenticationType)connectionModel.getAuthenticationType();
        MatcherAssert.assertThat((Object)authenticationType.getRefreshUrl(), (Matcher)Matchers.equalTo(null));
        MatcherAssert.assertThat((Object)((String)authenticationType.getScopes().get(0)), (Matcher)Matchers.is((Object)"test"));
        MatcherAssert.assertThat((Object)authenticationType.getAuthorizationUrl(), (Matcher)Matchers.is((Object)"http://localhost/authorize"));
        MatcherAssert.assertThat((Object)authenticationType.getTokenUrl(), (Matcher)Matchers.is((Object)"http://localhost/token"));
        MatcherAssert.assertThat((Object)connectionModel.getTestConnection(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)connectorModel.getHasExtensions(), (Matcher)Matchers.equalTo((Object)hasExtension));
    }

    private static void assertOAuthClientCredentialsConnection(FlowConnectionProviderModel connectorModel, boolean hasExtension, String name) {
        FlowConnectionProviderModel connectionModel = connectorModel;
        MatcherAssert.assertThat((Object)connectionModel.getModelReference().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)connectionModel.getModelReference().get()), (Matcher)Matchers.equalTo((Object)("test001::Connector::connector.connections." + name)));
        Holder httpAuthenticationTypeHolder = new Holder();
        connectionModel.getAuthenticationType().accept(httpAuthenticationType -> httpAuthenticationTypeHolder.setValue((Object)((OAuth2ClientCredentialsAuthenticationType)httpAuthenticationType)));
        OAuth2ClientCredentialsAuthenticationType httpAuthenticationType2 = (OAuth2ClientCredentialsAuthenticationType)httpAuthenticationTypeHolder.getValue();
        MatcherAssert.assertThat((Object)httpAuthenticationType2.getType(), (Matcher)Matchers.equalTo((Object)HttpAuthenticationType.Type.oauth2));
        MatcherAssert.assertThat((Object)((String)httpAuthenticationType2.getSubType().get()), (Matcher)Matchers.is((Object)"clientCredentials"));
        DWType inputType = connectionModel.getInputType().getDataType();
        MatcherAssert.assertThat((Object)inputType, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        MatcherAssert.assertThat(List.of(((ObjectType)inputType).getProperties()), (Matcher)Matchers.contains((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike((String)"baseUri", StringType.class, (boolean)true), ObjectFieldMatcher.fieldLike((String)"accessToken", StringType.class, (boolean)true)}));
        OAuth2ClientCredentialsAuthenticationType authenticationType = (OAuth2ClientCredentialsAuthenticationType)connectionModel.getAuthenticationType();
        MatcherAssert.assertThat((Object)authenticationType.getRefreshUrl(), (Matcher)Matchers.equalTo((Object)"http://localhost/refresh"));
        MatcherAssert.assertThat((Object)((String)authenticationType.getScopes().get(0)), (Matcher)Matchers.is((Object)"test"));
        MatcherAssert.assertThat((Object)authenticationType.getTokenUrl(), (Matcher)Matchers.is((Object)"http://localhost/token"));
        MatcherAssert.assertThat((Object)connectionModel.getTestConnection(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)connectorModel.getHasExtensions(), (Matcher)Matchers.equalTo((Object)hasExtension));
    }

    private static void assertConnections(FlowConnectorModel connectorModel) {
        MatcherAssert.assertThat((Object)connectorModel.getConnections(), (Matcher)Matchers.hasSize((int)4));
        FlowConnectorLoaderTest.assertBasicConnection(connectorModel);
        FlowConnectorLoaderTest.assertApiKeyConnection(connectorModel);
        FlowConnectorLoaderTest.assertOAuthClientCredentialsConnection((FlowConnectionProviderModel)connectorModel.getConnections().get(2), false, "oauth");
        FlowConnectorLoaderTest.assertOAuthAuthorizationCodeConnection((FlowConnectionProviderModel)connectorModel.getConnections().get(3), true, "oAuthAuthorizationCodeExtensions");
    }

    private static void assertTestConnection(@Nullable TestConnectionModel testConnection) {
        MatcherAssert.assertThat((Object)testConnection, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)testConnection.getModelReference().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)testConnection.getModelReference().get()), (Matcher)Matchers.equalTo((Object)"test001::Connector::connector.testConnection"));
    }

    private static void assertIcons(FlowConnectorModel connectorModel) {
        MatcherAssert.assertThat((Object)connectorModel.getIcons(), (Matcher)Matchers.hasSize((int)1));
        IconMetadata iconMetadata = (IconMetadata)connectorModel.getIcons().get(0);
        MatcherAssert.assertThat((Object)iconMetadata.getName(), (Matcher)Matchers.equalTo((Object)"Twilio"));
        MatcherAssert.assertThat((Object)iconMetadata.getAlternateText(), (Matcher)Matchers.equalTo((Object)"Twilio Connector"));
        MatcherAssert.assertThat((Object)iconMetadata.getResource(), (Matcher)Matchers.equalTo((Object)"icon/twilio.svg"));
    }

    @Test
    void loadsConnectorModelWithoutIcon() {
        Exception exception = (Exception)Assertions.assertThrows(RuntimeException.class, () -> flowLoader.loadModule("connectorWithoutIcon::Connector", (Object)new FlowConnectorLoader.ExtraData("1.2.3", ReleaseStatus.GA)));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.containsString((String)"There was an error while describing model for: connectorWithoutIcon::Connector"));
        MatcherAssert.assertThat((Object)exception.getCause().getMessage(), (Matcher)Matchers.containsString((String)"At least one IconMetadata is required"));
    }

    @Test
    void loadsConnectorModelWithMultipleConnectionsOfSameType() {
        Exception exception = (Exception)Assertions.assertThrows(RuntimeException.class, () -> flowLoader.loadModule("connectorWithMultipleConnectionsOfSameType::Connector", (Object)new FlowConnectorLoader.ExtraData("1.2.3", ReleaseStatus.GA)));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.containsString((String)"There was an error while describing model for: connectorWithMultipleConnectionsOfSameType::Connector::connector"));
        MatcherAssert.assertThat((Object)exception.getCause().getMessage(), (Matcher)Matchers.containsString((String)"Multiple connections found with the same authentication type and subtype: type='oauth2' subtype='authorizationCode' (connections 'oauth' and 'oAuthAuthorizationCodeExtensions'"));
    }

    @Test
    void testLoadQueryBuilder() {
        FlowConnectorModel connectorModel = (FlowConnectorModel)flowLoader.loadModule("querybuilder::Connector", (Object)new FlowConnectorLoader.ExtraData("0.0.1", ReleaseStatus.PILOT));
        FlowConnectorLoaderTest.assertQueryBuilderMetadata(connectorModel);
        FlowModelSerializer flowModelSerializer = new FlowModelSerializer();
        String serializedConnectorModel = flowModelSerializer.serialize(connectorModel);
        connectorModel = flowModelSerializer.deserialize((Map)new Gson().fromJson(serializedConnectorModel, Object.class));
        FlowConnectorLoaderTest.assertQueryBuilderMetadata(connectorModel);
    }

    private static void assertQueryBuilderMetadata(FlowConnectorModel connectorModel) {
        OperationModel operation = (OperationModel)connectorModel.getOperation("queryBuilder");
        TriggerModel trigger = (TriggerModel)connectorModel.getTrigger("queryBuilderTrigger");
        ObjectType inputType = (ObjectType)((SimpleReferenceType)operation.getInputType().getDataType()).resolveType();
        ObjectType triggerInputType = (ObjectType)((SimpleReferenceType)operation.getInputType().getDataType()).resolveType();
        MatcherAssert.assertThat((Object)inputType, (Matcher)Matchers.is((Object)triggerInputType));
        MatcherAssert.assertThat((Object)inputType, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)FlowMetadataUtils.isQueryBuilder((DWType)inputType), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)MetadataUtils.getValueProvider((DWType)inputType.getProperties()[0].getValue()).isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)FlowMetadataUtils.isFieldSelector((DWType)inputType.getProperties()[1].getValue()), (Matcher)Matchers.is((Object)true));
        Discriminator discriminator = (Discriminator)MetadataUtils.getDiscriminator((DWType)inputType.getProperties()[1].getValue()).get();
        MatcherAssert.assertThat((Object)discriminator.getKey(), (Matcher)Matchers.is((Object)"kind"));
        MatcherAssert.assertThat((Object)discriminator.getDefaultSelection(), (Matcher)Matchers.is((Object)"ALL"));
        MatcherAssert.assertThat((Object)((ProvidedValue)discriminator.getValues().get(0)).getValue(), (Matcher)Matchers.is((Object)"ALL"));
        MatcherAssert.assertThat((Object)((ProvidedValue)discriminator.getValues().get(0)).getLabel(), (Matcher)Matchers.is((Object)"Select All Fields"));
        MatcherAssert.assertThat((Object)((ProvidedValue)discriminator.getValues().get(1)).getValue(), (Matcher)Matchers.is((Object)"CUSTOM"));
        MatcherAssert.assertThat((Object)((ProvidedValue)discriminator.getValues().get(1)).getLabel(), (Matcher)Matchers.is((Object)"Select Custom Fields"));
        discriminator = (Discriminator)MetadataUtils.getDiscriminator((DWType)inputType.getProperties()[2].getValue()).get();
        MatcherAssert.assertThat((Object)discriminator.getKey(), (Matcher)Matchers.is((Object)"kind"));
        MatcherAssert.assertThat((Object)discriminator.getDefaultSelection(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)((ProvidedValue)discriminator.getValues().get(0)).getValue(), (Matcher)Matchers.is((Object)"NONE"));
        MatcherAssert.assertThat((Object)((ProvidedValue)discriminator.getValues().get(0)).getLabel(), (Matcher)Matchers.is((Object)"None - Get All Records"));
        MatcherAssert.assertThat((Object)((ProvidedValue)discriminator.getValues().get(1)).getValue(), (Matcher)Matchers.is((Object)"AND"));
        MatcherAssert.assertThat((Object)((ProvidedValue)discriminator.getValues().get(1)).getLabel(), (Matcher)Matchers.is((Object)"All Conditions Are Met (AND)"));
        MatcherAssert.assertThat((Object)((ProvidedValue)discriminator.getValues().get(2)).getValue(), (Matcher)Matchers.is((Object)"OR"));
        MatcherAssert.assertThat((Object)((ProvidedValue)discriminator.getValues().get(2)).getLabel(), (Matcher)Matchers.is((Object)"Any Condition Is Met (OR)"));
        MatcherAssert.assertThat((Object)((ProvidedValue)discriminator.getValues().get(3)).getValue(), (Matcher)Matchers.is((Object)"CUSTOM"));
        MatcherAssert.assertThat((Object)((ProvidedValue)discriminator.getValues().get(3)).getLabel(), (Matcher)Matchers.is((Object)"Custom Condition Logic Is Met"));
        MatcherAssert.assertThat((Object)FlowMetadataUtils.isResultSetFilter((DWType)inputType.getProperties()[2].getValue()), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)FlowMetadataUtils.isFieldLimit((DWType)inputType.getProperties()[3].getValue()), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)FlowMetadataUtils.isFieldOrder((DWType)inputType.getProperties()[5].getValue()), (Matcher)Matchers.is((Object)true));
        DWType value = inputType.getProperties()[4].getValue();
        MatcherAssert.assertThat((Object)FlowMetadataUtils.isQueryBuilder((DWType)value), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)FlowMetadataUtils.isFieldSelector((DWType)value), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)FlowMetadataUtils.isFieldOrder((DWType)value), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)((Integer)MetadataUtils.getMinSize((DWType)inputType.getProperties()[5].getValue()).get()), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((Integer)MetadataUtils.getMaxSize((DWType)inputType.getProperties()[5].getValue()).get()), (Matcher)Matchers.is((Object)10));
        MatcherAssert.assertThat((Object)FlowMetadataUtils.isFieldLimit((DWType)value), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)MetadataUtils.getDiscriminator((DWType)value).isPresent(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)FlowMetadataUtils.isResultSetFilter((DWType)value), (Matcher)Matchers.is((Object)false));
    }
}

