/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.persistence;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mulesoft.connectivity.flow.api.loader.FlowConnectorLoader;
import com.mulesoft.connectivity.flow.api.loader.FlowConnectorLoaderTest;
import com.mulesoft.connectivity.flow.api.loader.FlowModelLoaderFactory;
import com.mulesoft.connectivity.flow.api.model.FlowConnectorModel;
import com.mulesoft.connectivity.flow.api.model.ReleaseStatus;
import com.mulesoft.connectivity.flow.api.persistence.FlowModelSerializer;
import com.mulesoft.connectivity.linkweave.api.loader.LanguageModelLoader;
import com.mulesoft.connectivity.linkweave.api.loader.ModelLoader;
import com.mulesoft.connectivity.linkweave.api.loader.TypeUtils;
import com.mulesoft.connectivity.linkweave.api.metadata.MetadataUtils;
import com.mulesoft.connectivity.linkweave.api.model.operation.ErrorModel;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationModel;
import com.mulesoft.connectivity.linkweave.api.model.provider.ObjectFieldSelector;
import com.mulesoft.connectivity.linkweave.api.model.provider.ProviderArgument;
import com.mulesoft.connectivity.linkweave.api.model.provider.ProviderReference;
import com.mulesoft.connectivity.linkweave.api.util.DWTypeUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jspecify.annotations.NullMarked;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.FieldSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;

@NullMarked
class FlowModelSerializerTest {
    private final DataWeaveScriptingEngine dataWeaveEngine = new DataWeaveScriptingEngine();
    private final LanguageModelLoader<FlowConnectorModel, FlowConnectorModel.Builder> flowLoader = new LanguageModelLoader(this.dataWeaveEngine, (ModelLoader)new FlowModelLoaderFactory().create(), NameIdentifier.fromFQN((String)"com::mulesoft::connectivity::flow::Metadata::FlowConnectorElement"));
    static Object[][] connectorNameAndVersion = new Object[][]{{"test001", "1.2.3", "GA"}, {"twilio", "1.0.0", "GA"}, {"routing", "1.0", "GA"}, {"metadata", "1.2.3", "GA"}, {"querybuilder", "0.0.1", "PILOT"}};

    FlowModelSerializerTest() {
    }

    @ParameterizedTest
    @FieldSource(value={"connectorNameAndVersion"})
    void verifiesSerializedModel(String connectorName, String connectorVersion, String releaseStatus) throws IOException {
        this.doSerializedModelVerification(connectorName + "::Connector", "/" + connectorName + "/serializedModel.json", connectorVersion, ReleaseStatus.fromString((String)releaseStatus));
    }

    private void doSerializedModelVerification(String moduleReference, String serializedModelResource, String connectorVersion, ReleaseStatus releaseStatus) throws IOException {
        JsonElement actual;
        FlowConnectorModel connectorModel = (FlowConnectorModel)this.flowLoader.loadModule(moduleReference, (Object)new FlowConnectorLoader.ExtraData(connectorVersion, releaseStatus));
        FlowModelSerializer flowModelSerializer = new FlowModelSerializer();
        String actualSerializedModel = flowModelSerializer.serialize(connectorModel);
        URL resourceUrl = FlowModelSerializerTest.getResource(serializedModelResource);
        InputStreamReader expectedSerializedModel = FlowModelSerializerTest.getResourceAsReader(resourceUrl);
        JsonElement expected = JsonParser.parseReader((Reader)expectedSerializedModel);
        if (!expected.equals(actual = JsonParser.parseString((String)actualSerializedModel))) {
            try {
                Object actualFile = String.valueOf(Paths.get(resourceUrl.toURI())) + ".actual";
                actualFile = ((String)actualFile).replace("/target/test-classes/", "/src/test/resources/");
                System.err.println("Writing actual content to " + (String)actualFile);
                Files.writeString(Paths.get((String)actualFile, new String[0]), (CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson(actual), new OpenOption[0]);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            Assertions.assertEquals((Object)expected, (Object)actual);
        }
    }

    private static Reader getResourceAsReader(String fileName) throws IOException {
        return FlowModelSerializerTest.getResourceAsReader(FlowModelSerializerTest.getResource(fileName));
    }

    private static URL getResource(String fileName) throws FileNotFoundException {
        URL resourceUrl = FlowModelSerializerTest.class.getResource(fileName);
        if (resourceUrl == null) {
            throw new FileNotFoundException("Can't find resource '" + fileName + "'");
        }
        return resourceUrl;
    }

    private static InputStreamReader getResourceAsReader(URL resourceUrl) throws IOException {
        return new InputStreamReader(resourceUrl.openStream(), StandardCharsets.UTF_8);
    }

    @Test
    void deserializesFlowConnectorModel() {
        FlowConnectorModel connectorModel = (FlowConnectorModel)this.flowLoader.loadModule("test001::Connector", (Object)new FlowConnectorLoader.ExtraData("1.2.3", ReleaseStatus.GA));
        ProviderReference ann1 = FlowModelSerializerTest.findVpAnnotation(connectorModel);
        FlowModelSerializer flowModelSerializer = new FlowModelSerializer();
        String serializedConnectorModel = flowModelSerializer.serialize(connectorModel);
        connectorModel = flowModelSerializer.deserialize((Map)new Gson().fromJson(serializedConnectorModel, Object.class));
        ProviderReference ann2 = FlowModelSerializerTest.findVpAnnotation(connectorModel);
        MatcherAssert.assertThat((Object)ann2, (Matcher)Matchers.is((Object)ann1));
        FlowConnectorLoaderTest.assertFlowConnectorModel(connectorModel);
        Assertions.assertTrue((boolean)((OperationModel)connectorModel.getOperations().get(0)).getValueProviderReferenceFor(ObjectFieldSelector.create((String)"/accountId")).isPresent());
        OperationModel updateAccountById = (OperationModel)connectorModel.getOperations().get(0);
        MatcherAssert.assertThat((Object)updateAccountById.getErrorDefinitions().size(), (Matcher)Matchers.equalTo((Object)2));
        ErrorModel errorModel = (ErrorModel)updateAccountById.getErrorDefinitions().get(0);
        MatcherAssert.assertThat((Object)errorModel.getKind(), (Matcher)Matchers.equalTo((Object)"404"));
        MatcherAssert.assertThat((Object)((String)errorModel.getCategories().get(0)), (Matcher)Matchers.equalTo((Object)"NOT_FOUND"));
        errorModel = (ErrorModel)updateAccountById.getErrorDefinitions().get(1);
        MatcherAssert.assertThat((Object)errorModel.getKind(), (Matcher)Matchers.equalTo((Object)"400"));
        MatcherAssert.assertThat((Object)((String)errorModel.getCategories().get(0)), (Matcher)Matchers.equalTo((Object)"BAD_REQUEST"));
        OperationModel getMessages = (OperationModel)connectorModel.getOperations().get(1);
        MatcherAssert.assertThat((Object)((OperationModel)getMessages.getVersions().get(1)), (Matcher)Matchers.sameInstance((Object)getMessages));
        OperationModel v2 = (OperationModel)getMessages.getVersions().get(2);
        MatcherAssert.assertThat((Object)v2.getName(), (Matcher)Matchers.is((Object)getMessages.getName()));
        MatcherAssert.assertThat((Object)v2.getDisplayName(), (Matcher)Matchers.is((Object)getMessages.getDisplayName()));
        MatcherAssert.assertThat((Object)v2.getModelReference(), (Matcher)Matchers.is(Optional.of("test001::Connector::connector.operations.getMessages.versions.\"2\"")));
    }

    @Test
    void deserializesFlowConnectorWithMetadata() throws IOException {
        FlowConnectorModel connectorModel = (FlowConnectorModel)this.flowLoader.loadModule("metadata::Connector", (Object)new FlowConnectorLoader.ExtraData("1.2.3", ReleaseStatus.GA));
        FlowModelSerializer flowModelSerializer = new FlowModelSerializer();
        String serializedConnectorModel = flowModelSerializer.serialize(connectorModel);
        Reader expectedSerializedModel = FlowModelSerializerTest.getResourceAsReader("/metadata/serializedModel.json");
        Assertions.assertEquals((Object)JsonParser.parseReader((Reader)expectedSerializedModel), (Object)JsonParser.parseString((String)serializedConnectorModel));
        connectorModel = flowModelSerializer.deserialize((Map)new Gson().fromJson(serializedConnectorModel, Object.class));
        OperationModel operationModel = (OperationModel)connectorModel.getOperations().get(0);
        DWType input = operationModel.getInputType().getDataType();
        DWType recordField = DWTypeUtils.requireFieldByName((ObjectType)((ObjectType)TypeUtils.resolveReferenceType((DWType)input)), (String)"record").getValue();
        Optional metadataProvider = MetadataUtils.getMetadataProvider((DWType)recordField);
        Assertions.assertTrue((boolean)metadataProvider.isPresent());
        ProviderReference reference = (ProviderReference)metadataProvider.get();
        Assertions.assertInstanceOf(ObjectFieldSelector.class, (Object)((ProviderArgument)reference.getArguments().get(0)).getInputSelector());
        Assertions.assertTrue((boolean)((ObjectFieldSelector)((ProviderArgument)reference.getArguments().get(0)).getInputSelector()).isRelative());
        Assertions.assertTrue((boolean)MetadataUtils.getMetadataProvider((DWType)operationModel.getOutputType().getDataType()).isPresent());
        Assertions.assertTrue((boolean)operationModel.getInputMetadataProviderReferenceFor(ObjectFieldSelector.create((String)"/record")).isPresent());
        reference = (ProviderReference)operationModel.getInputMetadataProviderReferenceFor(ObjectFieldSelector.create((String)"/record")).get();
        Assertions.assertFalse((boolean)((ObjectFieldSelector)((ProviderArgument)reference.getArguments().get(0)).getInputSelector()).isRelative());
        Assertions.assertTrue((boolean)operationModel.getOutputMetadataProviderReferenceFor(ObjectFieldSelector.create((String)"/")).isPresent());
    }

    @ParameterizedTest
    @ValueSource(strings={"metadata", "routing", "test001", "twilio", "querybuilder"})
    void canLoadSerializedModels(String model) throws IOException {
        FlowModelSerializer flowModelSerializer = new FlowModelSerializer();
        Reader serializedModel = FlowModelSerializerTest.getResourceAsReader("/" + model + "/serializedModel.json");
        Assertions.assertDoesNotThrow(() -> flowModelSerializer.deserialize((Map)new Gson().fromJson(serializedModel, Map.class)));
    }

    private static ProviderReference findVpAnnotation(FlowConnectorModel connectorModel) {
        DWType inputType = ((OperationModel)connectorModel.getOperations().get(0)).getInputType().getDataType();
        return MetadataUtils.requireValueProvider((DWType)DWTypeUtils.requireFieldByName((ObjectType)((ObjectType)inputType), (String)"accountId").getValue());
    }

    @Test
    public void testDeserializeOldModel() throws IOException {
        FlowModelSerializer flowModelSerializer = new FlowModelSerializer();
        Reader serializedModel = FlowModelSerializerTest.getResourceAsReader("/routing/oldSerializedModel.json");
        Assertions.assertDoesNotThrow(() -> flowModelSerializer.deserialize((Map)new Gson().fromJson(serializedModel, Map.class)));
    }
}

