%dw 2.7
import * from com::mulesoft::connectivity::Model
import * from com::mulesoft::connectivity::Metadata
import * from com::mulesoft::connectivity::flow::Metadata
import * from com::mulesoft::connectivity::transport::Http

@OperationElement
var isAlive: Operation<{}, HttpResponse, ResultFailure<HttpResponse, Error>, HttpConnection> = {
    name: "isAlive",
    displayName: "Is alive",
    executor: (parameter, connection) -> success(
        	{
                contentType: "application/json",
                status: 200,
                headers: {},
                cookies: {}
    		})
}

@TestConnectionElement()
var testConnection = {
	validate: defineTestConnection(
        isAlive,
        (response) -> { isValid: response.value.status == 200 }
    )
}

@ConnectionElement()
var connectionProvider = defineBasicHttpConnectionProvider<{baseUri: String, user: String, pass: String}>(
    (connectionInfo) -> {username: connectionInfo.user, password: connectionInfo.pass},
    (parameter) -> {baseUri: parameter.baseUri}
)


// Just a custom operation at the connector level
var getMessages : Operation<Null, HttpResponse<{messages: Array<String>}>, ResultFailure<HttpResponse, Error>, HttpConnection> = {
    name: "getMessages",
    displayName: "Get Messages",
        executor: (parameter, connection) -> success({
                contentType: "application/json",
                status: 200,
                headers: {},
                cookies: {},
                body: {messages: ["Hello", "Good bye"]} <~ {mimeType: "application/json; charset=utf-8", raw: "" as Binary {base: "64"}}
        })
}

@FlowConnectorElement()
var connector = {
                    name: "TWILIO",
                    displayName: "Twilio",
                    description: "Twilio Connector",
                    vendor: "Salesforce",
                    connections: {basicAuth: connectionProvider},
                    testConnection: testConnection,
                    operations: {
                            getMessages: getMessages,
                      }
                }
