/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.persistence;

import com.mulesoft.connectivity.flow.api.persistence.FlowModelSerializer;
import com.mulesoft.connectivity.linkweave.api.model.connection.ApiKeyHttpAuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.AuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.HttpAuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.oauth.OAuth2AuthCodeAuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.oauth.OAuth2AuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.oauth.OAuth2ClientCredentialsAuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.oauth.OAuth2ImplicitAuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.oauth.OAuth2PasswordAuthenticationType;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AuthenticationTypeDeserializer {
    private static final String PLACEMENT = "placement";
    private static final String REFRESH_URL = "refreshUrl";
    private static final String SCOPES = "scopes";
    private static final String AUTHORIZATION_URL = "authorizationUrl";
    private static final String TOKEN_URL = "tokenUrl";
    private static final String IN = "in";
    private static final String NAME = "name";
    private static final String TYPE_PROPERTY = "type";
    private static final String SUB_TYPE_PROPERTY = "subType";

    public AuthenticationType deserializeAuthenticationType(Map<?, ?> authenticationType) {
        String type = FlowModelSerializer.requireProperty(authenticationType, TYPE_PROPERTY, String.class);
        String subType = (String)((Object)FlowModelSerializer.getProperty(authenticationType, SUB_TYPE_PROPERTY, String.class));
        switch (HttpAuthenticationType.Type.fromString((String)type)) {
            case oauth2: {
                OAuth2AuthenticationType.Placement placement = OAuth2AuthenticationType.Placement.fromString((String)((String)((Object)FlowModelSerializer.getProperty(authenticationType, PLACEMENT, String.class))));
                String refreshUrl = (String)((Object)FlowModelSerializer.getProperty(authenticationType, REFRESH_URL, String.class));
                List scopes = FlowModelSerializer.requireProperty(authenticationType, SCOPES, List.class);
                return switch (OAuth2AuthenticationType.GrantType.fromString((String)Objects.requireNonNull(subType, "oauth requires a subtype"))) {
                    default -> throw new IncompatibleClassChangeError();
                    case OAuth2AuthenticationType.GrantType.authorizationCode -> new OAuth2AuthCodeAuthenticationType(placement, refreshUrl, scopes, FlowModelSerializer.requireProperty(authenticationType, AUTHORIZATION_URL, String.class), FlowModelSerializer.requireProperty(authenticationType, TOKEN_URL, String.class));
                    case OAuth2AuthenticationType.GrantType.clientCredentials -> new OAuth2ClientCredentialsAuthenticationType(placement, refreshUrl, scopes, FlowModelSerializer.requireProperty(authenticationType, TOKEN_URL, String.class));
                    case OAuth2AuthenticationType.GrantType.implicit -> new OAuth2ImplicitAuthenticationType(placement, refreshUrl, scopes, FlowModelSerializer.requireProperty(authenticationType, AUTHORIZATION_URL, String.class));
                    case OAuth2AuthenticationType.GrantType.password -> new OAuth2PasswordAuthenticationType(placement, refreshUrl, scopes, FlowModelSerializer.requireProperty(authenticationType, TOKEN_URL, String.class));
                };
            }
            case apiKey: {
                String in = FlowModelSerializer.requireProperty(authenticationType, IN, String.class);
                String name = FlowModelSerializer.requireProperty(authenticationType, NAME, String.class);
                return new ApiKeyHttpAuthenticationType(subType, ApiKeyHttpAuthenticationType.In.fromString((String)in), name);
            }
        }
        return new HttpAuthenticationType(HttpAuthenticationType.Type.fromString((String)type), subType);
    }
}

