/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.executable;

import com.mulesoft.connectivity.flow.api.model.FlowConnectionProviderModel;
import com.mulesoft.connectivity.flow.api.model.FlowConnectorModel;
import com.mulesoft.connectivity.flow.internal.connection.AuthenticationTypeDeserializer;
import com.mulesoft.connectivity.flow.internal.executables.Executable;
import com.mulesoft.connectivity.flow.internal.executables.ExecutableVersion;
import com.mulesoft.connectivity.flow.internal.executables.Executables;
import com.mulesoft.connectivity.flow.internal.executables.ExecutablesFactory;
import com.mulesoft.connectivity.flow.internal.executables.Provider;
import com.mulesoft.connectivity.linkweave.api.model.ExecutableComponentModel;
import com.mulesoft.connectivity.linkweave.api.model.TypeModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.TestConnectionModel;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationModel;
import com.mulesoft.connectivity.linkweave.api.model.provider.MetadataProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.provider.ValueProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.trigger.TriggerModel;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.ts.AnyType;

public class ExecutablesFactoryTest {
    @Test
    public void testCreateExecutables() {
        FlowConnectorModel flowConnectorModel = (FlowConnectorModel)Mockito.mock(FlowConnectorModel.class);
        OperationModel operation1 = this.mockOperationModel("operation1", "com::op::1", false);
        OperationModel operation2 = this.mockOperationModel("operation2", "com::op::2", true);
        Mockito.when((Object)flowConnectorModel.getOperations()).thenReturn(List.of(operation1, operation2));
        Mockito.when((Object)flowConnectorModel.getConnections()).thenReturn(List.of(this.mockConnectionModel()));
        TriggerModel trigger1 = this.mockTriggerModel("trigger1", "com::trg::1", false);
        TriggerModel trigger2 = this.mockTriggerModel("trigger2", "com::trg::2", true);
        Mockito.when((Object)flowConnectorModel.getTriggers()).thenReturn(List.of(trigger1, trigger2));
        ValueProviderModel valueProvider1 = this.mockValueProviderModel("valueProvider1", "com::vp::1", false);
        ValueProviderModel valueProvider2 = this.mockValueProviderModel("valueProvider2", "com::vp::2", true);
        Mockito.when((Object)flowConnectorModel.getValueProviders()).thenReturn(List.of(valueProvider1, valueProvider2));
        MetadataProviderModel metadataProvider1 = this.mockMetadataProviderModel("metadataProvider1", "com::mp::1");
        MetadataProviderModel metadataProvider2 = this.mockMetadataProviderModel("metadataProvider2", "com::mp::2");
        Mockito.when((Object)flowConnectorModel.getMetadataProviders()).thenReturn(List.of(metadataProvider1, metadataProvider2));
        ExecutablesFactory executablesFactory = new ExecutablesFactory();
        Executables executables = executablesFactory.fromConnectorModel(flowConnectorModel);
        this.assertExecutable((Executable)executables.getOperations().get("operation1"), "operation1", "com::op::1", false);
        this.assertExecutable((Executable)executables.getOperations().get("operation2"), "operation2", "com::op::2", true);
        this.assertExecutable((Executable)executables.getTriggers().get("trigger1"), "trigger1", "com::trg::1", false);
        this.assertExecutable((Executable)executables.getTriggers().get("trigger2"), "trigger2", "com::trg::2", true);
        this.assertProvider((Provider)executables.getValueProviders().get("valueProvider1"), "valueProvider1", "com::vp::1", false);
        this.assertProvider((Provider)executables.getValueProviders().get("valueProvider2"), "valueProvider2", "com::vp::2", true);
        this.assertProvider((Provider)executables.getTypeProviders().get("metadataProvider1"), "metadataProvider1", "com::mp::1", false);
        this.assertProvider((Provider)executables.getTypeProviders().get("metadataProvider2"), "metadataProvider2", "com::mp::2", false);
    }

    private void assertExecutable(Executable executable, String name, String modelReference, boolean isPaginated) {
        Assertions.assertEquals((Object)name, (Object)executable.getName());
        Assertions.assertEquals((Object)modelReference, (Object)((ExecutableVersion)executable.getVersions().get(1)).getModelReference());
        Assertions.assertEquals((Object)isPaginated, (Object)((ExecutableVersion)executable.getVersions().get(1)).isPaginated());
    }

    private void assertProvider(Provider provider, String name, String modelReference, boolean isPaginated) {
        Assertions.assertEquals((Object)name, (Object)provider.getName());
        Assertions.assertEquals((Object)modelReference, (Object)provider.getModelReference());
        Assertions.assertEquals((Object)isPaginated, (Object)provider.isPaginated());
    }

    private OperationModel mockOperationModel(String name, String modelReference, boolean isPaginated) {
        OperationModel operationModel = (OperationModel)Mockito.mock(OperationModel.class);
        this.mockModel((ExecutableComponentModel)operationModel, name, modelReference, isPaginated);
        return operationModel;
    }

    private TriggerModel mockTriggerModel(String name, String modelReference, boolean isPaginated) {
        TriggerModel triggerModel = (TriggerModel)Mockito.mock(TriggerModel.class);
        this.mockModel((ExecutableComponentModel)triggerModel, name, modelReference, isPaginated);
        return triggerModel;
    }

    private FlowConnectionProviderModel mockConnectionModel() {
        FlowConnectionProviderModel connectionModel = (FlowConnectionProviderModel)((FlowConnectionProviderModel.Builder)((FlowConnectionProviderModel.Builder)((FlowConnectionProviderModel.Builder)((FlowConnectionProviderModel.Builder)((FlowConnectionProviderModel.Builder)new FlowConnectionProviderModel.Builder().name("name")).testConnection((TestConnectionModel)((TestConnectionModel.Builder)new TestConnectionModel.Builder().withModelReference("test::Connection")).build())).authenticationType(AuthenticationTypeDeserializer.fromMap(Map.of("type", "bearer")))).inputType((TypeModel)new TypeModel.Builder().withDataType((DWType)new AnyType()).build())).withModelReference("connection::Reference")).build();
        return connectionModel;
    }

    private void mockModel(ExecutableComponentModel model, String name, String modelReference, boolean isPaginated) {
        Mockito.when((Object)model.getName()).thenReturn((Object)name);
        Mockito.when((Object)model.getModelReference()).thenReturn(Optional.of(modelReference));
        Mockito.when((Object)model.isPaginated()).thenReturn((Object)isPaginated);
        TreeMap<Integer, ExecutableComponentModel> versions = new TreeMap<Integer, ExecutableComponentModel>();
        versions.put(1, model);
        Mockito.when((Object)model.getVersions()).thenReturn(versions);
    }

    private ValueProviderModel mockValueProviderModel(String name, String modelReference, boolean isPaginated) {
        ValueProviderModel valueProviderModel = (ValueProviderModel)Mockito.mock(ValueProviderModel.class);
        Mockito.when((Object)valueProviderModel.getName()).thenReturn((Object)name);
        Mockito.when((Object)valueProviderModel.getModelReference()).thenReturn(Optional.of(modelReference));
        Mockito.when((Object)valueProviderModel.isPaginated()).thenReturn((Object)isPaginated);
        return valueProviderModel;
    }

    private MetadataProviderModel mockMetadataProviderModel(String name, String modelReference) {
        MetadataProviderModel metadataProviderModel = (MetadataProviderModel)Mockito.mock(MetadataProviderModel.class);
        Mockito.when((Object)metadataProviderModel.getName()).thenReturn((Object)name);
        Mockito.when((Object)metadataProviderModel.getModelReference()).thenReturn(Optional.of(modelReference));
        return metadataProviderModel;
    }
}

