/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.internal.connection;

import com.mulesoft.connectivity.flow.internal.connection.ConnectionInputTypeInformation;
import com.mulesoft.connectivity.flow.internal.connection.ConnectionInputTypeInformationFactory;
import com.mulesoft.connectivity.linkweave.api.model.TypeModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.ApiKeyHttpAuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.AuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.ConnectionProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.HttpAuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.TestConnectionModel;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.TypeType;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.ts.WeaveType;

public class ConnectionInputTypeInformationFactoryTest {
    public static final DataWeaveScriptingEngine ENGINE = new DataWeaveScriptingEngine();

    @Test
    @DisplayName(value="GIVEN a connection with no modelReference\nWHEN createConnectionInputTypeInformation is called\nTHEN throws IllegalStateException\n")
    public void noModelReferenceThrowsException() {
        ConnectionInputTypeInformationFactory factory = new ConnectionInputTypeInformationFactory();
        ConnectionProviderModel connection = (ConnectionProviderModel)((ConnectionProviderModel.Builder)ConnectionInputTypeInformationFactoryTest.connectionProviderModelBuilder().name("connection")).build();
        Assertions.assertThrows(IllegalStateException.class, () -> factory.createConnectionInputTypeInformation(connection));
    }

    @Test
    @DisplayName(value="GIVEN null authentication type\nWHEN createConnectionInputTypeInformation is called\nTHEN returns null")
    public void nullAuthenticationTypeReturnsNull() {
        ConnectionInputTypeInformationFactory factory = new ConnectionInputTypeInformationFactory();
        ConnectionProviderModel connection = (ConnectionProviderModel)((ConnectionProviderModel.Builder)((ConnectionProviderModel.Builder)ConnectionInputTypeInformationFactoryTest.connectionProviderModelBuilder().authenticationType(null)).name("connection")).build();
        ConnectionInputTypeInformation connectionInputTypeInformation = factory.createConnectionInputTypeInformation(connection);
        Assertions.assertNull((Object)connectionInputTypeInformation);
    }

    @Test
    @DisplayName(value="GIVEN a connection with ApiKeyHttpAuthenticationType\nWHEN createConnectionInputTypeInformation is called\nTHEN it adds the input values for such authentication type\n")
    public void apiKeyHttpAuthenticationTypeAddsInputValues() {
        ConnectionInputTypeInformationFactory factory = new ConnectionInputTypeInformationFactory();
        ConnectionProviderModel connection = (ConnectionProviderModel)((ConnectionProviderModel.Builder)((ConnectionProviderModel.Builder)((ConnectionProviderModel.Builder)ConnectionInputTypeInformationFactoryTest.connectionProviderModelBuilder().authenticationType((AuthenticationType)new ApiKeyHttpAuthenticationType("subtype", ApiKeyHttpAuthenticationType.In.cookie, "authName"))).name("connection")).withModelReference("com::bla")).build();
        ConnectionInputTypeInformation connectionInputTypeInformation = factory.createConnectionInputTypeInformation(connection);
        Optional<Map> apiKeyInputMapOptional = connectionInputTypeInformation.getAuthInfo().stream().filter(i -> i.getOrDefault("name", "").equals("authKeyName")).findFirst();
        Assertions.assertTrue((boolean)apiKeyInputMapOptional.isPresent());
        Map apiKeyInputMap = apiKeyInputMapOptional.get();
        Assertions.assertEquals((Object)"authKeyName", apiKeyInputMap.get("name"));
        Assertions.assertEquals((Object)"authName", apiKeyInputMap.get("value"));
        Assertions.assertEquals((Object)false, apiKeyInputMap.get("required"));
        Assertions.assertEquals((Object)false, apiKeyInputMap.get("userInputNeeded"));
    }

    public static ConnectionProviderModel.Builder connectionProviderModelBuilder() {
        return (ConnectionProviderModel.Builder)((ConnectionProviderModel.Builder)((ConnectionProviderModel.Builder)((ConnectionProviderModel.Builder)new ConnectionProviderModel.Builder().authenticationType((AuthenticationType)new HttpAuthenticationType(HttpAuthenticationType.Type.basic, null))).hasExtensions(false)).inputType((TypeModel)((TypeModel.Builder)new TypeModel.Builder().withModelReference("")).withDataType((DWType)Mockito.mock(DWType.class)).build())).testConnection((TestConnectionModel)new TestConnectionModel.Builder().build());
    }

    @Nested
    public class PopulateInputTypeVisitorTest {
        @Test
        @DisplayName(value="GIVEN a connection with ObjectDataType as Input Type\nWHEN createConnectionInputTypeInformation is called\nTHEN it adds the input values for the object\n")
        public void objectDataTypeAsInputTypeAddsInputValues() {
            String script = "%dw 2.8\ntype Root = {\n  field1: String\n}\n---\nRoot\n";
            ConnectionProviderModel connection = (ConnectionProviderModel)((ConnectionProviderModel.Builder)((ConnectionProviderModel.Builder)((ConnectionProviderModel.Builder)ConnectionInputTypeInformationFactoryTest.connectionProviderModelBuilder().inputType((TypeModel)((TypeModel.Builder)new TypeModel.Builder().withModelReference("com::bla")).withDataType(this.createDWType(script)).build())).withModelReference("com::bla")).name("connection")).build();
            ConnectionInputTypeInformation connectionInputTypeInformation = new ConnectionInputTypeInformationFactory().createConnectionInputTypeInformation(connection);
            this.assertField(connectionInputTypeInformation, "field1", null, true);
        }

        @Test
        @DisplayName(value="GIVEN a connection with ObjectDataType as Input Type WITH OPTIONAL FIELD\nWHEN createConnectionInputTypeInformation is called\nTHEN it adds the input values for the object\n")
        public void objectDataTypeAsInputTypeWithOptionalFieldAddsInputValues() {
            String script = "%dw 2.8\ntype Root = {\n  fieldRequired: String,\n  fieldOptional?: String\n}\n---\nRoot";
            ConnectionProviderModel connection = (ConnectionProviderModel)((ConnectionProviderModel.Builder)((ConnectionProviderModel.Builder)((ConnectionProviderModel.Builder)ConnectionInputTypeInformationFactoryTest.connectionProviderModelBuilder().inputType((TypeModel)((TypeModel.Builder)new TypeModel.Builder().withModelReference("com::bla")).withDataType(this.createDWType(script)).build())).withModelReference("com::bla")).name("connection")).build();
            ConnectionInputTypeInformation connectionInputTypeInformation = new ConnectionInputTypeInformationFactory().createConnectionInputTypeInformation(connection);
            this.assertField(connectionInputTypeInformation, "fieldRequired", null, true);
            this.assertField(connectionInputTypeInformation, "fieldOptional", null, false);
        }

        @Test
        @DisplayName(value="GIVEN a connection with ObjectDataType as Input Type WITH HELP TEXT\nWHEN createConnectionInputTypeInformation is called\nTHEN it adds the input values for the object\n")
        public void objectDataTypeAsInputTypeWithHelpTextAddsInputValues() {
            String script = "%dw 2.8\n@AnnotationTarget(targets = [\"KeyType\", \"Type\", \"TypeExpression\"])\n@Metadata(key = \"helpText\")\nannotation HelpText(value: String)\n\ntype Root = {\n  field: @HelpText(value = \"my helpText\") String\n}\n---\nRoot";
            ConnectionProviderModel connection = (ConnectionProviderModel)((ConnectionProviderModel.Builder)((ConnectionProviderModel.Builder)((ConnectionProviderModel.Builder)ConnectionInputTypeInformationFactoryTest.connectionProviderModelBuilder().inputType((TypeModel)((TypeModel.Builder)new TypeModel.Builder().withModelReference("com::bla")).withDataType(this.createDWType(script)).build())).withModelReference("com::bla")).name("connection")).build();
            ConnectionInputTypeInformation connectionInputTypeInformation = new ConnectionInputTypeInformationFactory().createConnectionInputTypeInformation(connection);
            this.assertField(connectionInputTypeInformation, "field", "my helpText", true);
        }

        @Test
        @DisplayName(value="GIVEN a connection with ReferenceType as Input Type\nWHEN createConnectionInputTypeInformation is called\nTHEN it adds the input values for the referenced object\n")
        public void referenceTypeAsInputTypeAddsInputValues() {
            String script = "%dw 2.8\ntype Root = {\n  fieldRequired: String,\n  fieldOptional?: String\n}\ntype Reference = Root\n---\nReference";
            ConnectionProviderModel connection = (ConnectionProviderModel)((ConnectionProviderModel.Builder)((ConnectionProviderModel.Builder)((ConnectionProviderModel.Builder)ConnectionInputTypeInformationFactoryTest.connectionProviderModelBuilder().inputType((TypeModel)((TypeModel.Builder)new TypeModel.Builder().withModelReference("com::bla")).withDataType(this.createDWType(script)).build())).withModelReference("com::bla")).name("connection")).build();
            ConnectionInputTypeInformation connectionInputTypeInformation = new ConnectionInputTypeInformationFactory().createConnectionInputTypeInformation(connection);
            this.assertField(connectionInputTypeInformation, "fieldRequired", null, true);
            this.assertField(connectionInputTypeInformation, "fieldOptional", null, false);
        }

        private void assertField(ConnectionInputTypeInformation connectionInputTypeInformation, String name, String helpText, boolean required) {
            Optional<Map> apiKeyInputMapOptional = connectionInputTypeInformation.getAuthInfo().stream().filter(i -> i.getOrDefault("name", "").equals(name)).findFirst();
            Assertions.assertTrue((boolean)apiKeyInputMapOptional.isPresent());
            Map apiKeyInputMap = apiKeyInputMapOptional.get();
            Assertions.assertEquals((Object)name, apiKeyInputMap.get("name"));
            Assertions.assertEquals((Object)helpText, apiKeyInputMap.get("helpText"));
            Assertions.assertEquals((Object)required, apiKeyInputMap.get("required"));
        }

        private DWType createDWType(String script) {
            WeaveType weaveType = (WeaveType)ENGINE.inferTypeOf(script).get();
            return ((TypeType)weaveType).getType();
        }
    }
}

