/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.flow.api.loader;

import com.mulesoft.connectivity.flow.api.model.FlowConnectionProviderModel;
import com.mulesoft.connectivity.flow.api.model.FlowConnectorModel;
import com.mulesoft.connectivity.flow.api.model.IconMetadata;
import com.mulesoft.connectivity.flow.api.model.ReleaseStatus;
import com.mulesoft.connectivity.flow.internal.connection.AuthenticationTypeExtractor;
import com.mulesoft.connectivity.linkweave.api.DataWeaveObjectReference;
import com.mulesoft.connectivity.linkweave.api.DataWeaveReference;
import com.mulesoft.connectivity.linkweave.api.loader.ConnectorLoader;
import com.mulesoft.connectivity.linkweave.api.loader.ModelLoader;
import com.mulesoft.connectivity.linkweave.api.model.connection.AuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.TestConnectionModel;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationModel;
import com.mulesoft.connectivity.linkweave.api.model.provider.MetadataProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.provider.ValueProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.trigger.TriggerModel;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.api.tooling.ts.ObjectType;

public class FlowConnectorLoader
extends ConnectorLoader<FlowConnectorModel, FlowConnectorModel.Builder, DataWeaveObjectReference> {
    private final ModelLoader<TestConnectionModel, TestConnectionModel.Builder, DataWeaveObjectReference> testConnectionLoader;
    private final ModelLoader<FlowConnectionProviderModel, FlowConnectionProviderModel.Builder, DataWeaveObjectReference> connectionProviderLoader;
    private final ModelLoader<OperationModel, OperationModel.Builder, DataWeaveObjectReference> operationLoader;
    private final ModelLoader<TriggerModel, TriggerModel.Builder, DataWeaveObjectReference> triggerLoader;
    private final ModelLoader<ValueProviderModel, ValueProviderModel.Builder, DataWeaveReference<?>> valueProviderLoader;
    private final ModelLoader<MetadataProviderModel, MetadataProviderModel.Builder, DataWeaveReference<?>> metadataProviderLoader;

    public FlowConnectorLoader(ModelLoader<FlowConnectionProviderModel, FlowConnectionProviderModel.Builder, DataWeaveObjectReference> connectionProviderLoader, ModelLoader<OperationModel, OperationModel.Builder, DataWeaveObjectReference> operationLoader, ModelLoader<TriggerModel, TriggerModel.Builder, DataWeaveObjectReference> triggerLoader, ModelLoader<TestConnectionModel, TestConnectionModel.Builder, DataWeaveObjectReference> testConnectionLoader, ModelLoader<ValueProviderModel, ValueProviderModel.Builder, DataWeaveReference<?>> valueProviderLoader, ModelLoader<MetadataProviderModel, MetadataProviderModel.Builder, DataWeaveReference<?>> metadataProviderLoader) {
        this.connectionProviderLoader = connectionProviderLoader;
        this.operationLoader = operationLoader;
        this.triggerLoader = triggerLoader;
        this.testConnectionLoader = testConnectionLoader;
        this.valueProviderLoader = valueProviderLoader;
        this.metadataProviderLoader = metadataProviderLoader;
    }

    public FlowConnectorModel.Builder createBuilder() {
        return new FlowConnectorModel.Builder();
    }

    public FlowConnectorModel.Builder configureBuilder(FlowConnectorModel.Builder builder, DataWeaveObjectReference connectorObject, @Nullable String name, @Nullable Object extraData) {
        if (!(connectorObject.getType() instanceof ObjectType)) {
            throw new IllegalStateException("Invalid connector type. Expected Object but " + String.valueOf(connectorObject.getType().getBaseType()) + " found");
        }
        connectorObject.getProperty("name").map(DataWeaveReference::asString).ifPresent(arg_0 -> ((FlowConnectorModel.Builder)builder).withName(arg_0));
        connectorObject.getProperty("displayName").map(DataWeaveReference::asString).ifPresent(arg_0 -> ((FlowConnectorModel.Builder)builder).withDisplayName(arg_0));
        ExtraData extra = (ExtraData)Objects.requireNonNull(extraData, "Extra data must be supplied to set the version and the release status");
        builder.withVersion(Objects.requireNonNull(extra.connectorVersion(), "A connector version must be provided as extra data"));
        builder.withReleaseStatus(Objects.requireNonNull(extra.releaseStatus(), "A connector release status must be provided as extra data"));
        connectorObject.getProperty("releaseStatus").map(DataWeaveReference::asString).ifPresent(releaseStatus -> builder.withReleaseStatus(ReleaseStatus.fromString(releaseStatus)));
        connectorObject.getProperty("description").map(DataWeaveReference::asString).ifPresent(builder::withDescription);
        connectorObject.getProperty("vendor").map(DataWeaveReference::asString).ifPresent(builder::withVendor);
        connectorObject.getProperty("since").map(DataWeaveReference::asString).ifPresentOrElse(builder::withSince, () -> {
            if (extra.since != null) {
                builder.withSince(extra.since);
            }
        });
        builder.withModelReference(connectorObject.getPath());
        ArrayList<IconMetadata> icons = new ArrayList<IconMetadata>();
        connectorObject.getProperty("icons").map(DataWeaveReference::getValue).ifPresent(modelIcons -> {
            for (Object iconData : (List)modelIcons) {
                Map modelIcon = (Map)iconData;
                String iconName = (String)modelIcon.get("name");
                String alternateText = (String)modelIcon.get("alternateText");
                String resource = (String)modelIcon.get("resource");
                IconMetadata iconMetadata = new IconMetadata.Builder().withName(iconName).withAlternateText(alternateText).withResource(resource).build();
                icons.add(iconMetadata);
            }
        });
        builder.withIcons(icons);
        List<FlowConnectionProviderModel> connections = connectorObject.requireObjectProperty("connections").properties().map(e -> (FlowConnectionProviderModel)this.connectionProviderLoader.loadModel((DataWeaveReference)((DataWeaveReference)e.getValue()).asObjectReference(), (String)e.getKey())).toList();
        FlowConnectorLoader.validateConnections(connections);
        builder.withConnections(connections);
        connectorObject.getObjectProperty("testConnection").ifPresent(tc -> builder.withTestConnection((TestConnectionModel)this.testConnectionLoader.loadModel((DataWeaveReference)tc, null)));
        DataWeaveObjectReference operationObject = connectorObject.requireObjectProperty("operations");
        builder.withOperations(operationObject.properties().map(e -> (OperationModel)this.operationLoader.loadModel((DataWeaveReference)((DataWeaveReference)e.getValue()).asObjectReference(), null)).toList());
        connectorObject.getObjectProperty("triggers").ifPresent(trigger -> builder.withTriggers(trigger.properties().map(e -> (TriggerModel)this.triggerLoader.loadModel((DataWeaveReference)((DataWeaveReference)e.getValue()).asObjectReference(), (String)e.getKey())).toList()));
        connectorObject.getObjectProperty("valueProviders").ifPresent(vp -> builder.withValueProviders(vp.properties().map(e -> (ValueProviderModel)this.valueProviderLoader.loadModel((DataWeaveReference)e.getValue(), (String)e.getKey())).toList()));
        connectorObject.getObjectProperty("metadataProviders").ifPresent(vp -> builder.withMetadataProviders(vp.properties().map(e -> (MetadataProviderModel)this.metadataProviderLoader.loadModel((DataWeaveReference)e.getValue(), (String)e.getKey())).toList()));
        return builder;
    }

    private static void validateConnections(List<FlowConnectionProviderModel> connections) {
        HashMap<CallSite, String> authKeyToConnectionName = new HashMap<CallSite, String>();
        for (FlowConnectionProviderModel connection : connections) {
            String subType;
            AuthenticationTypeExtractor extractor;
            String type;
            String key;
            String existing;
            AuthenticationType authenticationType = connection.getAuthenticationType();
            if (authenticationType == null || (existing = authKeyToConnectionName.putIfAbsent((CallSite)((Object)(key = (type = (extractor = AuthenticationTypeExtractor.getFrom(authenticationType)).getType().name()) + "|" + (subType = Optional.ofNullable(extractor.getSubType()).orElse("")))), connection.getName())) == null) continue;
            throw new IllegalStateException("Multiple connections found with the same authentication type and subtype: type='" + type + "' subtype='" + (subType.isEmpty() ? "null" : subType) + "' (connections '" + existing + "' and '" + connection.getName() + "')");
        }
    }

    public record ExtraData(String connectorVersion, ReleaseStatus releaseStatus, @Nullable String since) {
        public ExtraData(String connectorVersion, ReleaseStatus releaseStatus) {
            this(connectorVersion, releaseStatus, null);
        }
    }
}

